/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto;

import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.service.ProtestoRemessaItemService;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EnvioProtestoRemessaBatchProcessor
implements ItemProcessor<Protesto, ProtestoRemessaItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvioProtestoRemessaBatchProcessor.class);
    private static final String ID_PROTESTO_REMESSA = "idProtestoRemessa";
    private final ProtestoRemessaService protestoRemessaService;
    private final ProtestoRemessaItemService protestoRemessaItemService;
    private ProtestoRemessa protestoRemessa;
    private AtomicLong sequencia;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.protestoRemessa = (ProtestoRemessa)this.protestoRemessaService.findOne((Serializable)stepExecution.getJobParameters().getLong(ID_PROTESTO_REMESSA));
        this.sequencia = new AtomicLong(this.protestoRemessaItemService.findNextSequence(this.protestoRemessa.getEntidade(), this.protestoRemessa.getExercicio(), this.protestoRemessa.getRemessa()));
    }

    public ProtestoRemessaItem process(@Nullable Protesto protesto) throws Exception {
        if (Objects.isNull(protesto)) {
            return null;
        }
        log.debug("Criando item de remessa para o protesto com id {}", (Object)protesto.getId());
        return this.protestoRemessaItemService.create(this.protestoRemessa, protesto, Long.valueOf(this.sequencia.getAndIncrement()));
    }

    @Generated
    public EnvioProtestoRemessaBatchProcessor(ProtestoRemessaService protestoRemessaService, ProtestoRemessaItemService protestoRemessaItemService) {
        this.protestoRemessaService = protestoRemessaService;
        this.protestoRemessaItemService = protestoRemessaItemService;
    }
}

