/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.documento.cda.DebitoGeracaoCdaDTO;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class SimulacaoLoteCdaBatchReader
extends JdbcCursorItemReader<DebitoGeracaoCdaDTO> {
    public SimulacaoLoteCdaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ObjectMapper objectMapper) throws JsonProcessingException {
        Long entidade = (Long)jobParameters.get("entidade");
        String filtro = ((GeracaoLoteCdaDTO)objectMapper.readValue((String)jobParameters.get("geracaoLoteCdaDto"), GeracaoLoteCdaDTO.class)).filterWithValues();
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/find-debito-geracao-cda.sql").replace(":entidade", entidade.toString()).replace("$[FILTROS]", filtro);
        this.setFetchSize(1000);
        this.setName("debitoGeracaoCda");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(DebitoGeracaoCdaDTO.class));
        this.setSql(sql);
    }
}

