SELECT
    filtro.iddebito                                       AS iddebito,
    filtro.exercicio                                      AS exercicio,
    filtro.tipocadastro                                   AS tipocadastro,
    filtro.cadastrogeral                                  AS cadastrogeral,
    filtro.tipodivida                                     AS tipodivida,
    filtro.subdivida                                      AS subdivida ,
    SUM(filtro.valorArquivo)                              AS valorArquivo,
    SUM(filtro.valorIntegrado)                            AS valorIntegrado,
    SUM(filtro.valorArquivo) - SUM(filtro.valorIntegrado) AS valorDiferenca
FROM
    (
        SELECT
            td.exercicio                               AS exercicio,
            tc.descricao                               AS tipocadastro,
            td.cadastrogeral                           AS cadastrogeral,
            tgr.descricao                              AS tipodivida,
            td.subdivida                               AS subdivida,
            SUM(liic.valortributo - liic.valordeducao) AS valorIntegrado,
            0                                          AS valorArquivo,
            td.iddebito                                AS iddebito
        FROM loteintegracaocontabil lic
                 JOIN loteitemintegracaocontabil liic ON lic.id = liic.idlote
                 JOIN tribdebito td ON liic.iddebito = td.iddebito
                 JOIN tribguiarecolhimento tgr ON td.entidade = tgr.entidade AND td.exercicio = tgr.exercicio
                                                    AND td.guiarecolhimento = tgr.guiarecolhimento
                 JOIN tribtipocadastro tc ON tc.tipocadastro = td.tipocadastro
                 JOIN tribreceita tr ON liic.idtributo = tr.id
                 JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
        WHERE lic.datalote between :dataInicial AND :dataFinal
          AND trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          AND lic.situacaointegracaocontabil <> 'ESTORNADO_CONTABILIDADE'
          AND lic.tipolote = 'ESTORNO_PAGAMENTO'
          AND liic.idtipooperacaodeducao <> 3
        GROUP BY td.iddebito, td.subdivida,  td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao
    union all
        SELECT
            td.exercicio                AS exercicio,
            tc.descricao                AS tipocadastro,
            td.cadastrogeral            AS cadastrogeral,
            tgr.descricao               AS tipodivida,
            td.subdivida                AS subdivida,
            0                           AS valorIntegrado,
            SUM(COALESCE(atcp.valor,0)) AS valorArquivo,
            td.iddebito                 AS iddebito
        FROM tceArrecadacaoTipoCreditoEst       atc
            JOIN tceArrTipoCreditoPagamentoEst atcp ON atcp.idtcearrtipocreditoEst = atc.idtcearrtipocreditoEst
            JOIN tribpagamentodebito           tpd  ON tpd.iddebitoparcelareceita = atcp.iddebitoparcelareceita
                                                        AND tpd.idpagamentobloqueto = atcp.idpagamentobloqueto
            JOIN tribpagamentobloqueto         tpb  ON tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
            JOIN tribpagamento                 tpag ON tpag.entidade = tpb.entidade AND tpag.pagamento = tpb.pagamento
                                                        AND tpag.exerciciopagamento = tpb.exerciciopagamento
            JOIN tribdebitoparcelareceita      tdpr ON tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
            JOIN tribdebito                    td   ON tdpr.entidade = td.entidade AND td.tipocadastro = tdpr.tipocadastro
                                                        AND td.cadastrogeral = tdpr.cadastrogeral AND tdpr.guiarecolhimento = td.guiarecolhimento
                                                        AND td.exercicio = tdpr.exercicio AND td.subdivida = tdpr.subdivida
            JOIN tribtipocadastro              tc   ON tc.tipocadastro = tdpr.tipocadastro
            JOIN tribguiarecolhimento          tgr  ON tdpr.entidade = tgr.entidade AND tdpr.exercicio = tgr.exercicio
                                                        AND tdpr.guiarecolhimento = tgr.guiarecolhimento
        WHERE atc.nrmes = EXTRACT(month FROM CAST(:dataInicial AS DATE))
          AND atc.nrano = EXTRACT(year FROM CAST(:dataFinal AS DATE))
        GROUP BY td.iddebito, td.subdivida,  td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao
    UNION ALL
        SELECT td.exercicio                 AS exercicio,
            tc.descricao                    AS tipocadastro,
            td.cadastrogeral                AS cadastrogeral,
            tgr.descricao                   AS tipodivida,
            td.subdivida                    AS subdivida,
            0                               AS valorIntegrado,
            SUM(COALESCE(atcc.valor,0))     AS valorArquivo,
            td.iddebito                     AS iddebito
        FROM tceArrecadacaoTipoCreditoEst       atc
            JOIN tceArrTipoCreditoCreditoEst   atcc ON atcc.idtcearrtipocreditoEst = atc.idtcearrtipocreditoEst
            JOIN tribCreditoContribuinteItem   tcci ON tcci.idcreditocontribuinteitem = atcc.idcreditocontribuinteitem
                                                        AND tcci.iddebitoparcelareceita = atcc.iddebitoparcelareceita
            JOIN tribcreditocontribuinte       tcc  ON tcc.entidade = tcci.entidade AND tcc.exercicio = tcci.exercicio
                                                        AND tcc.creditocontribuinte = tcci.creditocontribuinte
            JOIN tribdebitoparcelareceita      tdpr ON tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
            JOIN tribdebito                    td   ON tdpr.entidade = td.entidade AND td.tipocadastro = tdpr.tipocadastro
                                                        AND td.cadastrogeral = tdpr.cadastrogeral AND tdpr.guiarecolhimento = td.guiarecolhimento
                                                        AND td.exercicio = tdpr.exercicio AND td.subdivida = tdpr.subdivida
            JOIN tribtipocadastro              tc   ON tc.tipocadastro = tdpr.tipocadastro
            JOIN tribguiarecolhimento          tgr  ON tdpr.entidade = tgr.entidade AND tdpr.exercicio = tgr.exercicio
                                                        AND tdpr.guiarecolhimento = tgr.guiarecolhimento
        WHERE atc.nrmes = EXTRACT(month FROM CAST(:dataInicial AS DATE))
          AND atc.nrano = EXTRACT(year FROM CAST(:dataFinal AS DATE))
        GROUP BY td.iddebito, td.subdivida,  td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao
    UNION ALL
        SELECT td.exercicio               AS exercicio,
            tc.descricao                  AS tipocadastro,
            td.cadastrogeral              AS cadastrogeral,
            tgr.descricao                 AS tipodivida,
            td.subdivida                  AS subdivida,
            0                             AS valorIntegrado,
            SUM(COALESCE(atcd.valor,0))   AS valorArquivo,
            td.iddebito                   AS iddebito
        FROM tceArrecadacaoTipoCreditoEst       atc
            JOIN tcearrtipocreditodevolucaoEst atcd ON atcd.idtcearrtipocreditoEst = atc.idtcearrtipocreditoEst
            JOIN tribDevolucaoCreditoDebito tdcd ON tdcd.idDevolucaoCredito = atcd.idDevolucaoCredito
            										AND tdcd.sequenciaItem = atcd.sequenciaItem
            										AND tdcd.sequenciaDebito = atcd.sequenciaDebito
            JOIN tribdebitoparcelareceita   tdpr ON tdpr.iddebitoparcelareceita = tdcd.iddebitoparcelareceita
            JOIN tribdebito                    td   ON tdpr.entidade = td.entidade AND td.tipocadastro = tdpr.tipocadastro
                                                        AND td.cadastrogeral = tdpr.cadastrogeral AND tdpr.guiarecolhimento = td.guiarecolhimento
                                                        AND td.exercicio = tdpr.exercicio AND td.subdivida = tdpr.subdivida
            JOIN tribtipocadastro              tc   ON tc.tipocadastro = tdpr.tipocadastro
            JOIN tribguiarecolhimento          tgr  ON tdpr.entidade = tgr.entidade AND tdpr.exercicio = tgr.exercicio
                                                        AND tdpr.guiarecolhimento = tgr.guiarecolhimento
        WHERE atc.nrmes = EXTRACT(month FROM CAST(:dataInicial AS DATE))
          AND atc.nrano = EXTRACT(year FROM CAST(:dataFinal AS DATE))
        GROUP BY td.iddebito, td.subdivida,  td.exercicio, tc.descricao, td.cadastrogeral, tgr.descricao
    ) filtro
WHERE :whereParam
GROUP BY exercicio, tipocadastro, cadastrogeral, tipodivida, subdivida, iddebito
HAVING :comDiferencaParam
ORDER BY :sortParam