 Select dp.entidade,
        dp.exercicio,
        dp.tipocadastro,
        dp.cadastrogeral,
        dp.guiarecolhimento as divida,
        dp.subdivida,
        dp.parcela,
        dp.DataVencimento,
        sum(dpr.Valor) as valor,
        case when d.Parcelado = 'S' 
        	then 1
            else 0
        end as parcelado,
       	case when d.Reparcelado = 'S' 
       		then 1
            else 0
        end as reparcelado, 
        (select con.idcontencioso
           from tribcontenciosodebito con
           join tribcontencioso tcon on tcon.idcontencioso = con.idcontencioso
          where con.entidade = dp.entidade
            and con.exercicio = dp.exercicio
            and con.tipocadastro = dp.tipocadastro
            and con.cadastrogeral = dp.cadastrogeral
            and con.guiarecolhimento = dp.guiarecolhimento
            and con.subdivida = dp.subdivida
            and con.situacao = 'A'
            and tcon.situacao = 'A') as idcontencioso,
        case when sp.tiposituacaoparcela in (22, 23, 24)
          then 1
          else 0
        end recursoAdministrativo
   from tribdebito d
   join tribcadastrogeral tcg on d.TipoCadastro = tcg.TipoCadastro
                             and d.CadastroGeral = tcg.CadastroGeral
   join tribdebitoparcela dp on dp.entidade = d.entidade
                            and dp.exercicio = d.exercicio
                            and dp.tipocadastro = d.tipocadastro
                            and dp.cadastrogeral = d.cadastrogeral
                            and dp.guiarecolhimento = d.guiarecolhimento
                            and dp.subdivida = d.subdivida
   join tribsituacaoparcela sp on sp.situacaoparcela = dp.situacaodebito
   join tribTipoSituacaoparcela ttsp on sp.Tiposituacaoparcela = ttsp.Tiposituacaoparcela
   join tribdebitoparcelareceita dpr on dpr.entidade = dp.entidade
                                    and dpr.exercicio = dp.exercicio
                                    and dpr.tipocadastro = dp.tipocadastro
                                    and dpr.cadastrogeral = dp.cadastrogeral
                                    and dpr.guiarecolhimento = dp.guiarecolhimento
                                    and dpr.subdivida = dp.subdivida
                                    and dpr.parcela = dp.parcela
   join pessoa p on tcg.pessoa = p.pessoa
  where ttsp.Tipo = 'A'
    and d.Constituido = 'S'
    and tcg.ExclusaoLogica = 'N'
    and tcg.idkey = :id
  group by dp.entidade,
           dp.exercicio,
           dp.tipocadastro,
           dp.cadastrogeral,
           dp.guiarecolhimento,
           dp.subdivida,
           dp.parcela,
           dp.DataVencimento,
           d.REPARCELADO,
           d.PARCELADO,
           d.idcontencioso,
           sp.tiposituacaoparcela