select
       tl.entidade,
       tl.DATAINCLUSAO AS datamovimentacao,
       tdpr.receita as tributo,
       tr.descricao as descricaotributo,
       tr.classificacao as classificacaotributo,
       1 as situacaolegal,
       cast(null as numeric(10)) as tipooperacaodeducao,
       'INSCRICAO' as tipomovimento,
       td.iddebito,
       tr.tiporeceita as tipotributo,
       tlpr.iddebitoparcelareceita,
       sum(tdpr.valororiginal) as valor
from triblivro tl
left outer join triblivroregistro tlr
 on tlr.entidade = tl.entidade
and tlr.exercicio = tl.exercicio
and tlr.livro = tl.livro
left outer join triblivroparcelareceita tlpr
 on tlpr.entidade = tlr.entidade
and tlpr.exercicio = tlr.exercicio
and tlpr.livro = tlr.livro
and tlpr.sequencia = tlr.sequencia
left outer join tribdebitoparcelareceita tdpr
 on tdpr.iddebitoparcelareceita = tlpr.iddebitoparcelareceita
left outer join tribdebitoreceita tdr
 on tdpr.entidade         = tdr.entidade
and tdpr.exercicio        = tdr.exercicio
and tdpr.tipocadastro     = tdr.tipocadastro
and tdpr.cadastrogeral    = tdr.cadastrogeral
and tdpr.guiarecolhimento = tdr.guiarecolhimento
and tdpr.subdivida        = tdr.subdivida
and tdpr.receita          = tdr.receita
left outer join tribdebito td
 on tdpr.entidade = td.entidade
and tdpr.exercicio = td.exercicio
and tdpr.tipocadastro = td.tipocadastro
and tdpr.cadastrogeral = td.cadastrogeral
and tdpr.guiarecolhimento = td.guiarecolhimento
and tdpr.subdivida = td.subdivida
left outer join tribreceita tr
 on tdr.entidade  = tr.entidade
and :exercicio = tr.exercicio
and tdr.receita   = tr.receita
where tl.datainclusao in (:datasMovimento)
  AND tlpr.valororiginal > 0
  and not exists (select 1
                  from triblivroestornoparcelareceita tlpre
                           inner join triblivroestorno tle on tlpre.idlivroestorno = tle.idlivroestorno
                  where tle.dataestorno = tl.datainclusao
                    and tlpr.entidade = tlpre.entidade
                    and tlpr.exercicio = tlpre.exercicio
                    and tlpr.livro = tlpre.livro
                    and tlpr.sequencia = tlpre.sequencia
                    and tlpr.iddebitoparcelareceita = tlpre.iddebitoparcelareceita)
group by
       tl.entidade,
       tl.DATAINCLUSAO,
       tdpr.receita,
       tr.descricao,
       tr.classificacao,
       td.iddebito,
       tlpr.iddebitoparcelareceita,
       tr.tiporeceita