SELECT DEBITOPARCELARECEITA.RECEITA                     AS tributo,
       SUM(COALESCE(PAGAMENTODEBITO.VALORPRINCIPAL, 0) * -1) AS valorPrincipal,
       SUM(COALESCE(PAGAMENTODEBITO.VALORJUROS, 0) * -1)     AS valorJuros,
       SUM(COALESCE(PAGAMENTODEBITO.VALORMULTA, 0) * -1)     AS valorMulta,
       SUM(COALESCE(PAGAMENTODEBITO.VALORCORRECAO, 0) * -1)  AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(PAGAMENTODEBITO.VALORDESCONTOMULTA, 0)
               + COALESCE(VALORDESCONTOCORRECAO, 0)) > 0
               THEN SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                        COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROS, 0) +
                        COALESCE(PAGAMENTODEBITO.VALORDESCONTOMULTA, 0) +
                        COALESCE(VALORDESCONTOCORRECAO, 0)) * -1
           ELSE SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTO, 0) * -1)
           END                                          AS valorDesconto
FROM TRIBESTORNOPAGAMENTO ESTORNOPAGAMENTO
         LEFT OUTER JOIN TRIBESTORNOPAGAMENTOITEM ESTORNOPAGAMENTOITEM
                         ON ESTORNOPAGAMENTO.ENTIDADE = ESTORNOPAGAMENTOITEM.ENTIDADE AND
                            ESTORNOPAGAMENTO.EXERCICIO = ESTORNOPAGAMENTOITEM.EXERCICIO AND
                            ESTORNOPAGAMENTO.ESTORNO = ESTORNOPAGAMENTOITEM.ESTORNO
         LEFT OUTER JOIN TRIBPAGAMENTODEBITO PAGAMENTODEBITO
                         ON ESTORNOPAGAMENTOITEM.IDPAGAMENTOBLOQUETO = PAGAMENTODEBITO.IDPAGAMENTOBLOQUETO AND
                            ESTORNOPAGAMENTOITEM.IDDEBITOPARCELARECEITA = PAGAMENTODEBITO.IDDEBITOPARCELARECEITA
         LEFT OUTER JOIN CONTABANCARIA
         				 ON CONTABANCARIA.ENTIDADE = ESTORNOPAGAMENTO.ENTIDADE AND
         				    CONTABANCARIA.CONTABANCARIA = ESTORNOPAGAMENTO.CONTABANCARIAESTORNO
         LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                         ON PAGAMENTODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT OUTER JOIN TRIBRECEITA RECEITA
                         ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                            RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                            RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
WHERE ESTORNOPAGAMENTO.DATAREABILITACAO = :dataLancamento
  AND ESTORNOPAGAMENTO.REABILITADO = 'S'
  AND ESTORNOPAGAMENTO.DATAREABILITACAO <> ESTORNOPAGAMENTO.DATA
%s
GROUP BY DEBITOPARCELARECEITA.RECEITA