/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.domain.sanepar.SaneparConfiguracao;
import br.com.elotech.tributos.domain.sanepar.SaneparMatricula;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.sanepar.SaneparConfiguracaoService;
import br.com.elotech.tributos.service.sanepar.SaneparMatriculaService;
import br.com.elotech.tributos.service.sanepar.VerificacaoSaneparService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GeracaoDebitoBoletoSaneparService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeracaoDebitoBoletoSaneparService.class);
    private final GeraDebitoService geraDebitoService;
    private final DebitoService debitoService;
    private final GeraBoletoService geraBoletoService;
    private final SaneparConfiguracaoService saneparConfiguracaoService;
    private final SaneparMatriculaService saneparMatriculaService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final EntityManager entityManager;
    private final VerificacaoSaneparService verificacaoSaneparService;
    private final String SUCCESS_MESSAGE_TEMPLATE = "%s Gerado";
    private final String ERROR_MESSAGE_TEMPLATE = "Erro ao gerar %s. Erro: %s";

    public void gerarDebitoEBoleto(BaixaSaneparItem item) {
        this.geraNovoDebito(item);
        if (this.temDebitoGerado(item)) {
            this.geraNovoBoleto(item);
        }
    }

    private void geraNovoDebito(BaixaSaneparItem item) {
        if (Boolean.FALSE.equals(item.getSituacao().permiteGerarDebito()) || item.getDebito() != null) {
            return;
        }
        try {
            log.debug("Gerando d\u00e9bito para o registro: Lote: [{}] Matr\u00edcula: [{}] Linha: [{}]", new Object[]{item.getBaixa().getId(), item.getMatricula(), item.getLinha()});
            Debito debito = this.novoDebito(item);
            this.atualizaItemComDebitoGerado(item, debito);
        }
        catch (Exception e) {
            log.error("Erro ao gerar d\u00e9bito para o registro: Lote: [{}] Matr\u00edcula: [{}] Linha: [{}]. Erro: [{}] ", new Object[]{item.getBaixa().getId(), item.getMatricula(), item.getLinha(), e.getMessage(), e});
            this.atualizaItemComErroNaGeracaoDeDebito(item, e);
        }
    }

    private Debito novoDebito(BaixaSaneparItem item) {
        SaneparConfiguracao configuracao = this.saneparConfiguracaoService.getConfiguracao(Long.valueOf(item.getBaixa().getDataLancamento().getYear()));
        List parcelas = this.geraParcelasDTO(item);
        List tributos = this.geraTributosDTO(item, configuracao);
        DebitoManualDTO dto = this.geraDebitoDTO(item, configuracao);
        dto.setParcelas(parcelas);
        dto.setTributos(tributos);
        dto.setUsuario(item.getBaixa().getUsuario());
        DebitoIdDTO idDTO = this.geraDebitoService.geraDebitoManualSanepar(dto);
        this.entityManager.flush();
        return (Debito)this.debitoService.findOne((Serializable)idDTO.getIdDebito());
    }

    private List<DebitoManualParcelaDTO> geraParcelasDTO(BaixaSaneparItem item) {
        DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
        parcela.setParcela(Long.valueOf(1L));
        parcela.setSituacao(Long.valueOf(1L));
        parcela.setSituacaoLegal(Long.valueOf(SituacaoLegal.NO_EXERCICIO.getCodigo().intValue()));
        parcela.setValor(item.getValor());
        parcela.setDataVencimento(item.getBaixa().getDataLancamento());
        parcela.setDataSituacao(item.getBaixa().getDataLancamento());
        parcela.setMesReferencia(Long.valueOf(item.getBaixa().getDataLancamento().getMonth().getValue()));
        parcela.setAnoReferencia(Long.valueOf(item.getBaixa().getDataLancamento().getYear()));
        parcela.setObservacao(String.format("Parcela gerada para %s do lote de Importa\u00e7\u00e3o Sanepar %s, matr\u00edcula %s, linha %s", item.getBaixa().getTipo().getDescricao().toLowerCase(), item.getBaixa().getId(), item.getMatricula(), item.getLinha()));
        return List.of(parcela);
    }

    private List<DebitoManualTributoDTO> geraTributosDTO(BaixaSaneparItem item, SaneparConfiguracao configuracao) {
        String tributoConfigurado = configuracao.getTributo(item.getBaixa().getTipo()).getTributo();
        DebitoManualTributoDTO tributo = new DebitoManualTributoDTO();
        tributo.setOrdem(Long.valueOf(1L));
        tributo.setTributo(tributoConfigurado);
        tributo.setValorTributo(item.getValor());
        return List.of(tributo);
    }

    private DebitoManualDTO geraDebitoDTO(BaixaSaneparItem item, SaneparConfiguracao configuracao) {
        Long dividaConfigurada = configuracao.getDivida(item.getBaixa().getTipo()).getDivida();
        SaneparMatricula matricula = this.getMatricula(item);
        CadastroGeral cadastroGeral = matricula.getCadastroGeral();
        FormaCorrecao formaCorrecao = this.getFormaCorrecao(dividaConfigurada, configuracao);
        Long subDivida = this.getSubDivida(cadastroGeral, configuracao, dividaConfigurada);
        String observacao = String.format("D\u00e9bito gerado para %s por meio do lote de Importa\u00e7\u00e3o Sanepar %s, matr\u00edcula %s, linha %s", item.getBaixa().getTipo().getDescricao().toLowerCase(), item.getBaixa().getId(), item.getMatricula(), item.getLinha());
        DebitoManualDTO debito = new DebitoManualDTO();
        debito.setExercicio(Long.valueOf(item.getBaixa().getDataLancamento().getYear()));
        debito.setTipoCadastro(cadastroGeral.getTipoCadastro());
        debito.setCadastroGeral(cadastroGeral.getCadastroGeral());
        debito.setDivida(dividaConfigurada);
        debito.setSubDivida(subDivida);
        debito.setDataLancamento(item.getBaixa().getDataLancamento());
        debito.setDataInclusao(item.getBaixa().getDataLancamento());
        debito.setFormaCorrecao(formaCorrecao.getId());
        debito.setObservacao(observacao);
        debito.setPrograma("BaixaSanepar");
        return debito;
    }

    private void geraNovoBoleto(BaixaSaneparItem item) {
        Debito debito = item.getDebito();
        if (Boolean.FALSE.equals(item.getSituacao().permiteGerarBoleto())) {
            return;
        }
        try {
            log.debug("Gerando boleto do D\u00e9bito: [{}] Lote: [{}] Matr\u00edcula: [{}] Linha: [{}] ", new Object[]{debito.getId(), item.getBaixa().getId(), item.getMatricula(), item.getLinha()});
            Bloqueto boleto = this.novoBoleto(item);
            this.atualizaItemComBoletoGerado(item, boleto);
        }
        catch (Exception e) {
            log.error("Erro ao gerar boleto do D\u00e9bito: [{}] Lote: [{}] Matr\u00edcula: [{}] Linha: [{}]. Erro: [{}]  ", new Object[]{debito.getId(), item.getBaixa().getId(), item.getMatricula(), item.getLinha(), e.getMessage(), e});
            this.atualizaItemComErroNaGeracaoDeBoleto(item, e);
        }
    }

    private Bloqueto novoBoleto(BaixaSaneparItem item) {
        Debito debito = item.getDebito();
        GeraBoletoDTO dto = new GeraBoletoDTO();
        dto.setTipoBoleto(TipoBloqueto.PARCELADO);
        dto.setOrigemEmissao(OrigemEmissao.AISE);
        dto.setDebitos(Collections.singletonList(DebitoParcelaDTO.fromUltimaParcelaDebito((Debito)debito)));
        dto.setDataReferencia(item.getBaixa().getDataLancamento());
        dto.setUsuario(item.getBaixa().getUsuario());
        dto.setExercicio(debito.getExercicio());
        dto.setObservacao(String.format("Boleto referente ao d\u00e9bito %s para %s do lote de Importa\u00e7\u00e3o Sanepar %s, matr\u00edcula %s, linha %s", debito.getId(), item.getBaixa().getTipo().getDescricao(), item.getBaixa().getId(), item.getMatricula(), item.getLinha()));
        dto.setUsaExercicioEspecificado(Boolean.TRUE);
        Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoletoSanepar(dto).get(0);
        this.entityManager.flush();
        return boleto;
    }

    private SaneparMatricula getMatricula(BaixaSaneparItem item) {
        this.verificacaoSaneparService.validate(item);
        List matriculas = this.saneparMatriculaService.findAllByMatricula(item.getMatricula());
        return (SaneparMatricula)matriculas.get(0);
    }

    private FormaCorrecao getFormaCorrecao(Long idDivida, SaneparConfiguracao configuracao) {
        return this.formaCorrecaoService.getFormaCorrecaoPadrao(idDivida, configuracao.getEntidade(), configuracao.getExercicio());
    }

    private Long getSubDivida(CadastroGeral cadastroGeral, SaneparConfiguracao configuracao, Long dividaConfigurada) {
        NextSubdividaValueParams params = NextSubdividaValueParams.of((Long)cadastroGeral.getTipoCadastro().getValue(), (Long)cadastroGeral.getCadastroGeral(), (Long)configuracao.getExercicio(), (Long)dividaConfigurada);
        return this.debitoService.getNextValueSubdivida(params);
    }

    private void atualizaItemComDebitoGerado(BaixaSaneparItem item, Debito debito) {
        item.setDebito(debito);
        item.setParcela(debito.getNumeroParcela());
        item.setSituacao(SituacaoItemSanepar.DEBITO_GERADO);
        item.setMensagem(String.format("%s Gerado", "D\u00e9bito"));
    }

    private void atualizaItemComErroNaGeracaoDeDebito(BaixaSaneparItem item, Exception exception) {
        item.setDebito(null);
        item.setParcela(null);
        item.setSituacao(SituacaoItemSanepar.ERRO_GERACAO_DEBITO);
        item.setMensagem(String.format("Erro ao gerar %s. Erro: %s", "d\u00e9bito", exception.getMessage()));
    }

    private void atualizaItemComBoletoGerado(BaixaSaneparItem item, Bloqueto boleto) {
        item.setBoleto(boleto);
        item.setSituacao(SituacaoItemSanepar.BOLETO_GERADO);
        item.setMensagem(String.format("%s Gerado", "Boleto"));
    }

    private void atualizaItemComErroNaGeracaoDeBoleto(BaixaSaneparItem item, Exception exception) {
        item.setBoleto(null);
        item.setSituacao(SituacaoItemSanepar.ERRO_GERACAO_BOLETO);
        item.setMensagem(String.format("Erro ao gerar %s. Erro: %s", "boleto", exception.getMessage()));
    }

    private boolean temDebitoGerado(BaixaSaneparItem item) {
        return Objects.nonNull(item.getDebito());
    }

    @Generated
    public GeracaoDebitoBoletoSaneparService(GeraDebitoService geraDebitoService, DebitoService debitoService, GeraBoletoService geraBoletoService, SaneparConfiguracaoService saneparConfiguracaoService, SaneparMatriculaService saneparMatriculaService, FormaCorrecaoService formaCorrecaoService, EntityManager entityManager, VerificacaoSaneparService verificacaoSaneparService) {
        this.geraDebitoService = geraDebitoService;
        this.debitoService = debitoService;
        this.geraBoletoService = geraBoletoService;
        this.saneparConfiguracaoService = saneparConfiguracaoService;
        this.saneparMatriculaService = saneparMatriculaService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.entityManager = entityManager;
        this.verificacaoSaneparService = verificacaoSaneparService;
    }
}

