/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.sanepar.BaixaSanepar;
import br.com.elotech.tributos.domain.sanepar.SaneparConfiguracao;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteManualDTO;
import br.com.elotech.tributos.dto.sanepar.BaixaSaneparItemDTO;
import br.com.elotech.tributos.dto.sanepar.BaixaSaneparTotalizadorDTO;
import br.com.elotech.tributos.dto.sanepar.ImportacaoBaixaSaneparDTO;
import br.com.elotech.tributos.enums.sanepar.SituacaoBaixaSanepar;
import br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar;
import br.com.elotech.tributos.report.loader.ConsistenciaBaixaParamLoader;
import br.com.elotech.tributos.repository.sanepar.BaixaSaneparItemRepository;
import br.com.elotech.tributos.repository.sanepar.BaixaSaneparRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.PagamentoLoteManualService;
import br.com.elotech.tributos.service.sanepar.SaneparConfiguracaoService;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BaixaSaneparService
extends CrudService<BaixaSanepar, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaixaSaneparService.class);
    private static final List<SituacaoItemSanepar> SITUACAO_BAIXA_ERRORS_SANEPAR_LIST = List.of(SituacaoItemSanepar.ERRO_IMPORTACAO, SituacaoItemSanepar.ERRO_GERACAO_BOLETO, SituacaoItemSanepar.ERRO_GERACAO_DEBITO, SituacaoItemSanepar.ERRO_GERACAO_PAGAMENTO, SituacaoItemSanepar.ERRO_VALIDACAO);
    private final BaixaSaneparRepository repository;
    private final BaixaSaneparItemRepository baixaSaneparItemRepository;
    private final PagamentoLoteManualService pagamentoLoteService;
    private final ContextService contextService;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final SaneparConfiguracaoService saneparConfiguracaoService;
    private final ConsistenciaBaixaParamLoader consistenciaBaixaParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ObjectMapper objectMapper;

    public Optional<BaixaSanepar> findByHash(String hash) {
        return this.repository.findByHash(hash);
    }

    public BaixaSanepar createLoteAberto(ImportacaoBaixaSaneparDTO importacaoDto, String nomeArquivo, String usuario) {
        SaneparConfiguracao configuracao = this.saneparConfiguracaoService.getConfiguracao(Long.valueOf(importacaoDto.getDataLancamento().getYear()));
        Long convenio = Optional.ofNullable(configuracao).map(SaneparConfiguracao::getConvenio).map(Convenio::getId).orElseThrow(() -> new EloValidationException("A configura\u00e7\u00e3o de baixa da Sanepar n\u00e3o possui conv\u00eanio informado."));
        BaixaSanepar baixa = new BaixaSanepar();
        baixa.setTipo(importacaoDto.getTipo());
        baixa.setUsuario(usuario);
        baixa.setDataInclusao(LocalDate.now());
        baixa.setDataLancamento(importacaoDto.getDataLancamento());
        baixa.setNomeArquivo(nomeArquivo);
        baixa.setSituacao(SituacaoBaixaSanepar.CRIADO);
        this.save((EloEntity)baixa, null);
        PagamentoLote lotePagamento = this.createLotePagamento(baixa, importacaoDto, nomeArquivo, convenio);
        baixa.setLote(lotePagamento);
        return (BaixaSanepar)this.save((EloEntity)baixa, null);
    }

    private PagamentoLote createLotePagamento(BaixaSanepar baixa, ImportacaoBaixaSaneparDTO importacaoDto, String nomeArquivo, Long convenio) {
        PagamentoLoteManualDTO loteManual = new PagamentoLoteManualDTO();
        loteManual.setEntidade(this.contextService.getEntidadePrincipal());
        loteManual.setExercicio(Long.valueOf(importacaoDto.getDataLancamento().getYear()));
        loteManual.setDataLote(importacaoDto.getDataLancamento());
        loteManual.setDataMovimento(importacaoDto.getDataLancamento());
        loteManual.setDataCredito(importacaoDto.getDataLancamento());
        loteManual.setConvenio(convenio);
        loteManual.setObservacao(String.format("Lote gerado pela importa\u00e7\u00e3o do arquivo da sanepar %s que gerou a baixa numero %d.", nomeArquivo, baixa.getId()));
        this.pagamentoLoteService.validaMovimentacaoDiaria(loteManual);
        return this.pagamentoLoteService.createPagamentoLote(loteManual);
    }

    public BaixaSanepar limparHash(Long idBaixa) {
        BaixaSanepar baixa = this.getBaixa(idBaixa);
        baixa.setHash(null);
        baixa.setSituacao(SituacaoBaixaSanepar.ERRO_IMPORTACAO);
        return (BaixaSanepar)this.save((EloEntity)baixa, null);
    }

    public BaixaSanepar uploadArquivo(BaixaSanepar baixaSanepar, MultipartFile file, String hash) {
        HashMap<String, String> metadados = new HashMap<String, String>();
        metadados.put("idBaixa", baixaSanepar.getId().toString());
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, file.getOriginalFilename(), SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/baixa-sanepar", LocalDate.now(), "text/plain", null, null, metadados);
        ArquivoDTO result = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, file);
        baixaSanepar.setHash(hash);
        baixaSanepar.setIdArquivo(result.getId());
        return (BaixaSanepar)this.save((EloEntity)baixaSanepar, null);
    }

    public Page<BaixaSaneparItemDTO> searchItens(Long idBaixa, String search, Pageable pageable) {
        String queryIdBaixa = String.format("baixa.id==%d", idBaixa);
        String queryFinal = StringUtils.isBlank((CharSequence)search) ? queryIdBaixa : String.format("(%s) and (%s)", queryIdBaixa, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)queryFinal);
        return this.baixaSaneparItemRepository.findAll(specification, pageable).map(BaixaSaneparItemDTO::from);
    }

    public void finalizarImportacao(Long idBaixa) {
        BaixaSanepar baixa = this.getBaixa(idBaixa);
        baixa.setSituacao(SituacaoBaixaSanepar.IMPORTADO);
        this.save((EloEntity)baixa, null);
    }

    private BaixaSanepar getBaixa(Long idBaixa) {
        return (BaixaSanepar)this.findById((Serializable)idBaixa).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a baixa com o id %d.", idBaixa)));
    }

    public void iniciarImportacao(Long idBaixa) {
        BaixaSanepar baixa = this.getBaixa(idBaixa);
        baixa.setSituacao(SituacaoBaixaSanepar.IMPORTANDO);
        this.save((EloEntity)baixa, null);
    }

    public BaixaSaneparTotalizadorDTO getTotalizador(Long idBaixa) {
        BaixaSanepar baixa = this.getBaixa(idBaixa);
        return this.repository.getTotalizador(baixa);
    }

    public List<BaixaSaneparItemDTO> findAllItemErrorsByIdBaixa(Long idBaixa) {
        BaixaSanepar baixa = this.getBaixa(idBaixa);
        List baixaSaneparItems = this.baixaSaneparItemRepository.findAllByBaixaAndSituacaoIn(baixa, SITUACAO_BAIXA_ERRORS_SANEPAR_LIST);
        if (baixaSaneparItems.isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar items para a baixa com o id %d.", idBaixa));
        }
        return baixaSaneparItems.stream().map(BaixaSaneparItemDTO::fromWithReportData).collect(Collectors.toList());
    }

    public byte[] imprimirInconsistenciaArquivoBaixa(Long idBaixa) {
        List baixaSaneparItems = this.findAllItemErrorsByIdBaixa(idBaixa);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)baixaSaneparItems, BaixaSaneparItemDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.consistenciaBaixaParamLoader).build();
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("inconsistencia-arquivo-baixa-sanepar.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    @Generated
    public BaixaSaneparService(BaixaSaneparRepository repository, BaixaSaneparItemRepository baixaSaneparItemRepository, PagamentoLoteManualService pagamentoLoteService, ContextService contextService, ArquivoStorageFeignClient arquivoStorageFeignClient, SaneparConfiguracaoService saneparConfiguracaoService, ConsistenciaBaixaParamLoader consistenciaBaixaParamLoader, ReportFileResolverFactory reportFileResolverFactory, ObjectMapper objectMapper) {
        this.repository = repository;
        this.baixaSaneparItemRepository = baixaSaneparItemRepository;
        this.pagamentoLoteService = pagamentoLoteService;
        this.contextService = contextService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.saneparConfiguracaoService = saneparConfiguracaoService;
        this.consistenciaBaixaParamLoader = consistenciaBaixaParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.objectMapper = objectMapper;
    }
}

