/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.protesto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.EnvioProtestoRemessaDTO;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import br.com.elotech.tributos.service.ProtestoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EnvioProtestoRemessaJobStarter {
    private static final String ID_PROTESTO_REMESSA = "idProtestoRemessa";
    private static final String ENVIO_PROTESTO_REMESSA_DTO = "envioProtestoRemessaDTO";
    private final ObjectMapper objectMapper;
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final Job envioProtestoRemessaBatchJob;
    private final ProtestoRemessaService protestoRemessaService;
    private final ProtestoService protestoService;

    public EnvioProtestoRemessaJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="envioProtestoRemessaBatchJob") Job envioProtestoRemessaBatchJob, ProtestoRemessaService protestoRemessaService, ProtestoService protestoService) {
        this.objectMapper = objectMapper;
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.envioProtestoRemessaBatchJob = envioProtestoRemessaBatchJob;
        this.protestoRemessaService = protestoRemessaService;
        this.protestoService = protestoService;
    }

    public JobExecution startJob(EnvioProtestoRemessaDTO envioProtestoRemessaDTO) {
        this.protestoService.validateProtestosParaEnvio(envioProtestoRemessaDTO);
        String jobParamterEnvioProtestoRemessaDTO = this.getStringFrom(envioProtestoRemessaDTO);
        this.validateJobRunningWith(jobParamterEnvioProtestoRemessaDTO);
        try {
            JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
            jobParametersBuilder.addLong(ID_PROTESTO_REMESSA, this.protestoRemessaService.createAndSave().getId());
            jobParametersBuilder.addString(ENVIO_PROTESTO_REMESSA_DTO, jobParamterEnvioProtestoRemessaDTO);
            return this.jobLauncher.run(this.envioProtestoRemessaBatchJob, jobParametersBuilder.toJobParameters());
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao iniciar job de envio da remessa de protestos para o CRA. " + e.getMessage());
        }
    }

    private String getStringFrom(EnvioProtestoRemessaDTO envioProtestoRemessaDTO) {
        try {
            return this.objectMapper.writeValueAsString((Object)envioProtestoRemessaDTO);
        }
        catch (JsonProcessingException jpe) {
            throw new EloValidationException("Erro ao converter objeto em string. " + jpe.getMessage());
        }
    }

    private void validateJobRunningWith(String jobParamterEnvioProtestoRemessaDTO) {
        boolean hasJobRunning = this.jobExplorer.findRunningJobExecutions(JobType.ENVIO_PROTESTO_REMESSA.getTipo()).stream().anyMatch(jobExecution -> Objects.equals(jobParamterEnvioProtestoRemessaDTO, jobExecution.getJobParameters().getString(ENVIO_PROTESTO_REMESSA_DTO)));
        if (hasJobRunning) {
            throw new EloValidationException("J\u00e1 existe um envio de remessa de protesto em execu\u00e7\u00e3o para os protestos selecionados.");
        }
    }
}

