/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.AtualizaMotivoDeducaoDTO;
import br.com.elotech.tributos.dto.AtualizaNossoNumeroDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.pagamento.BaixaAutomaticaDetalheDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteSiafiService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteSuperSimplesService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.TransferenciaItbiService;
import br.com.elotech.tributos.service.UsuarioService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ProcessaPagamentoLoteService {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessaPagamentoLoteService.class);
    private final PagamentoLoteService pagamentoLoteService;
    private final BloquetoService bloquetoService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final TipoMensagemService tipoMensagemService;
    private final MotivoDeducaoService motivoDeducaoService;
    private final PagamentoService pagamentoService;
    private final ProcessaPagamentoLoteSuperSimplesService processaPagamentoLoteSuperSimplesService;
    private final TransferenciaItbiService transferenciaItbiService;
    private final ProcessaPagamentoLoteSiafiService processaPagamentoLoteSiafiService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final ParcelamentoService parcelamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private final UsuarioService usuarioService;
    private final ProtestoService protestoService;

    @Async
    @Transactional
    public void verificarLoteTarefa(PagamentoLoteId pagamentoLoteId, UserSecurityDTO userSecurityDTO) {
        LOG.debug("Cria\u00e7\u00e3o da tarefa VERIFICACAO_PAGAMENTO_LOTE para o pagamento {}", (Object)pagamentoLoteId);
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaVerificacaoPamanentoLote(pagamentoLoteId.toString());
        Long tarefa = execucao.getTarefaAssincrona().getId();
        Optional notificacaoId = this.notificacaoService.send("Verificando Lote de Pagamento", String.format("Iniciando a verifica\u00e7\u00e3o do Pagamento em Lote %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        try {
            LOG.debug("Iniciando verifica\u00e7\u00e3o do lote pagamento [entidade:{},exercicio:{},lote:{}]", new Object[]{pagamentoLoteId.getEntidade(), pagamentoLoteId.getExercicio(), pagamentoLoteId.getLote()});
            this.verificarLote(pagamentoLoteId.getEntidade(), pagamentoLoteId.getExercicio(), pagamentoLoteId.getLote());
            LOG.debug("Finalizada com sucesso a verifica\u00e7\u00e3o do Pagamento em Lote da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada verifica\u00e7\u00e3o do Lote de Pagamento", String.format("Finalizada com sucesso a verifica\u00e7\u00e3o do Pagamento em Lote da tarefa %s.", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
        }
        catch (Exception e) {
            LOG.debug("Ocorreu um erro na verifica\u00e7\u00e3o do Pagamento em Lote da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.notificacaoService.send("Erro na verifica\u00e7\u00e3o do Lote de Pagamento", String.format("Ocorreu um erro na verifica\u00e7\u00e3o do Pagamento em Lote da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    public List<BaixaAutomaticaDetalheDTO> verificarLote(Long entidade, Long exercicio, Long lote) {
        PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(entidade, exercicio, lote);
        pagamentoLote.verificaSituacaoLote();
        ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        return this.baixaAutomaticaDetalheService.findByPagamentoLote(pagamentoLote).stream().filter(baixaAutomaticaDetalhe -> baixaAutomaticaDetalhe.getSituacao().permiteVerificacao()).map(baixaAutomaticaDetalhe -> {
            try {
                return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)this.verificarLoteSequencia(baixaAutomaticaDetalhe, listasNecessariasCalculaAcrescimoDTO), null);
            }
            catch (Exception e) {
                LOG.error("Erro ao fazer a verificacao do lote sequencia de id {}", (Object)baixaAutomaticaDetalhe.getId(), (Object)e);
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.ERRO_NAO_IDENTIFICADO);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagem(e.getMessage());
                return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
            }
        }).map(BaixaAutomaticaDetalheDTO::of).collect(Collectors.toList());
    }

    private Optional<Bloqueto> getBoleto(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        if (TipoArquivoRetornoPagamento.SUPER_SIMPLES.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo())) {
            String sequencia = StringUtils.substring((String)baixaAutomaticaDetalhe.getDetalhe(), (int)461, (int)478);
            return this.baixaAutomaticaDetalheService.getBoletoPagoSuperSimples(sequencia);
        }
        return this.bloquetoService.findByNossoNumero(baixaAutomaticaDetalhe.getNossoNumero());
    }

    private BaixaAutomaticaDetalhe verificarLoteSequencia(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO) {
        LOG.debug("Verificando lote sequencia {}", (Object)baixaAutomaticaDetalhe.getId());
        Optional bloqueto = this.getBoleto(baixaAutomaticaDetalhe);
        if (bloqueto.isPresent()) {
            boolean descontoJaTratado;
            baixaAutomaticaDetalhe.setBoleto((Bloqueto)bloqueto.get());
            this.bloquetoService.calcularAcrescimos(baixaAutomaticaDetalhe.getBoleto(), baixaAutomaticaDetalhe.getDataPagamento(), Optional.ofNullable(listasNecessariasCalculaAcrescimoDTO));
            BigDecimal valorTotalComAcrescimos = baixaAutomaticaDetalhe.getBoleto().calculaValorBoletoComAcrescimos();
            baixaAutomaticaDetalhe.setValor(valorTotalComAcrescimos);
            if (((Bloqueto)bloqueto.get()).getDebitos().isEmpty()) {
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_SEM_DEBITOS);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.BOLETO_SEM_DEBITOS.getDescricao());
                return baixaAutomaticaDetalhe;
            }
            if (BigDecimal.ZERO.compareTo(valorTotalComAcrescimos) == 0) {
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_ZERADO);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.BOLETO_ZERADO.getDescricao());
                return baixaAutomaticaDetalhe;
            }
            BigDecimal diferencaValorPago = baixaAutomaticaDetalhe.getValorPago().subtract(valorTotalComAcrescimos);
            if (diferencaValorPago.compareTo(BigDecimal.ZERO) > 0) {
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_VALIDADO_PAGO_A_MAIOR);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagemPagoAMaior(diferencaValorPago);
                return baixaAutomaticaDetalhe;
            }
            boolean bl = descontoJaTratado = baixaAutomaticaDetalhe.getDescontoConcedido() != false || baixaAutomaticaDetalhe.getAutorizadoPagoAMenor() != false;
            if (diferencaValorPago.compareTo(BigDecimal.ZERO) < 0 && !descontoJaTratado) {
                boolean permiteDescontoAutomatico = this.verificaDescontoDentroDoPermitido(baixaAutomaticaDetalhe, diferencaValorPago);
                Optional motivoDeducaoPadrao = this.getMotivoDeducaoPagoMenor();
                if (permiteDescontoAutomatico && motivoDeducaoPadrao.isPresent()) {
                    return this.setValoresDesconto(baixaAutomaticaDetalhe, (MotivoDeducao)motivoDeducaoPadrao.get(), TipoMensagemEnum.DESCONTO_CONCEDIDO_AUTOMATICO);
                }
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_PAGO_A_MENOR);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagemPagoAMenor(diferencaValorPago.abs());
                return baixaAutomaticaDetalhe;
            }
            if (Boolean.TRUE.equals(this.pagamentoService.existePagamentoNaoEstornadoByIdBoleto(((Bloqueto)bloqueto.get()).getId()))) {
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_PAGO_DUPLICIDADE);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.BOLETO_PAGO_DUPLICIDADE.getDescricao());
                return baixaAutomaticaDetalhe;
            }
            if (!descontoJaTratado) {
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_VALIDADO);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.BOLETO_VALIDADO.getDescricao());
            } else {
                TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.DESCONTO_CONCEDIDO);
                baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
                baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
                baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.DESCONTO_CONCEDIDO.getDescricao());
            }
        } else {
            if (TipoArquivoRetornoPagamento.SUPER_SIMPLES.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo())) {
                return this.processaPagamentoLoteSuperSimplesService.verificarLoteSequenciaSuperSimples(baixaAutomaticaDetalhe);
            }
            if (TipoArquivoRetornoPagamento.SIAFI.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo())) {
                return this.processaPagamentoLoteSiafiService.verificarLoteSequencia(baixaAutomaticaDetalhe);
            }
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_NAO_IDENTIFICADO);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.BOLETO_NAO_IDENTIFICADO.getDescricao());
        }
        return baixaAutomaticaDetalhe;
    }

    private Optional<MotivoDeducao> getMotivoDeducaoPagoMenor() {
        return this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.MOTIVO_DEDUCAO_PAGO_MENOR).map(ParametroEntidadeExercicio::getValor).map(s -> StringUtils.isBlank((CharSequence)s) ? null : Long.valueOf(s)).flatMap(arg_0 -> ((MotivoDeducaoService)this.motivoDeducaoService).findById(arg_0));
    }

    private boolean verificaDescontoDentroDoPermitido(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, BigDecimal diferencaValorPago) {
        BigDecimal diferencaMaximaPermitida = baixaAutomaticaDetalhe.getBoleto().getModeloBloqueto().getConvenio().getMaximaDiferencaValor();
        return diferencaValorPago.abs().compareTo(diferencaMaximaPermitida) <= 0;
    }

    public BaixaAutomaticaDetalheDTO autorizarPagamentoAMenor(BaixaAutomaticaDetalheId autorizaPagamentoAMenorDTO) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = this.findBaixaAutomaticaDetalhe(autorizaPagamentoAMenorDTO.getEntidade(), autorizaPagamentoAMenorDTO.getExercicio(), autorizaPagamentoAMenorDTO.getLote(), autorizaPagamentoAMenorDTO.getSequenciaArquivo());
        baixaAutomaticaDetalhe.getPagamentoLote().verificaSituacaoLote();
        if (Boolean.FALSE.equals(baixaAutomaticaDetalhe.getTipoMensagem().getPermitePagoAMenor())) {
            throw new EloValidationException(String.format("Sequ\u00eancia %d com situa\u00e7\u00e3o %d-%s n\u00e3o permite pagamento a menor", baixaAutomaticaDetalhe.getId().getSequenciaArquivo(), baixaAutomaticaDetalhe.getTipoMensagem().getId(), baixaAutomaticaDetalhe.getTipoMensagem().getDescricao()));
        }
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.AUTORIZADO_PAGO_A_MENOR);
        baixaAutomaticaDetalhe.setAutorizadoPagoAMenor(Boolean.TRUE);
        String userAise = SecurityUtils.getUserAise();
        baixaAutomaticaDetalhe.setUsuarioAutorizacaoPagoAMenor(userAise);
        baixaAutomaticaDetalhe.setDataAutorizacaoPagoAMenor(LocalDate.now());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.AUTORIZADO_PAGO_A_MENOR.getDescricao());
        baixaAutomaticaDetalhe.setDataAlteracao(LocalDate.now());
        baixaAutomaticaDetalhe.setUsuarioAlteracao(userAise);
        baixaAutomaticaDetalhe.setAlterado(Boolean.TRUE);
        this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        return this.verificar(baixaAutomaticaDetalhe.getId());
    }

    private BaixaAutomaticaDetalhe findBaixaAutomaticaDetalhe(Long entidade, Long exercicio, Long lote, Long sequencia) {
        BaixaAutomaticaDetalheId id = BaixaAutomaticaDetalheId.of((Long)entidade, (Long)exercicio, (Long)lote, (Long)sequencia);
        return this.findBaixaAutomaticaDetalhe(id);
    }

    public BaixaAutomaticaDetalheDTO atualizarNossoNumero(AtualizaNossoNumeroDTO atualizaNossoNumero) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = this.findBaixaAutomaticaDetalhe(atualizaNossoNumero.getEntidade(), atualizaNossoNumero.getExercicio(), atualizaNossoNumero.getLote(), atualizaNossoNumero.getSequencia());
        baixaAutomaticaDetalhe.getPagamentoLote().verificaSituacaoLote();
        if (Boolean.FALSE.equals(baixaAutomaticaDetalhe.getTipoMensagem().getPermiteCorrecaoNossoNumero())) {
            throw new EloValidationException(String.format("Sequ\u00eancia %d com situa\u00e7\u00e3o %d-%s n\u00e3o permite atualiza\u00e7\u00e3o do nosso n\u00famero", baixaAutomaticaDetalhe.getId().getSequenciaArquivo(), baixaAutomaticaDetalhe.getTipoMensagem().getId(), baixaAutomaticaDetalhe.getTipoMensagem().getDescricao()));
        }
        String novoNossoNumero = TipoArquivoRetornoPagamento.SUPER_SIMPLES.equals((Object)baixaAutomaticaDetalhe.getPagamentoLote().getTipoArquivo()) ? atualizaNossoNumero.getNossoNumero() : this.bloquetoService.findByNossoNumero(atualizaNossoNumero.getNossoNumero()).map(Bloqueto::getNossoNumero).orElseThrow(() -> new EloValidationException(String.format("Boleto n\u00e3o encontrado para o Nosso N\u00famero %s", atualizaNossoNumero.getNossoNumero())));
        baixaAutomaticaDetalhe.setNossoNumeroAntigo(baixaAutomaticaDetalhe.getNossoNumero());
        baixaAutomaticaDetalhe.setNossoNumero(novoNossoNumero);
        baixaAutomaticaDetalhe.setDataAlteracao(LocalDate.now());
        baixaAutomaticaDetalhe.setUsuarioAlteracao(SecurityUtils.getUserAise());
        baixaAutomaticaDetalhe.setAlterado(Boolean.TRUE);
        this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        return this.verificar(baixaAutomaticaDetalhe.getId());
    }

    private BaixaAutomaticaDetalhe findBaixaAutomaticaDetalhe(BaixaAutomaticaDetalheId id) {
        return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("Registro n\u00e3o encontrado para sequ\u00eancia %d", id.getSequenciaArquivo())));
    }

    public BaixaAutomaticaDetalheDTO concederDesconto(AtualizaMotivoDeducaoDTO atualizaMotivoDeducaoDTO) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = this.findBaixaAutomaticaDetalhe(atualizaMotivoDeducaoDTO.getEntidade(), atualizaMotivoDeducaoDTO.getExercicio(), atualizaMotivoDeducaoDTO.getLote(), atualizaMotivoDeducaoDTO.getSequencia());
        baixaAutomaticaDetalhe.getPagamentoLote().verificaSituacaoLote();
        if (Boolean.FALSE.equals(baixaAutomaticaDetalhe.getTipoMensagem().getPermiteConcederDesconto())) {
            throw new EloValidationException(String.format("Sequ\u00eancia %d com situa\u00e7\u00e3o %d-%s n\u00e3o permite conceder desconto", baixaAutomaticaDetalhe.getId().getSequenciaArquivo(), baixaAutomaticaDetalhe.getTipoMensagem().getId(), baixaAutomaticaDetalhe.getTipoMensagem().getDescricao()));
        }
        MotivoDeducao motivoDeducao = (MotivoDeducao)this.motivoDeducaoService.findById((Serializable)atualizaMotivoDeducaoDTO.getMotivoDeducao()).orElseThrow(() -> new EloValidationException(String.format("Motivo Dedu\u00e7\u00e3o n\u00e3o encontrado %d", atualizaMotivoDeducaoDTO.getMotivoDeducao())));
        this.setValoresDesconto(baixaAutomaticaDetalhe, motivoDeducao, TipoMensagemEnum.DESCONTO_CONCEDIDO);
        return BaixaAutomaticaDetalheDTO.of((BaixaAutomaticaDetalhe)((BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null)));
    }

    public BaixaAutomaticaDetalhe setValoresDesconto(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, MotivoDeducao motivoDeducao, TipoMensagemEnum tipoMensagemEnum) {
        String userAise = SecurityUtils.getUserAise();
        if (Objects.isNull(userAise) || Objects.isNull(this.usuarioService.findOne((Serializable)((Object)userAise)))) {
            return this.validaUsuarioExisteEmAiseUsuario(baixaAutomaticaDetalhe, userAise);
        }
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(tipoMensagemEnum);
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setMensagem(tipoMensagemEnum.getDescricao());
        baixaAutomaticaDetalhe.setMotivoDeducao(motivoDeducao);
        baixaAutomaticaDetalhe.setDataAlteracao(LocalDate.now());
        baixaAutomaticaDetalhe.setDataDesconto(LocalDate.now());
        baixaAutomaticaDetalhe.setAlterado(Boolean.TRUE);
        baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.TRUE);
        baixaAutomaticaDetalhe.setUsuarioDesconto(userAise);
        baixaAutomaticaDetalhe.setUsuarioAlteracao(userAise);
        return baixaAutomaticaDetalhe;
    }

    private BaixaAutomaticaDetalhe validaUsuarioExisteEmAiseUsuario(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, String userAise) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.USUARIO_NAO_ENCONTRADO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setMensagemUsuarioNaoEncontrado(userAise);
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        return baixaAutomaticaDetalhe;
    }

    public BaixaAutomaticaDetalheDTO verificar(BaixaAutomaticaDetalheId id) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = this.findBaixaAutomaticaDetalhe(id);
        baixaAutomaticaDetalhe.getPagamentoLote().verificaSituacaoLote();
        try {
            baixaAutomaticaDetalhe.verificaSituacaoSequenciaVerificacao();
            this.verificarLoteSequencia(baixaAutomaticaDetalhe, this.calculoAcrescimoService.createNecessariasCalculaAcrescimo());
            return BaixaAutomaticaDetalheDTO.of((BaixaAutomaticaDetalhe)((BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null)));
        }
        catch (Exception e) {
            LOG.error("Erro ao fazer a verifica\u00e7\u00e3o da baixa com id {}", (Object)id, (Object)e);
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.ERRO_NAO_IDENTIFICADO);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(e.getMessage());
            return BaixaAutomaticaDetalheDTO.of((BaixaAutomaticaDetalhe)((BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null)));
        }
    }

    public BaixaAutomaticaDetalhe geraPagamento(BaixaAutomaticaDetalheId id) {
        try {
            BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = this.pagamentoService.geraPagamentoBaixaAutomatica(id);
            this.protestoService.validaDebitoProtestado(baixaAutomaticaDetalhe.getBoleto().getDebitos());
            this.transferenciaItbiService.validaTransferenciaItbi(baixaAutomaticaDetalhe.getPagamento());
            this.parcelamentoService.quitarContratoParcelamento(baixaAutomaticaDetalhe.getPagamento());
            this.pagamentoService.constituirDebitosDoPagamento(baixaAutomaticaDetalhe.getPagamento());
            return baixaAutomaticaDetalhe;
        }
        catch (Exception e) {
            LOG.error("Erro ao gerar o pagamento da sequencia de id {}", (Object)id, (Object)e);
            BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = this.findBaixaAutomaticaDetalhe(id);
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.ERRO_NAO_IDENTIFICADO);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(e.getMessage());
            return (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        }
    }

    public BaixaAutomaticaDetalheDTO baixarSequencia(BaixaAutomaticaDetalheId id) {
        PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(id.getEntidade(), id.getExercicio(), id.getLote());
        pagamentoLote.verificaSituacaoLote();
        pagamentoLote.verificaTipoDeArquivoRetorno();
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = this.findBaixaAutomaticaDetalhe(id);
        baixaAutomaticaDetalhe.verificaSituacaoSequenciaBaixa();
        BaixaAutomaticaDetalheDTO baixaAutomaticaDetalheDTO = BaixaAutomaticaDetalheDTO.of((BaixaAutomaticaDetalhe)this.geraPagamento(id));
        this.fechaLoteSeTodasSequenciasBaixadas(pagamentoLote);
        return baixaAutomaticaDetalheDTO;
    }

    public void fechaLoteSeTodasSequenciasBaixadas(PagamentoLote pagamentoLote) {
        if (Boolean.TRUE.equals(this.baixaAutomaticaDetalheService.todasSequenciasBaixadas(pagamentoLote.getId()))) {
            pagamentoLote.setSituacao(SituacaoPagamentoLote.FECHADO);
            this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
        }
    }

    @Generated
    public ProcessaPagamentoLoteService(PagamentoLoteService pagamentoLoteService, BloquetoService bloquetoService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, TipoMensagemService tipoMensagemService, MotivoDeducaoService motivoDeducaoService, PagamentoService pagamentoService, ProcessaPagamentoLoteSuperSimplesService processaPagamentoLoteSuperSimplesService, TransferenciaItbiService transferenciaItbiService, ProcessaPagamentoLoteSiafiService processaPagamentoLoteSiafiService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, ParcelamentoService parcelamentoService, CalculoAcrescimoService calculoAcrescimoService, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService, UsuarioService usuarioService, ProtestoService protestoService) {
        this.pagamentoLoteService = pagamentoLoteService;
        this.bloquetoService = bloquetoService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.tipoMensagemService = tipoMensagemService;
        this.motivoDeducaoService = motivoDeducaoService;
        this.pagamentoService = pagamentoService;
        this.processaPagamentoLoteSuperSimplesService = processaPagamentoLoteSuperSimplesService;
        this.transferenciaItbiService = transferenciaItbiService;
        this.processaPagamentoLoteSiafiService = processaPagamentoLoteSiafiService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.parcelamentoService = parcelamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
        this.usuarioService = usuarioService;
        this.protestoService = protestoService;
    }
}

