/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParcelamentoCarne;
import br.com.elotech.tributos.domain.SituacaoParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.parcelamento.SituacaoParcelamentoEnum;
import br.com.elotech.tributos.domain.parcelamento.TipoParcelamento;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.ImpressaoCarneParcelamentoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.ValueBlockDashDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.EstornoParcelamentoRowDTO;
import br.com.elotech.tributos.dto.parcelamento.FiltroEstornoParcelamentoEmLoteDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ImprimirContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.exception.ImpressaoContratoParcelamentoException;
import br.com.elotech.tributos.report.loader.ContratoParcelamentoParamLoader;
import br.com.elotech.tributos.repository.PagamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParcelamentoRepository;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.EstornoParcelamentoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ParcelamentoCarneService;
import br.com.elotech.tributos.service.SituacaoParcelamentoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ParcelamentoService
extends CrudService<Parcelamento, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParcelamentoService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ParcelamentoService.class);
    private static final Integer RELATORIO_SITUACAO_CONTRATO = 1054;
    private final ParcelamentoRepository parcelamentoRepository;
    private final ParamParcelamentoRepository paramParcelamentoRepository;
    private final ContratoParcelamentoParamLoader contratoParcelamentoParamLoader;
    private final EstornoParcelamentoService estornoParcelamentoService;
    private final ParametroGeralService parametroGeralService;
    private final PagamentoRepository pagamentoRepository;
    private final SituacaoParcelamentoService situacaoParcelamentoService;
    private final ResolversHandler resolversHandler;
    private final AiseRelatorioService aiseRelatorioService;
    private final ContextService contextService;
    private final FormaPagamentoService formaPagamentoService;
    private final ParcelamentoCarneService parcelamentoCarneService;
    private final CarneService carneService;
    private final TarefaAssincronaService tarefaAssincronaService;

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoOrigem(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoOrigem(idParcelamento);
    }

    public List<ParcelamentoDebitoDTO> findParcelamentoDebitoNovo(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoNovo(idParcelamento);
    }

    public List<ParcelamentoDebitoParcelasDTO> findParcelamentoDebitoParcelas(Long idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoParcelas(idParcelamento);
    }

    public List<ParcelamentoDebitoParcelasDTO> findParcelamentoDebitoParcelas(List<Long> idParcelamento) {
        return this.parcelamentoRepository.findParcelamentoDebitoParcelas(idParcelamento);
    }

    public ImprimirRelatorioDTO getImprimirContratoDTO(Long idParcelamento) {
        Long idParamParcelamento = this.findIdParamParcelamento(idParcelamento);
        ParamParcelamento paramParcelamento = this.findParamParcelamento(idParamParcelamento);
        Relatorio relatorioContrato = Optional.ofNullable(paramParcelamento.getRelatorio()).orElseThrow(() -> new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Relat\u00f3rio de impress\u00e3o do contrato n\u00e3o configurado para o par\u00e2metro de %s %d.", paramParcelamento.getTipo().getDescricao(), paramParcelamento.getId())));
        return this.createImprimirContratoDTO(idParcelamento, relatorioContrato, paramParcelamento.getSequenciaEmissaoRelatorio());
    }

    private ParamParcelamento findParamParcelamento(Long idParamParcelamento) {
        return (ParamParcelamento)this.paramParcelamentoRepository.findById((Object)idParamParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Par\u00e2metro do Parcelamento com id %d", idParamParcelamento)));
    }

    private Long findIdParamParcelamento(Long idParcelamento) {
        return (Long)this.parcelamentoRepository.findIdParametroParcelamentoByIdParcelamento(idParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Parcelamento com id %d", idParcelamento)));
    }

    private ImprimirRelatorioDTO createImprimirContratoDTO(Long idParcelamento, Relatorio relatorioContrato, Long sequenciaImpressao) {
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setModulo(relatorioContrato.getId().getModulo());
        dto.setRelatorio(relatorioContrato.getId().getRelatorio());
        dto.setTipoRelatorioFromEnum(relatorioContrato.getId().getTipoRelatorio());
        dto.setFiltro(String.format(" tp.IdParcelamento = %d", idParcelamento));
        dto.setListParametros(this.contratoParcelamentoParamLoader.load());
        dto.setListVariaveisAmbienteTela(String.format("Rel_IdParcelamento=%d%nIdParcelamento=%d%n", idParcelamento, idParcelamento));
        dto.setSequenciaTipoEmissao(sequenciaImpressao);
        dto.setSubReports(this.createSubReportImprimirContratoDTO(dto.getFiltro()));
        return dto;
    }

    private SubReportDTO createSubReportImprimirContratoDTO(String filtroPadrao) {
        SubReportDTO subReport = new SubReportDTO();
        subReport.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Detalhe", filtroPadrao), new SubReportItemDTO("Comprador", filtroPadrao), new SubReportItemDTO("Vendedor", filtroPadrao), new SubReportItemDTO("CadastroContribuinte", filtroPadrao)}));
        return subReport;
    }

    public ImprimirRelatorioDTO getImprimirSituacaoContratoDTO(Long idParcelamento) {
        this.findIdParamParcelamento(idParcelamento);
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(RELATORIO_SITUACAO_CONTRATO);
        dto.setFiltro(String.format(" tp.IdParcelamento = %d", idParcelamento));
        dto.setListParametros(this.contratoParcelamentoParamLoader.load());
        dto.setListVariaveisAmbienteTela(String.format("IdParcelamento=%d%n", idParcelamento));
        return dto;
    }

    public ValueBlockDashDTO getQuantidadeContratosGerados(LocalDate data) {
        return this.parcelamentoRepository.getQuantidadeContratosGerados(data);
    }

    public Optional<Parcelamento> findParcelamentoQuitadoByParcelaTributo(DebitoParcela debitoParcela) {
        return this.parcelamentoRepository.findParcelamentoQuitadoByParcela(debitoParcela);
    }

    public Optional<Parcelamento> findParcelamentoDisponivelParaQuitacao(DebitoParcela debitoParcela) {
        return this.parcelamentoRepository.findParcelamentoDisponivelParaQuitacao(debitoParcela);
    }

    public ParcelamentoDTO getResumo(Long idParcelamento) {
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoRepository.findById((Object)idParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Parcelamento com id %d", idParcelamento)));
        ParamParcelamento paramParcelamento = this.findParamParcelamento(parcelamento.getIdParametroParcelamento());
        ParcelamentoDTO parcelamentoDTO = parcelamento.toDto();
        parcelamentoDTO.setDescricaoParametroParcelamento(paramParcelamento.getDescricao());
        parcelamentoDTO.setDebitosOrigem(this.findParcelamentoDebitoOrigem(idParcelamento));
        parcelamentoDTO.setDebitosNovos(this.findParcelamentoDebitoNovo(idParcelamento));
        parcelamentoDTO.setParcelas(this.findParcelamentoDebitoParcelas(idParcelamento));
        parcelamentoDTO.setEstornos(this.getEstornos(idParcelamento));
        return parcelamentoDTO;
    }

    public List<EstornoParcelamentoRowDTO> getEstornos(Long idParcelamento) {
        return this.estornoParcelamentoService.findByIdParcelamento(idParcelamento);
    }

    public Parcelamento findByCodigoValidacao(String codigoValidacao) {
        return this.parcelamentoRepository.findByCodigoValidacao(codigoValidacao);
    }

    @Transactional
    public void quitarContratoParcelamento(Pagamento pagamento) {
        Boolean quitarContrato = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ATUALIZAR_SITUACAO_CONTRATO);
        if (Boolean.TRUE.equals(quitarContrato)) {
            SituacaoParcelamento situacaoParcelamentoAberto = (SituacaoParcelamento)this.situacaoParcelamentoService.findOne((Serializable)SituacaoParcelamentoEnum.ABERTO.getValue());
            List debitosId = this.pagamentoRepository.findIdDebitoQuitadoListByPagamento(pagamento.getId().getEntidade(), pagamento.getId().getExercicioPagamento(), pagamento.getId().getPagamento());
            if (!debitosId.isEmpty()) {
                debitosId.stream().filter(debito -> Objects.nonNull(debito) && Objects.nonNull(debito.getIdParcelamento())).map(DebitoIdDTO::getIdParcelamento).filter(arg_0 -> ((ParcelamentoRepository)this.parcelamentoRepository).parcelamentoComDebitosQuitados(arg_0)).map(arg_0 -> ((ParcelamentoRepository)this.parcelamentoRepository).findOne(arg_0)).filter(Objects::nonNull).filter(parcelamento -> Objects.isNull(parcelamento.getSituacao()) || situacaoParcelamentoAberto.equals((Object)parcelamento.getSituacao())).forEach(arg_0 -> this.quitarContrato(arg_0));
            }
        }
    }

    private void quitarContrato(Parcelamento parcelamento) {
        parcelamento.setSituacao((SituacaoParcelamento)this.situacaoParcelamentoService.findOne((Serializable)SituacaoParcelamentoEnum.QUITADO.getValue()));
        parcelamento.setDataQuitacao(LocalDate.now());
        this.parcelamentoRepository.save((Object)parcelamento);
    }

    public byte[] imprimirContratoParcelamentoFromTenant(String tenant, Long idParcelamento) {
        try {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoRepository.findById((Object)idParcelamento).orElseThrow(() -> new EloValidationException("Contrato do parcelamento n\u00e3o encontrado."));
            ImprimirContratoDTO imprimirContratoDTO = Optional.ofNullable(parcelamento.getIdArquivo()).map(uuid -> this.getUrlArquivo(uuid, parcelamento.getTenant())).orElseGet(() -> this.uploadContratoParcelamento(tenant, parcelamento));
            ArquivoContent arquivo = (ArquivoContent)this.resolveArquivoClient().buscarArquivo(ArquivoFindRequest.create((Tenant)Tenant.create((String)tenant), (String)imprimirContratoDTO.getFullPath())).orElseThrow(() -> new EloValidationException(String.format("Contrato de parcelamento n\u00e3o localizado - %s", imprimirContratoDTO.getFullPath())));
            return IOUtils.toByteArray((InputStream)arquivo.getContent());
        }
        catch (Exception ex) {
            LOGGER.error("Erro na impress\u00e3o do contrato de parcelamento", (Throwable)ex);
            throw new ImpressaoContratoParcelamentoException(HttpStatus.BAD_REQUEST, ex.getMessage(), ex);
        }
    }

    public ImprimirContratoDTO uploadContratoParcelamento(String tenant, Parcelamento parcelamento) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.getImprimirContratoDTO(parcelamento.getId());
        byte[] relatorioPdf = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        String nomeArquivo = (parcelamento.getTipo().equals((Object)TipoParcelamento.PARCELAMENTO) ? "parcelamento" : "reparcelamento").concat(String.format("_%d_%d.pdf", parcelamento.getNumeroContrato(), parcelamento.getAnoContrato()));
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)tenant), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content((InputStream)new ByteArrayInputStream(relatorioPdf)).contentType(ContentType.APPLICATION_PDF).build();
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
        this.saveArquivoParcelamento(parcelamento, arquivo.getId(), tenant);
        return this.getUrlArquivo(arquivo.getId(), tenant);
    }

    private void saveArquivoParcelamento(Parcelamento parcelamento, UUID idArquivo, String tenant) {
        parcelamento.setIdArquivo(idArquivo);
        parcelamento.setTenant(tenant);
        this.parcelamentoRepository.save((Object)parcelamento);
    }

    private ImprimirContratoDTO getUrlArquivo(UUID idArquivo, String tenant) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)tenant), (String)("oxy_tributos/" + idArquivo.toString()));
        ArquivoUrl arquivo = this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest);
        ImprimirContratoDTO imprimirContratoDTO = new ImprimirContratoDTO();
        imprimirContratoDTO.setUrlContrato(arquivo.getUrlAssinada());
        imprimirContratoDTO.setFullPath(arquivo.getFullPath());
        return imprimirContratoDTO;
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    public Page<EstornoParcelamentoEmLoteDTO> filtroEstornoParcelamentoEmLote(FiltroEstornoParcelamentoEmLoteDTO filtroEstornoParcelamentoEmLoteDTO, Pageable page) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        List estornoParcelamentoEmLote = this.parcelamentoRepository.findParcelamentosParaEstornoEmLote(filtroEstornoParcelamentoEmLoteDTO, entidade, exercicio);
        return new PageImpl(estornoParcelamentoEmLote.stream().skip(page.getOffset()).limit(page.getPageSize()).collect(Collectors.toList()), page, (long)estornoParcelamentoEmLote.size());
    }

    public ImpressaoCarneParcelamentoDTO gerarOuImprimirBoleto(Long idParcelamento, boolean permiteTarefaAssincrona) {
        Parcelamento parcelamento = (Parcelamento)this.findById((Serializable)idParcelamento).orElseThrow(() -> new EloValidationException(String.format("Parcelamento %d n\u00e3o encontrado", idParcelamento)));
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoRepository.findOne((Object)parcelamento.getIdParametroParcelamento());
        FormaPagamento formaPagamento = Optional.ofNullable(paramParcelamento.getFormaPagamento()).orElse(this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual())));
        List parcelamentoDebitoParcelasDTO = this.findParcelamentoDebitoParcelas(idParcelamento);
        return this.gerarOuImprimirBoleto(ImpressaoBoletoParcelamentoDTO.of((Parcelamento)parcelamento, (ParamParcelamento)paramParcelamento, (List)parcelamentoDebitoParcelasDTO, (FormaPagamento)formaPagamento), permiteTarefaAssincrona);
    }

    public ImpressaoCarneParcelamentoDTO gerarOuImprimirBoleto(ImpressaoBoletoParcelamentoDTO request, boolean permiteTarefaAssincrona) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List idsParcelamentos = request.getParcelamentos().stream().map(ParcelamentoPassivelQuitacaoDTO::getIdParcelamento).collect(Collectors.toList());
        List parcelamentoDebitoParcelas = this.parcelamentoRepository.findParcelamentoDebitoParcelas(idsParcelamentos).stream().filter(dto -> dto.getVencido() == false && dto.isDataVencimentoEntre(request.getVencimentoInicial(), request.getVencimentoFinal()) != false).limit(request.getQuantidadeParcelas().intValue()).collect(Collectors.toList());
        Long parcelaInicial = parcelamentoDebitoParcelas.stream().map(ParcelamentoDebitoParcelasDTO::getParcela).sorted().findFirst().orElse(1L);
        Long parcelaFinal = parcelamentoDebitoParcelas.stream().map(ParcelamentoDebitoParcelasDTO::getParcela).sorted(Comparator.reverseOrder()).findFirst().orElse(1L);
        String chave = request.getParcelamentos().stream().map(ParcelamentoPassivelQuitacaoDTO::getIdParcelamento).sorted().map(String::valueOf).collect(Collectors.joining("-"));
        String elapsedTimeFindParcelasParcelamento = stopwatch.toString();
        ParcelamentoCarne parcelamentoCarneExistente = this.parcelamentoCarneService.getByChaveAndParcela(chave, parcelaInicial, parcelaFinal).stream().findFirst().orElse(null);
        String elapsedTimeGetParcelamentoCarneExistente = stopwatch.toString();
        if (Objects.isNull(parcelamentoCarneExistente)) {
            if (permiteTarefaAssincrona && parcelamentoDebitoParcelas.size() > 15) {
                Boolean tarefaEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.PARCELAMENTO_GERACAO_CARNE, "ID_PARCELAMENTO", chave);
                if (Boolean.TRUE.equals(tarefaEmExecucao)) {
                    throw new EloValidationException("J\u00e1 existe uma tarefa em execu\u00e7\u00e3o para os parcelamentos informados!");
                }
                TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.criarTarefaAssincronaParcelamentoCarne(chave, parcelaInicial, parcelaFinal);
                String elapsedTimeCriarTarefaAssincrona = stopwatch.toString();
                this.parcelamentoCarneService.gerarBoletoCarneAsync(request, parcelamentoDebitoParcelas, chave, execucao, parcelaInicial, parcelaFinal);
                stopwatch.stop();
                log.debug(String.format("Tempo gasto para gerar carne parcelamento assincrono:\nfindParcelasParcelamento: %s\ngetParcelamentoCarneExistente: %s\ncriarTarefaAssincrona: %s\ngerarBoletoCarneAsync: %s\nidTarefaAssincrona: %d\nparcelas de %d ate %d", elapsedTimeFindParcelasParcelamento, elapsedTimeGetParcelamentoCarneExistente, elapsedTimeCriarTarefaAssincrona, stopwatch, execucao.getTarefaAssincrona().getId(), parcelaInicial, parcelaFinal));
                return ImpressaoCarneParcelamentoDTO.from((Boolean)true, (Long)execucao.getTarefaAssincrona().getId());
            }
            parcelamentoCarneExistente = this.carneService.gerarBoletoCarne(request, parcelamentoDebitoParcelas, chave, parcelaInicial, parcelaFinal);
        }
        stopwatch.stop();
        log.debug(String.format("Tempo gasto para gerar carne parcelamento:\nfindParcelasParcelamento: %s\ngetParcelamentoCarneExistente: %s\ngerarCarne: %s\nidCarneGerado: %d\nparcelas de %d ate %d", elapsedTimeFindParcelasParcelamento, elapsedTimeGetParcelamentoCarneExistente, stopwatch, parcelamentoCarneExistente.getCarne().getId().getCarne(), parcelaInicial, parcelaFinal));
        return ImpressaoCarneParcelamentoDTO.from((ParcelamentoCarne)parcelamentoCarneExistente, (Long)parcelaInicial, (Long)parcelaFinal);
    }

    public Set<ModeloBoleto> findModeloBoletoByParcelamentos(List<Long> parcelamentos) {
        return parcelamentos.stream().map(arg_0 -> ((ParcelamentoRepository)this.parcelamentoRepository).getOne(arg_0)).filter(Objects::nonNull).map(Parcelamento::getParamParcelamento).map(ParamParcelamento::getModeloBoleto).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Generated
    public ParcelamentoService(ParcelamentoRepository parcelamentoRepository, ParamParcelamentoRepository paramParcelamentoRepository, ContratoParcelamentoParamLoader contratoParcelamentoParamLoader, EstornoParcelamentoService estornoParcelamentoService, ParametroGeralService parametroGeralService, PagamentoRepository pagamentoRepository, SituacaoParcelamentoService situacaoParcelamentoService, ResolversHandler resolversHandler, AiseRelatorioService aiseRelatorioService, ContextService contextService, FormaPagamentoService formaPagamentoService, ParcelamentoCarneService parcelamentoCarneService, CarneService carneService, TarefaAssincronaService tarefaAssincronaService) {
        this.parcelamentoRepository = parcelamentoRepository;
        this.paramParcelamentoRepository = paramParcelamentoRepository;
        this.contratoParcelamentoParamLoader = contratoParcelamentoParamLoader;
        this.estornoParcelamentoService = estornoParcelamentoService;
        this.parametroGeralService = parametroGeralService;
        this.pagamentoRepository = pagamentoRepository;
        this.situacaoParcelamentoService = situacaoParcelamentoService;
        this.resolversHandler = resolversHandler;
        this.aiseRelatorioService = aiseRelatorioService;
        this.contextService = contextService;
        this.formaPagamentoService = formaPagamentoService;
        this.parcelamentoCarneService = parcelamentoCarneService;
        this.carneService = carneService;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }
}

