/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.service.CalculoTabelaValores;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoObservacao;
import br.com.elotech.tributos.domain.DebitoObservacaoId;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.DebitoTributoId;
import br.com.elotech.tributos.domain.DebitoTributoIsencao;
import br.com.elotech.tributos.domain.DebitoTributoIsencaoId;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaGrupoVencimento;
import br.com.elotech.tributos.domain.DividaGrupoVencimentoParcela;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.SituacaoParcela;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualIssDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.GerarParcelasDebitoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.PermissoesDividaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.exception.GeracaoDebitoManualException;
import br.com.elotech.tributos.util.CalculoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GeraDebitoService {
    private final CadastroGeralService cadastroGeralService;
    private final ContextService contextService;
    private final DividaService dividaService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final DebitoService debitoService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final PermissoesDividaService permissoesDividaService;
    private final ParametroEntidadeExercicioService parametroentidadeExerciciService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final HistoricoAtendimentoService historicoAtendimentoService;

    public GeraDebitoService(CadastroGeralService cadastroGeralService, ContextService contextService, DividaService dividaService, FormaCorrecaoService formaCorrecaoService, DebitoService debitoService, SituacaoParcelaService situacaoParcelaService, DebitoParcelaService debitoParcelaService, DebitoParcelaTributoService debitoParcelaTributoService, PermissoesDividaService permissoesDividaService, ParametroEntidadeExercicioService parametroentidadeExerciciService, ValidaDataMovimentacaoService validaDataMovimentacaoService, HistoricoAtendimentoService historicoAtendimentoService) {
        this.cadastroGeralService = cadastroGeralService;
        this.contextService = contextService;
        this.dividaService = dividaService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.debitoService = debitoService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.permissoesDividaService = permissoesDividaService;
        this.parametroentidadeExerciciService = parametroentidadeExerciciService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.historicoAtendimentoService = historicoAtendimentoService;
    }

    @Transactional(noRollbackFor={Exception.class})
    public DebitoIdDTO geraDebitoManualSanepar(DebitoManualDTO debitoManualDTO) {
        return this.geraDebitoManual(debitoManualDTO);
    }

    @Transactional
    public DebitoIdDTO geraDebitoManual(DebitoManualDTO debitoManualDTO) {
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        Long exercicioAtual = Objects.nonNull(debitoManualDTO.getExercicio()) ? debitoManualDTO.getExercicio() : this.contextService.getExercicioAtual();
        this.validaDataMovimentacaoService.validaMesEDia(entidadePrincipal, debitoManualDTO.getDataLancamento());
        String usuario = Optional.ofNullable(debitoManualDTO.getUsuario()).orElse(SecurityUtils.getUserAise());
        Debito debito = debitoManualDTO.toEntity(entidadePrincipal, usuario);
        if (Objects.isNull(debito.getSubDivida())) {
            debito.setSubDivida(this.getNextSubdivida(NextSubdividaValueParams.of((DebitoManualDTO)debitoManualDTO)));
        }
        debito.setDataPrimeiraParcela();
        debito.setChildrenId();
        debito.setNumeroParcela(Long.valueOf(debitoManualDTO.getParcelas().size()));
        debito.setUsuario(usuario);
        if (Objects.isNull(debitoManualDTO.getFormaCorrecao())) {
            debito.setFormaCorrecao(this.formaCorrecaoService.getFormaCorrecaoPadrao(debitoManualDTO.getDivida(), entidadePrincipal, debitoManualDTO.getExercicio()));
        } else {
            debito.setFormaCorrecao((FormaCorrecao)this.formaCorrecaoService.findById((Serializable)debitoManualDTO.getFormaCorrecao()).orElseThrow(() -> GeracaoDebitoManualException.formaCorrecaoNotFound((Long)debitoManualDTO.getFormaCorrecao())));
        }
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(debito.getEntidade(), exercicioAtual, debito.getGuiaRecolhimento()).orElseThrow(() -> GeracaoDebitoManualException.dividaNotFound((Long)debito.getEntidade(), (Long)exercicioAtual, (Long)debito.getGuiaRecolhimento()));
        debito.setConstituido(divida.isConstituido());
        debito.generateDebitoParcelaTributo(divida.getPermiteLancarValorZero());
        debito.getParcelas().forEach(debitoParcela -> {
            debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getSituacaoParcelaNovoDebito(debitoParcela.getSituacaoDebito(), debitoParcela.getValorTotal()));
            debitoParcela.setDebito(debito);
        });
        this.validaDebitoManual(debito, divida, debitoManualDTO.getValidaPermissaoDivida());
        Debito savedDebito = this.debitoService.save(debito);
        this.historicoAtendimentoService.createHistoricoAtendimento(String.format("Debito gerado id %s", savedDebito.getId()), TipoAcaoAtendimento.GERACAO_DEBITO);
        return DebitoIdDTO.of((Long)savedDebito.getId(), (Long)savedDebito.getEntidade(), (Long)savedDebito.getExercicio(), (Long)savedDebito.getTipoCadastro(), (Long)savedDebito.getCadastroGeralId(), (Long)divida.getDivida(), (Long)savedDebito.getSubDivida());
    }

    @Transactional
    public List<Debito> geraDebitoManualIss(DebitoManualIssDTO debitoManualIssDTO) {
        Long entidade = this.contextService.getEntidadePrincipal();
        this.validaDataMovimentacaoService.validaMesEDia(entidade, debitoManualIssDTO.getDataLancamento());
        if (Boolean.FALSE.equals(debitoManualIssDTO.getTipoCadastro().permiteEmissaoDebitoISS())) {
            throw GeracaoDebitoManualException.tipoCadastroInvalido((TipoCadastro)debitoManualIssDTO.getTipoCadastro());
        }
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, debitoManualIssDTO.getExercicio(), debitoManualIssDTO.getDivida()).orElseThrow(() -> GeracaoDebitoManualException.dividaNotFound((Long)entidade, (Long)debitoManualIssDTO.getExercicio(), (Long)debitoManualIssDTO.getDivida()));
        FormaCorrecao formaCorrecao = Objects.isNull(debitoManualIssDTO.getFormaCorrecao()) ? this.formaCorrecaoService.getFormaCorrecaoPadrao(debitoManualIssDTO.getDivida(), this.contextService.getEntidadePrincipal(), debitoManualIssDTO.getExercicio()) : (FormaCorrecao)this.formaCorrecaoService.findById((Serializable)debitoManualIssDTO.getFormaCorrecao()).orElseThrow(() -> GeracaoDebitoManualException.formaCorrecaoNotFound((Long)debitoManualIssDTO.getFormaCorrecao()));
        Optional cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)debitoManualIssDTO.getTipoCadastro().getValue()), debitoManualIssDTO.getCadastroGeral());
        if (!cadastroGeral.isPresent()) {
            throw GeracaoDebitoManualException.cadastroNotFound((Long)debitoManualIssDTO.getTipoCadastro().getValue(), (Long)debitoManualIssDTO.getCadastroGeral());
        }
        List debitosGerados = debitoManualIssDTO.toEntity(entidade, SecurityUtils.getUserAise());
        return debitosGerados.stream().map(debitoGerado -> {
            Optional match = this.debitoService.findByCompositeKey(entidade, debitoGerado.getExercicio(), debitoGerado.getTipoCadastro(), debitoGerado.getCadastroGeralId(), debitoManualIssDTO.getDivida(), debitoGerado.getSubDivida());
            Debito debito = match.map(debitoMatch -> this.addParcelaDebitoISS(debitoMatch, debitoManualIssDTO, (DebitoParcela)debitoGerado.getParcelas().get(0))).orElseGet(() -> this.setAttributesDebitoISS(debitoGerado, formaCorrecao, divida, debitoManualIssDTO));
            this.debitoService.save(debito);
            return debito;
        }).collect(Collectors.toList());
    }

    private Debito addParcelaDebitoISS(Debito debito, DebitoManualIssDTO debitoManualIssDTO, DebitoParcela debitoParcela) {
        String tributoId = debitoManualIssDTO.getTributo().getId().getTributo();
        DebitoTributo tributo = (DebitoTributo)debito.getDebitoTributoByTributo(tributoId).orElseThrow(() -> GeracaoDebitoManualException.tributoNaoExisteNoDebito((String)tributoId, (Debito)debito));
        DebitoManualParcelaDTO parcelaDTO = this.getDebitoManualParcelaDTO(debito, debitoManualIssDTO);
        tributo.setValorBaseCalculo(tributo.getValorBaseCalculo().add(parcelaDTO.getValorBaseCalculo()));
        tributo.setValorTributo(tributo.getValorTributo().add(parcelaDTO.getValor()));
        debitoParcela.setDebitoAndUpdateIdParcela(debito);
        debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getSituacaoParcelaNovoDebito(debitoParcela.getSituacaoDebito(), debitoParcela.getValorTotal()));
        this.atualizaReferenciaDebitoParcela(debitoParcela, parcelaDTO);
        this.debitoParcelaService.save((EloEntity)debitoParcela, null);
        this.debitoParcelaTributoService.saveAll(debitoParcela.getTributos());
        debito.getParcelas().add(debitoParcela);
        debito.setNumeroParcela(Long.valueOf(debito.getNumeroParcela() + 1L));
        debito.validaGeracaoDebitoManual(debito.getDivida());
        if (Objects.nonNull(debitoManualIssDTO.getObservacoes())) {
            debitoManualIssDTO.getObservacoes().stream().map(observacao -> observacao.toEntity(SecurityUtils.getUserAise())).forEach(debito.getObservacoes()::add);
            debito.setObservacoesId();
        }
        return debito;
    }

    private void atualizaReferenciaDebitoParcela(DebitoParcela debitoParcela, DebitoManualParcelaDTO parcelaDTO) {
        if (parcelaDTO.getAnoReferencia() > this.contextService.getExercicioAtual()) {
            debitoParcela.setAnoReferencia(parcelaDTO.getAnoReferencia());
            debitoParcela.setMesReferencia(parcelaDTO.getMesReferencia());
        }
    }

    private DebitoManualParcelaDTO getDebitoManualParcelaDTO(Debito debito, DebitoManualIssDTO debitoManualIssDTO) {
        Long subDividaIssHomologado = 100L;
        DebitoManualParcelaDTO parcelaDTO = Boolean.TRUE.equals(debitoManualIssDTO.getBaixaAutomatica()) ? (DebitoManualParcelaDTO)debitoManualIssDTO.getParcelas().get(0) : (DebitoManualParcelaDTO)debitoManualIssDTO.getParcelaByNumeroParcela(Long.valueOf(debito.getSubDivida() - subDividaIssHomologado)).orElseThrow(() -> GeracaoDebitoManualException.parcelaNotFound((Long)(debito.getSubDivida() - subDividaIssHomologado)));
        return parcelaDTO;
    }

    private Debito setAttributesDebitoISS(Debito debito, FormaCorrecao formaCorrecao, Divida divida, DebitoManualIssDTO debitoManualIssDTO) {
        debito.setUsuario(SecurityUtils.getUserAise());
        debito.setFormaCorrecao(formaCorrecao);
        debito.setConstituido(divida.isConstituido());
        debito.setDivida(divida);
        debito.getParcelas().forEach(debitoParcela -> {
            DebitoManualParcelaDTO parcelaDTO = this.getDebitoManualParcelaDTO(debito, debitoManualIssDTO);
            this.atualizaReferenciaDebitoParcela(debitoParcela, parcelaDTO);
            debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getSituacaoParcelaNovoDebito(debitoParcela.getSituacaoDebito(), debitoParcela.getValorTotal()));
        });
        debito.setChildrenId();
        debito.validaGeracaoDebitoManual(divida);
        return debito;
    }

    private void validaDebitoManual(Debito debito, Divida divida, Boolean validaPermissaoDivida) {
        Optional cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)debito.getTipoCadastro()), debito.getCadastroGeralId());
        if (!cadastroGeral.isPresent()) {
            throw GeracaoDebitoManualException.cadastroNotFound((Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeralId());
        }
        if (Boolean.TRUE.equals(validaPermissaoDivida)) {
            this.permissoesDividaService.validaPermissaoDividaByUsuario(divida.getEntidade(), divida.getExercicio(), divida.getDivida(), debito.getUsuario());
        }
        debito.validaGeracaoDebitoManual(divida);
    }

    public List<DebitoManualParcelaDTO> gerarParcelas(GerarParcelasDebitoDTO gerarParcelasDebitoDTO) {
        ArrayList<DebitoManualParcelaDTO> parcelas = new ArrayList<DebitoManualParcelaDTO>();
        BigDecimal valorTributo = gerarParcelasDebitoDTO.getTributos().stream().map(tributo -> tributo.getValorTributo().subtract(tributo.getValorRenuncia())).reduce(BigDecimal.ZERO, BigDecimal::add);
        int indice = 0;
        while ((long)indice < gerarParcelasDebitoDTO.getQuantidadeParcelas()) {
            DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
            parcela.setSituacao(Long.valueOf(1L));
            BigDecimal valorParcela = indice == 0 ? CalculoUtils.divideESomaValorDiferenca((BigDecimal)valorTributo, (Integer)gerarParcelasDebitoDTO.getQuantidadeParcelas().intValue(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS) : CalculoUtils.divideETruncaValor((BigDecimal)valorTributo, (Integer)gerarParcelasDebitoDTO.getQuantidadeParcelas().intValue(), (Integer)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS);
            parcela.setValor(valorParcela);
            parcela.setParcela(Long.valueOf(gerarParcelasDebitoDTO.getParcelaInicial() + (long)indice));
            parcela.setDataVencimento(gerarParcelasDebitoDTO.getDataVencimentoInicial().plusMonths(indice));
            parcelas.add(parcela);
            ++indice;
        }
        return parcelas;
    }

    private Long getNextSubdivida(NextSubdividaValueParams nextSubdividaValueParams) {
        return this.debitoService.getNextValueSubdivida(nextSubdividaValueParams);
    }

    private DividaGrupoVencimento getGrupoVencimentoCalculo(Debito debito, CalculoTabelaValores calculoTabelaValores) {
        Divida divida = debito.getDivida();
        Assert.notEmpty((Collection)divida.getGruposVencimento(), (String)String.format("D\u00edvida %d sem grupo de vencimento configurado.", divida.getDivida()));
        if (Objects.nonNull(divida.getTabelaValor()) && Objects.nonNull(calculoTabelaValores)) {
            Long grupoVencimento = calculoTabelaValores.calculaTabelaValores(divida.getTabelaValor().getNome(), new Object[]{debito.getValorTotalDebito()}).longValue();
            return divida.getGruposVencimento().stream().filter(gv -> Objects.equals(gv.getGrupoVencimento(), grupoVencimento)).findAny().orElse((DividaGrupoVencimento)divida.getGruposVencimento().get(0));
        }
        return (DividaGrupoVencimento)divida.getGruposVencimento().get(0);
    }

    private void verifySituacaoParcelaDebitoIsento(Debito debito) {
        debito.getParcelas().forEach(debitoParcela -> debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getSituacaoParcelaNovoDebito(debitoParcela.getSituacaoDebito(), debitoParcela.getValorTotal())));
    }

    private List<DebitoParcela> generateDebitoParcela(Debito debito, SituacaoParcela situacaoParcela, List<DividaGrupoVencimentoParcela> parcelas) {
        return parcelas.stream().map(dividaGrupoVencimentoParcela -> {
            DebitoParcela parcela = new DebitoParcela();
            DebitoParcelaId parcelaId = new DebitoParcelaId();
            parcelaId.setParcela(dividaGrupoVencimentoParcela.getParcela());
            parcela.setId(parcelaId);
            parcela.setDataVencimento(dividaGrupoVencimentoParcela.getDataPagamento());
            parcela.setDataLancamento(debito.getDataLancamento());
            parcela.setSituacaoLegal(SituacaoLegal.NO_EXERCICIO);
            parcela.setSituacaoDebito(situacaoParcela);
            parcela.setDebito(debito);
            parcela.setDataSituacao(debito.getDataLancamento());
            return parcela;
        }).collect(Collectors.toList());
    }

    public Debito generateDebitoCalculo(CalculoCadastro calculoCadastro, Long entidade, CalculoTabelaValores calculoTabelaValores) {
        SituacaoParcela situacaoParcela = this.situacaoParcelaService.getSituacaoParcelaNovoDebito(null, BigDecimal.ONE);
        ParametroEntidadeExercicio parametroIsencaoValorMinimoDebito = this.parametroentidadeExerciciService.findByExercicioAndModuloAndParametro(calculoCadastro.getCalculo().getExercicio(), ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.ISENCAO_VALORMINIMO_DEBITO.getValue());
        Debito debito = new Debito();
        debito.setEntidade(entidade);
        debito.setExercicio(calculoCadastro.getCalculo().getExercicio());
        debito.setDivida(calculoCadastro.getDivida());
        debito.setTipoCadastro(calculoCadastro.getCadastro().getTipoCadastro().getValue());
        debito.setCadastroGeral(calculoCadastro.getCadastro());
        debito.setCadastroGeralId(calculoCadastro.getCadastro().getCadastroGeral());
        debito.setGuiaRecolhimento(calculoCadastro.getDivida().getDivida());
        debito.setPrograma("Calculo");
        NextSubdividaValueParams nextSubdividaValueParams = NextSubdividaValueParams.of((Long)debito.getTipoCadastro(), (Long)debito.getCadastroGeral().getCadastroGeral(), (Long)debito.getExercicio(), (Long)debito.getDivida().getDivida());
        debito.setSubDivida(this.getNextSubdivida(nextSubdividaValueParams));
        debito.setFormaCorrecao(this.formaCorrecaoService.getFormaCorrecaoPadrao(debito.getDivida().getDivida(), debito.getEntidade(), debito.getExercicio()));
        debito.setUsuario(SecurityUtils.getUserAise());
        debito.setDataInclusao(LocalDate.now());
        debito.setDataLancamento(calculoCadastro.getCalculo().getDataLancamento());
        calculoCadastro.getResultados().forEach(tributoCalculado -> {
            DebitoTributo tributo = new DebitoTributo();
            DebitoTributoId tributoId = new DebitoTributoId();
            tributoId.setTributo(tributoCalculado.getCalculoTributo().getTributo().getTributo());
            tributo.setId(tributoId);
            tributo.setValorTributo(tributoCalculado.getValor());
            tributo.setValorBaseCalculo(tributoCalculado.getValorBaseCalculo());
            tributo.setValorRenuncia(tributoCalculado.getValorDeducoes());
            tributo.setDebito(debito);
            tributoCalculado.getDeducoes().forEach(deducao -> {
                DebitoTributoIsencaoId debitoTributoIsencaoId = new DebitoTributoIsencaoId();
                debitoTributoIsencaoId.setIsencao(deducao.getIsencao());
                DebitoTributoIsencao isencao = new DebitoTributoIsencao();
                isencao.setId(debitoTributoIsencaoId);
                isencao.setValorIsencao(deducao.getValor());
                isencao.setTributo(tributo);
                tributo.getIsencoes().add(isencao);
            });
            debito.getTributos().add(tributo);
        });
        DividaGrupoVencimento grupoVencimento = this.getGrupoVencimentoCalculo(debito, calculoTabelaValores);
        debito.setParcelas(this.generateDebitoParcela(debito, situacaoParcela, grupoVencimento.getParcelas()));
        debito.verifyAndApplyValorMinimoDebito(parametroIsencaoValorMinimoDebito);
        debito.setDataPrimeiraParcela();
        debito.generateDebitoParcelaTributo(Boolean.TRUE);
        this.verifySituacaoParcelaDebitoIsento(debito);
        debito.verifyAndApplyValorMinimoParcela();
        debito.verifyNumeroMinimoParcela();
        DebitoObservacaoId idObservacao = new DebitoObservacaoId();
        idObservacao.setSequencia(Long.valueOf(1L));
        DebitoObservacao observacao = new DebitoObservacao();
        observacao.setId(idObservacao);
        observacao.setDataInclusao(LocalDate.now());
        observacao.setUsuario(SecurityUtils.getUserAise());
        observacao.setObservacao(String.format("D\u00e9bito gerado a partir do c\u00e1lculo %d.", calculoCadastro.getCalculo().getId()));
        observacao.setDebito(debito);
        debito.getObservacoes().add(observacao);
        debito.setChildrenId();
        debito.setNumeroParcela();
        return this.debitoService.save(debito);
    }

    @Transactional
    public void constituirDebitosCalculo(Long idCalculo) {
        this.debitoService.constituirDebitosCalculo(idCalculo);
    }
}

