/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ExercicioMesId;
import br.com.elotech.tributos.domain.exerciciomes.ExercicioMes;
import br.com.elotech.tributos.domain.exerciciomes.SituacaoExercicioMes;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.repository.ExercicioMesRepository;
import br.com.elotech.tributos.repository.MovimentacaoDiariaRepository;
import br.com.elotech.tributos.service.ContextService;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ExercicioMesService
extends CrudService<ExercicioMes, ExercicioMesId> {
    private final ExercicioMesRepository exercicioMesRepository;
    private final ContextService contextService;
    private final MovimentacaoDiariaRepository movimentacaoDiariaRepository;

    public ExercicioMes fecharAbrirCompetencia(Long competencia, Long exercicio) {
        Long entidade = this.contextService.getEntidadePrincipal();
        ExercicioMes exercicioMes = (ExercicioMes)this.exercicioMesRepository.findById((Object)new ExercicioMesId(entidade, exercicio, competencia)).orElseThrow(() -> new EloValidationException("M\u00eas n\u00e3o encontrado no exerc\u00edcio"));
        if (exercicioMes.getSituacao().equals((Object)SituacaoExercicioMes.ABERTO)) {
            this.exercicioMesRepository.save((Object)this.fecharCompetencia(exercicioMes));
        } else {
            exercicioMes.setSituacao(SituacaoExercicioMes.ABERTO);
        }
        return (ExercicioMes)this.exercicioMesRepository.save((Object)exercicioMes);
    }

    private ExercicioMes fecharCompetencia(ExercicioMes exercicioMes) {
        LocalDate dataInicio = LocalDate.of(exercicioMes.getId().getExercicio().intValue(), exercicioMes.getId().getMes().intValue(), 1);
        LocalDate dataFim = dataInicio.with(TemporalAdjusters.lastDayOfMonth());
        Boolean fecharMes = this.movimentacaoDiariaRepository.findSituacaoByMesAno(exercicioMes.getId().getEntidade(), dataInicio, dataFim).stream().allMatch(md -> md.getSituacao().equals((Object)SituacaoMovimentacaoDiaria.CONTABILIDADE));
        if (Boolean.TRUE.equals(fecharMes)) {
            exercicioMes.setSituacao(SituacaoExercicioMes.FECHADO);
            return exercicioMes;
        }
        throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel fechar o m\u00eas, pois existem movimenta\u00e7\u00f5es abertas");
    }

    public ExercicioMes consultarCompetencia(Long competencia, Long exercicio) {
        Long entidade = this.contextService.getEntidadePrincipal();
        return (ExercicioMes)this.exercicioMesRepository.findById((Object)new ExercicioMesId(entidade, exercicio, competencia)).orElseThrow(() -> new EloValidationException("M\u00eas n\u00e3o encontrado no exerc\u00edcio"));
    }

    public void validaMesAberto(Long competencia, Long exercicio) {
        ExercicioMes exercicioMes = this.consultarCompetencia(competencia, exercicio);
        if (!SituacaoExercicioMes.ABERTO.equals((Object)exercicioMes.getSituacao())) {
            throw new EloValidationException(String.format("O m\u00eas informado %s/%s encontra-se com status %s", competencia, exercicio, exercicioMes.getSituacao().getDescricao()));
        }
    }

    public void validaMesSeguinteAoUltimoFechado(Long competencia, Long exercicio) {
        ExercicioMes exercicioMesPassado = this.consultarCompetencia(Long.valueOf(competencia - 1L), exercicio);
        if (SituacaoExercicioMes.ABERTO.equals((Object)exercicioMesPassado.getSituacao())) {
            Long entidade = this.contextService.getEntidadePrincipal();
            Optional.ofNullable(this.exercicioMesRepository.findUltimoMesFechadoByExercicio(entidade, exercicio)).ifPresentOrElse(ultimoExercicioMesFechado -> {
                throw new EloValidationException(String.format("A carga do m\u00eas %s/%s n\u00e3o pode ser gerada, pois a \u00faltima carga gerada \u00e9 do m\u00eas n\u00famero %s!", competencia, exercicio, ultimoExercicioMesFechado));
            }, () -> {
                throw new EloValidationException(String.format("A carga do m\u00eas %s/%s n\u00e3o pode ser gerada, deve-se gerar primeiro a de Janeiro!", competencia, exercicio));
            });
        }
    }

    @Generated
    public ExercicioMesService(ExercicioMesRepository exercicioMesRepository, ContextService contextService, MovimentacaoDiariaRepository movimentacaoDiariaRepository) {
        this.exercicioMesRepository = exercicioMesRepository;
        this.contextService = contextService;
        this.movimentacaoDiariaRepository = movimentacaoDiariaRepository;
    }
}

