/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.FiltroFormaPagamentoRequestDTO;
import br.com.elotech.tributos.dto.FormaPagamentoResponseDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.rest.dto.GeraCotaUnicaRequestDTO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CotaUnicaVencidaService {
    private final DebitoRepository debitoRepository;
    private final GeraBoletoService geraBoletoService;
    private final AisePdfService aisePdfService;

    public List<FormaPagamentoResponseDTO> findFormasPagamentoFromDebito(FiltroFormaPagamentoRequestDTO filtro) {
        return this.debitoRepository.findFormasPagamentoPorTipo(TipoFormaPagamento.COTA_UNICA, filtro.getEntidade(), filtro.getExercicio(), filtro.getTipoCadastro(), filtro.getCadastroGeral(), filtro.getDivida(), filtro.getSubdivida());
    }

    public BloquetoDTO geraBoleto(GeraCotaUnicaRequestDTO geraCotaUnicaRequestDTO) {
        Debito debito = (Debito)this.debitoRepository.findById((Object)geraCotaUnicaRequestDTO.getIdDebito()).orElseThrow(() -> new EloValidationException("Debito n\u00e3o encontrado"));
        if (debito.getParcelado().equals(Boolean.TRUE) || debito.getReparcelado().equals(Boolean.TRUE)) {
            throw new EloValidationException("N\u00e3o \u00e9 possivel gerar cota \u00fanica vencida, pois o d\u00e9bito j\u00e1 foi parcelado.");
        }
        List debitoParcelaDTOS = debito.getParcelas().stream().map(debitoParcela -> DebitoParcelaDTO.convertBoleto((DebitoParcela)debitoParcela, (Long)geraCotaUnicaRequestDTO.getIdDebito())).collect(Collectors.toList());
        GeraBoletoDTO geraBoletoDTO = this.getGeraBoletoDTO(geraCotaUnicaRequestDTO, debito, debitoParcelaDTOS);
        List listBloqueto = this.geraBoletoService.geraBoleto(geraBoletoDTO, geraCotaUnicaRequestDTO.getIdFormaPagamento(), Boolean.TRUE);
        if (Objects.isNull(listBloqueto) || listBloqueto.isEmpty()) {
            throw new EloValidationException("Erro ao tentar gerar o boleto de cota \u00fanica.");
        }
        return listBloqueto.stream().map(boleto -> {
            BloquetoDTO boletoDTO = boleto.toBloquetoDTO();
            boletoDTO.setUrlImpressao(this.aisePdfService.fetchBloquetoByExercicio(boletoDTO.getBloqueto(), boletoDTO.getExercicioBloqueto()));
            return boletoDTO;
        }).findFirst().orElseThrow(() -> new EloValidationException("Erro ao tentar gerar url de impress\u00e3o do boleto."));
    }

    private GeraBoletoDTO getGeraBoletoDTO(GeraCotaUnicaRequestDTO geraCotaUnicaRequestDTO, Debito debito, List<DebitoParcelaDTO> debitoParcelaDTOS) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.COTA_UNICA);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setExercicio(debito.getExercicio());
        geraBoletoDTO.setDataVencimento(geraCotaUnicaRequestDTO.getDataVencimento());
        geraBoletoDTO.setUsuario(debito.getUsuario());
        geraBoletoDTO.setPessoa(geraCotaUnicaRequestDTO.getPessoa());
        geraBoletoDTO.setDebitos(debitoParcelaDTOS);
        geraBoletoDTO.setObservacao(geraCotaUnicaRequestDTO.getObservacao());
        geraBoletoDTO.setAnoProcesso(geraCotaUnicaRequestDTO.getAnoProcesso());
        geraBoletoDTO.setNumeroProcesso(geraCotaUnicaRequestDTO.getNumeroProcesso());
        geraBoletoDTO.setRegerarCotaUnicaVencida(Boolean.TRUE);
        return geraBoletoDTO;
    }

    @Generated
    public CotaUnicaVencidaService(DebitoRepository debitoRepository, GeraBoletoService geraBoletoService, AisePdfService aisePdfService) {
        this.debitoRepository = debitoRepository;
        this.geraBoletoService = geraBoletoService;
        this.aisePdfService = aisePdfService;
    }
}

