/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.multitenant.utils.ResponseUtils;
import br.com.elotech.tributos.security.SecurityUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class GeoSecurityFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoSecurityFilter.class);
    private final ObjectMapper objectMapper;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (!SecurityUtils.isUsuarioIntegracaoGeo().booleanValue()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.debug("Token identificado como usu\u00e1rio de integra\u00e7\u00e3o do geo");
        Optional tenantToken = SecurityUtils.getTenantIntegracaoGeo();
        if (tenantToken.isEmpty()) {
            log.error("Token de integra\u00e7\u00e3o sem tenant");
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.UNAUTHORIZED, (String)"N\u00e3o foi poss\u00edvel identificar o tenant do token informado.");
            return;
        }
        String tenantRequisicao = TenantContextHolder.getCurrentTenantId();
        if (!tenantRequisicao.equals(tenantToken.get())) {
            log.error("Token do geo do tenant {} tentando acessar dados do tenant {}", tenantToken.get(), (Object)tenantRequisicao);
            String mensagem = String.format("O token tem acesso ao tenant %s mas est\u00e1 tentando acessar dados do tenant %s.", tenantToken.get(), tenantRequisicao);
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagem);
            return;
        }
        String uriWithoutContextPath = request.getRequestURI().replace(request.getContextPath(), "");
        if (!uriWithoutContextPath.startsWith("/api/elogeo/")) {
            log.error("Token do tenant {} tentando acessar recursos que n\u00e3o s\u00e3o do GEO. Recurso acessado: {}", tenantToken.get(), (Object)request.getRequestURI());
            String mensagemFormatada = String.format("Esse token s\u00f3 tem permiss\u00e3o para acessar os recursos de geo-referenciamento e est\u00e1 tentando acessar o recurso %s.", uriWithoutContextPath);
            ResponseUtils.sendError((HttpServletResponse)response, (ObjectMapper)this.objectMapper, (HttpStatus)HttpStatus.FORBIDDEN, (String)mensagemFormatada);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    @Generated
    public GeoSecurityFilter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

