/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gerar-boletos"})
public class GeraBoletoResource {
    private final AisePdfService aisePdfService;
    private final GeraBoletoService geraBoletoService;
    private final HistoricoAtendimentoService historicoAtendimentoService;

    public GeraBoletoResource(AisePdfService aisePdfService, GeraBoletoService geraBoletoService, HistoricoAtendimentoService historicoAtendimentoService) {
        this.geraBoletoService = geraBoletoService;
        this.aisePdfService = aisePdfService;
        this.historicoAtendimentoService = historicoAtendimentoService;
    }

    @PostMapping
    public ResponseEntity<List<BloquetoDTO>> geraBoletos(@RequestBody @Valid GeraBoletoDTO geraBoletoDTO) {
        List boletos = this.geraBoletoService.geraBoleto(geraBoletoDTO);
        List boletosDTO = boletos.stream().map(boleto -> {
            BloquetoDTO boletoDTO = boleto.toBloquetoDTO();
            return boletoDTO;
        }).collect(Collectors.toList());
        String observacaoHistorico = String.format("Gera\u00e7\u00e3o de boleto(s) %s ", boletosDTO.stream().map(b -> b.getBloqueto() + "/" + b.getExercicioBloqueto()).collect(Collectors.joining(", ")));
        this.historicoAtendimentoService.createHistoricoAtendimento(observacaoHistorico, TipoAcaoAtendimento.GERACAO_BOLETO);
        if (boletosDTO.size() > 1) {
            String urlImpressao = this.geraBoletoService.getUrlImpressaoParcelado(boletosDTO);
            return ResponseEntity.ok(boletosDTO.stream().map(bloquetoDTO -> {
                bloquetoDTO.setUrlImpressao(urlImpressao);
                return bloquetoDTO;
            }).collect(Collectors.toList()));
        }
        return ResponseEntity.ok(boletos.stream().map(boleto -> {
            BloquetoDTO boletoDTO = boleto.toBloquetoDTO();
            boletoDTO.setUrlImpressao(this.aisePdfService.fetchBloquetoByExercicio(boletoDTO.getBloqueto(), boletoDTO.getExercicioBloqueto()));
            return boletoDTO;
        }).collect(Collectors.toList()));
    }
}

