/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.repository.projections.DocumentoFinalidadeProjection;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentofinalidade"})
public class DocumentoFinalidadeResource
extends ReadOnlyResource<DocumentoFinalidade, Long> {
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final ContextService contextService;

    public DocumentoFinalidadeResource(DocumentoFinalidadeService documentoFinalidadeService, ContextService contextService) {
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.contextService = contextService;
    }

    @GetMapping(params={"tipoCertidao"})
    public ResponseEntity<List<DocumentoFinalidadeProjection>> getFinalidade(String tipoCertidao) {
        return ResponseEntity.ok().body((Object)this.documentoFinalidadeService.getListDTO(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), TipoDocumentoEnum.fromString((String)tipoCertidao).getCodigo()));
    }
}

