/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.reportexport.exporter.BaseExport;
import br.com.elotech.reportexport.exporter.ReportParam;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.batch.ConsultaDebitoJobStarter;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.Param;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/api/consulta-debito"})
public class ConsultaDebitoResource {
    private final ConsultaDebitoJobStarter consultaDebitoJobStarter;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;
    private final DebitoService debitoService;
    private final BaseExport baseExport;

    @PostMapping
    public ResponseEntity<ConsultaDebito> consultarDebito(@Valid @RequestBody FiltroConsultaDebitoDTO filtro) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JsonProcessingException {
        this.debitoService.totalDebitosConstituidos(filtro);
        this.consultaDebitoJobStarter.startJob(filtro);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{idConsulta}"}, params={"tipoAgrupamento"})
    public ResponseEntity<Page<ConsultaDebitoItemDTO>> findDebitos(@PathVariable Long idConsulta, @Param(value="tipoAgrupamento") String tipoAgrupamento, Pageable pageable) {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getDebitos(idConsulta, tipoAgrupamento, pageable));
    }

    @GetMapping(value={"/{idConsulta}/filtro"})
    public ResponseEntity<FiltroConsultaDebitoDTO> getFiltro(@PathVariable Long idConsulta) throws JsonProcessingException {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getFiltro(idConsulta));
    }

    @GetMapping(value={"/{idConsulta}/resumo"})
    public ResponseEntity<ConsultaDebitoValoresDTO> getResumo(@PathVariable Long idConsulta) {
        return ResponseEntity.ok((Object)this.consultaDebitoBatchService.getResumo(idConsulta));
    }

    @GetMapping(value={"/{idConsulta}/report"})
    public ModelAndView imprimir(@PathVariable Long idConsulta, @RequestParam(value="tipoAgrupamento") String tipoAgrupamento, @RequestParam(value="fields") String fields, @RequestParam(value="sumFields") String sumFields, Pageable pageable) throws JsonProcessingException {
        PageRequest pageRequest = this.baseExport.toPageRequest(Optional.of(5000), pageable);
        Object search = "";
        FiltroConsultaDebitoDTO filtro = this.consultaDebitoBatchService.getFiltro(idConsulta);
        if (Objects.nonNull(filtro)) {
            search = " tipoAgrupamento: " + filtro.getTipoAgrupamento() + " calculaAcrescimo:" + filtro.getCalcularAcrescimos() + " dataReferencia:" + filtro.getDataReferencia() + " dataLancamentoInicial:" + filtro.getDataLancamentoInicial() + " dataLancamentoFinal:" + filtro.getDataLancamentoFinal() + " dataVencimentoInicial:" + filtro.getDataVencimentoInicial() + " dataVencimentoFinal:" + filtro.getDataVencimentoFinal() + " situacaoParcela:" + filtro.getSituacaoParcela() + " contribuinte: " + filtro.getPessoa() + " tipoCadastro:" + filtro.getTipoCadastro() + " cadastroGeral:" + filtro.getCadastroGeral() + " anoDebito:" + filtro.getAnoDebito() + " Divida:" + filtro.getDivida() + " subDivida:" + filtro.getSubDivida() + " parcelasEmAberto:" + filtro.getSomenteParcelasEmAberto() + " noExercicio:" + filtro.getNoExercicio() + " dividaAtiva:" + filtro.getDividaAtiva() + " emJuizo:" + filtro.getJuizo();
            search = ((String)search).replace("null", "").replace("false", "n\u00e3o").replace("true", "sim");
        }
        Page page = this.consultaDebitoBatchService.getDebitos(idConsulta, tipoAgrupamento, (Pageable)pageRequest);
        ReportParam reportParam = ReportParam.builder().clazzDTO(ConsultaDebitoItemDTO.class).fields(fields).sumFields(sumFields).maxRecord(0).page(page).reportTitle("Consulta de D\u00e9bitos").searchFilter((String)search).build();
        return this.baseExport.toHTML(reportParam);
    }

    @Generated
    public ConsultaDebitoResource(ConsultaDebitoJobStarter consultaDebitoJobStarter, ConsultaDebitoBatchService consultaDebitoBatchService, DebitoService debitoService, BaseExport baseExport) {
        this.consultaDebitoJobStarter = consultaDebitoJobStarter;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
        this.debitoService = debitoService;
        this.baseExport = baseExport;
    }
}

