/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.dto.ComunicadoCadastroDto;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/comunicados-cadastros"})
public class ComunicadoCadastroResource {
    private final ComunicadoCadastroService comunicadoCadastroService;

    @GetMapping(value={"/{entidade}/{exercicio}/{idComunicado}"})
    public ResponseEntity<Page<ComunicadoCadastroDto>> searchComunicadoCadastro(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.comunicadoCadastroService.findByRsqlComunicadoCadastro(entidade, exercicio, idComunicado, search, pageable));
    }

    @PutMapping(value={"/{entidade}/{exercicio}/{idComunicado}/{sequencia}/cancelar"})
    public ResponseEntity<ComunicadoCadastroDto> cancelaComunicadoCadastro(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @PathVariable Long sequencia) {
        return ResponseEntity.ok((Object)this.comunicadoCadastroService.cancelaComunicadoCadastro(entidade, exercicio, idComunicado, sequencia));
    }

    @PutMapping(value={"/{entidade}/{exercicio}/{idComunicado}/{sequencia}/valida-endereco"})
    public ResponseEntity<ComunicadoCadastroDto> validateEnderecoNotificacao(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @PathVariable Long sequencia) {
        return ResponseEntity.ok((Object)this.comunicadoCadastroService.validateEnderecoNotificacao(entidade, exercicio, idComunicado, sequencia));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{idComunicado}/{sequencia}/imprimir"})
    public void print(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long idComunicado, @PathVariable Long sequencia, HttpServletResponse response) throws IOException {
        byte[] file = this.comunicadoCadastroService.print(entidade, exercicio, idComunicado, sequencia);
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])file, (String)"comunicado.pdf");
    }

    @Generated
    public ComunicadoCadastroResource(ComunicadoCadastroService comunicadoCadastroService) {
        this.comunicadoCadastroService = comunicadoCadastroService;
    }
}

