/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.CertidaoDebitosService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/certidao-debitos"})
public class CertidaoDebitosResource {
    private final CertidaoDebitosService certidaoDebitosService;
    private final AisePdfService aisePdfService;
    private final DocumentoService documentoService;

    public CertidaoDebitosResource(CertidaoDebitosService certidaoDebitosService, AisePdfService aisePdfService, DocumentoService documentoService) {
        this.certidaoDebitosService = certidaoDebitosService;
        this.aisePdfService = aisePdfService;
        this.documentoService = documentoService;
    }

    @PostMapping(value={"/contribuinte/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValuesContribuinte(@RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.CERTIDAO_CONTRIBUINTE));
    }

    @PostMapping(value={"/cadastro/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValuesCadastro(@RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.CERTIDAO_CADASTRO_MUNICIPAL));
    }

    @PostMapping(value={"/contribuinte"})
    public ResponseEntity<ImpressaoDTO> geraCertidaoPorContribuinte(@RequestBody @Valid DocumentoGenericoDTO documentoGenericoDTO) {
        DocumentoDTO dto = this.certidaoDebitosService.geraCertidaoPorContribuinte(documentoGenericoDTO);
        dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
        return ResponseEntity.ok((Object)ImpressaoDTO.from((Long)dto.getId(), (String)dto.getUrl()));
    }

    @PostMapping(value={"/cadastro"})
    public ResponseEntity<ImpressaoDTO> geraCertidaoPorCadastro(@RequestBody @Valid DocumentoGenericoDTO documentoGenericoDTO) {
        DocumentoDTO dto = this.certidaoDebitosService.geraCertidaoPorCadastro(documentoGenericoDTO);
        dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
        return ResponseEntity.ok((Object)ImpressaoDTO.from((Long)dto.getId(), (String)dto.getUrl()));
    }
}

