/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.CadastroGeralAcessoWebDTO;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroPossuiDebitoVencidoDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.cadastrogeralimagem.ArquivoCadastroGeralDTO;
import br.com.elotech.tributos.dto.mobile.CadastroGeralMobileDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoCadastroDTO;
import br.com.elotech.tributos.enums.hibernatesearch.StatusHibernateSearchIndexed;
import br.com.elotech.tributos.enums.hibernatesearch.TipoCadastroIndexacao;
import br.com.elotech.tributos.hibernatesearch.dto.IndexacaoHibernateSearchDTO;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.service.CadastroGeralImagemService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/api/cadastro-geral"})
public class CadastroGeralResource
extends CrudResource<CadastroGeral, Long> {
    private final CadastroGeralService cadastroGeralService;
    private final Long TIMEOUTEMITTER = Long.MAX_VALUE;
    private final CadastroGeralImagemService cadastroGeralImagemService;

    public CadastroGeralResource(CadastroGeralService cadastroGeralService, CadastroGeralImagemService cadastroGeralImagemService) {
        this.cadastroGeralService = cadastroGeralService;
        this.cadastroGeralImagemService = cadastroGeralImagemService;
    }

    @GetMapping(params={"cnpjCpf"})
    public ResponseEntity<List<CadastroGeral>> getByCnpjCpf(@RequestParam(value="cnpjCpf") String cnpjCpf) {
        return ResponseEntity.ok().body((Object)this.loadByCnpjCpf(cnpjCpf));
    }

    @GetMapping(path={"/getCadastros"}, params={"cpf"})
    public ResponseEntity<List<CadastroGeralAcessoWebDTO>> getCadastrosByCnpjCpf(@RequestParam(value="cpf") String cnpjCpf) {
        return ResponseEntity.ok().body((Object)this.cadastroGeralService.getCadastrosByCnpjCpf(cnpjCpf));
    }

    @PutMapping(path={"/{id}/restore"})
    public void restoreCadastroGeral(@PathVariable(value="id") Long id) {
        this.cadastroGeralService.restoreCadastroGeral(id);
    }

    @GetMapping(path={"/cadastros-com-carnes"}, params={"cpf"})
    public ResponseEntity<List<CadastroGeralAcessoWebDTO>> getCadastrosComCarneByCnpjCpf(@RequestParam(value="cpf") String cnpjCpf) {
        return ResponseEntity.ok().body((Object)this.cadastroGeralService.getCadastrosComCarneByCnpjCpf(cnpjCpf));
    }

    @GetMapping(path={"/getCadastro"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<CadastroGeralAcessoWebDTO> getCadastro(CadastroGeralParams params) {
        Optional cadastroAcessoWebDto = this.cadastroGeralService.getCadastro(params.getTipoCadastro(), params.getCadastroGeral());
        if (!cadastroAcessoWebDto.isPresent()) {
            this.throwCadastroGeralNaoEncontrado(params);
        }
        return ResponseEntity.ok().body((Object)((CadastroGeralAcessoWebDTO)cadastroAcessoWebDto.get()));
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<CadastroGeral> getByTipoCadastroAndCadastroGeral(CadastroGeralParams params) {
        Optional cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(params.getTipoCadastro(), params.getCadastroGeral());
        if (!cadastroGeral.isPresent()) {
            this.throwCadastroGeralNaoEncontrado(params);
        }
        return ResponseEntity.ok().body((Object)((CadastroGeral)cadastroGeral.get()));
    }

    private List<CadastroGeral> loadByCnpjCpf(String cnpjCpf) {
        return this.cadastroGeralService.findByPessoaCnpjCpf(cnpjCpf);
    }

    private void throwCadastroGeralNaoEncontrado(CadastroGeralParams params) {
        throw RestException.notFound((String)String.format("Cadastro %d n\u00e3o encontrado", params.getCadastroGeral()), (Throwable)new CadastroNaoEncontradoException(params.getTipoCadastro(), params.getCadastroGeral()));
    }

    @GetMapping(path={"/by-cpf-cnpj/{cpfCnpj}"})
    public ResponseEntity<Page<ParcelamentoCadastroDTO>> getCadastrosByCpfCnpj(@PathVariable String cpfCnpj, @RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok().body((Object)this.cadastroGeralService.getCadastrosByCpfCnpj(cpfCnpj, search, page));
    }

    @PostMapping(value={"/populate-index"})
    public ResponseEntity<Void> indexCadastrosGerais() throws InterruptedException {
        this.cadastroGeralService.indexCadastrosGerais();
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/populate-index-by-tipo-cadastro"})
    public SseEmitter indexCadastrosPorTipoCadastro(@RequestHeader(value="tipoCadastro") Long tipoCadastro) throws IOException {
        TipoCadastroIndexacao tipoCadastroIndexacao = TipoCadastroIndexacao.fromValue((Long)tipoCadastro);
        SseEmitter emitter = new SseEmitter(this.TIMEOUTEMITTER);
        try {
            this.cadastroGeralService.indexCadastrosPorTipoCadastro(tipoCadastroIndexacao, emitter);
        }
        catch (Exception ex) {
            IndexacaoHibernateSearchDTO indexedHibernateSearch = new IndexacaoHibernateSearchDTO();
            indexedHibernateSearch.setTipoCadastro(tipoCadastroIndexacao);
            indexedHibernateSearch.setStatus(StatusHibernateSearchIndexed.ERRO);
            indexedHibernateSearch.setMessageError(ex.getMessage());
            indexedHibernateSearch.setCompleted(Boolean.TRUE);
            emitter.send((Object)indexedHibernateSearch);
            emitter.complete();
        }
        return emitter;
    }

    @PostMapping(value={"/populate-index/{id}"})
    public ResponseEntity<Void> indexCadastroGeralById(@PathVariable Long id) {
        this.cadastroGeralService.indexCadastroGeralById(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(path={"/resumo-mobile"}, params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<CadastroGeralMobileDTO> getCadastroGeralResumidoMobile(CadastroGeralParams params) {
        return ResponseEntity.ok().body((Object)this.cadastroGeralService.getCadastroGeralResumidoMobile(params.getTipoCadastro(), params.getCadastroGeral()));
    }

    @GetMapping(path={"/{id}/resumo"})
    public ResponseEntity<CadastroGeralDTO> getCadastroGeralResumo(@PathVariable Long id) {
        CadastroGeralDTO cadastroGeralDTO = this.cadastroGeralService.findById((Serializable)id).map(CadastroGeral::toCadastroGeralDTOWithPessoa).orElseThrow(() -> RestException.notFound((String)String.format("N\u0101o foi poss\u00edvel encontrar cadastro com o id %d", id)));
        return ResponseEntity.of(Optional.of(cadastroGeralDTO));
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<CadastroSearchDTO> searchCadastros(@RequestBody CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroGeralService.searchCadastros(searchParams, pageable));
    }

    @GetMapping(value={"/{id}/arquivos"})
    public ResponseEntity<Page<ArquivoCadastroGeralDTO>> findArquivos(@PathVariable Long id, Pageable page) {
        return ResponseEntity.ok((Object)this.cadastroGeralImagemService.findArquivos(id, page));
    }

    @PostMapping(value={"/{id}/arquivo"})
    public ResponseEntity<Void> uploadArquivo(@PathVariable Long id, @RequestParam(value="files") MultipartFile file) {
        ResponseEntity.ok((Object)this.cadastroGeralImagemService.uploadArquivo(id, file));
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @DeleteMapping(value={"/{tipoCadastro}/{cadastroGeral}"})
    public ResponseEntity<CadastroGeral> excludeCadastroLogicamente(@PathVariable TipoCadastro tipoCadastro, @PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.cadastroGeralService.excludeCadastroLogicamente(tipoCadastro, cadastroGeral));
    }

    @GetMapping(path={"/{id}/verifica-possui-debito-vencido"})
    public ResponseEntity<CadastroPossuiDebitoVencidoDTO> possuiDebitoVencido(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)new CadastroPossuiDebitoVencidoDTO(this.cadastroGeralService.hasDebitoVencido(id)));
    }

    @GetMapping(path={"/{cadastroGeral}/{tipoCadastro}/is-inadimplente"})
    public ResponseEntity<Boolean> isInadimplente(@PathVariable(value="cadastroGeral") Long cadastroGeral, @PathVariable(value="tipoCadastro") Long tipoCadastro) {
        return ResponseEntity.ok((Object)this.cadastroGeralService.isInadimplente(cadastroGeral, tipoCadastro));
    }
}

