/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.mobiliario.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.mobile.CadastroMobiliarioMobileDTO;
import br.com.elotech.tributos.repository.mobiliario.CadastroMobiliarioRepositoryCustom;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CadastroMobiliarioRepositoryImpl
implements CadastroMobiliarioRepositoryCustom {
    private static final String SQL_BASE_CADASTROS_ATIVOS = "SELECT DISTINCT TCM.CADASTROGERAL AS CADASTROGERAL, PES.CNPJ_CPF AS CPFCNPJ, PES.NOME AS RAZAOSOCIAL, PES.NOMEFANTASIA AS NOMEFANTASIA FROM TRIBCADASTROMOBILIARIO TCM JOIN TRIBCADASTROGERAL TCG \tON (TCM.TIPOCADASTRO = TCG.TIPOCADASTRO \tAND TCM.CADASTROGERAL = TCG.CADASTROGERAL) JOIN TRIBMOBILIARIOSITUACAO TIS \tON (TCG.TIPOCADASTRO = TIS.TIPOCADASTRO \tAND TCG.CADASTROGERAL = TIS.CADASTROGERAL) JOIN TRIBSITUACAOMOBILIARIO TSI  \tON TIS.SITUACAOMOBILIARIO = TSI.SITUACAOMOBILIARIO JOIN TRIBTIPOSITUACAOMOBILIARIO TTSM  \tON TTSM.TIPOSITUACAOMOBILIARIO = TSI.TIPOSITUACAOMOBILIARIO JOIN PESSOA PES \tON PES.PESSOA = TCG.PESSOA JOIN TRIBMOBILIARIOCNAE TMC \tON (TMC.CADASTROGERAL = TCM.CADASTROGERAL \tAND TMC.TIPOCADASTRO = TCM.TIPOCADASTRO) JOIN CNAE CN \tON CN.CNAE = TMC.CNAE JOIN CNAESECAO CNS \tON CNS.SECAO = CN.SECAO WHERE TCG.TIPOCADASTRO = 2 AND TIS.ATUAL = 'S'    AND TTSM.ENCERRAMENTO = 'N' AND TCG.EXCLUSAOLOGICA = 'N' ";
    private static final String SQL_CADASTROS_POR_RAZAO_SOCIAL_OU_FANTASIA = "AND (UPPER(PES.NOME) LIKE UPPER(:nome) OR UPPER(PES.NOMEFANTASIA) LIKE UPPER(:nome)) ";
    private static final String SQL_CADASTROS_POR_GRUPO_ATIVIDADE = "AND CNS.SECAO = :grupoAtividade ";
    private static final String SQL_ORDENACAO_POR_RAZAO_SOCIAL = "ORDER BY PES.NOME ";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public CadastroMobiliarioRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public Page<CadastroMobiliarioMobileDTO> searchCadastrosAtivosByNomeAndGrupoAtividade(String nome, String grupoAtividade, Pageable pageable) {
        String sql = SQL_BASE_CADASTROS_ATIVOS;
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (StringUtils.isNotBlank((CharSequence)nome)) {
            sql = sql.concat(SQL_CADASTROS_POR_RAZAO_SOCIAL_OU_FANTASIA);
            params.addValue("nome", (Object)("%" + nome + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)grupoAtividade)) {
            sql = sql.concat(SQL_CADASTROS_POR_GRUPO_ATIVIDADE);
            params.addValue("grupoAtividade", (Object)grupoAtividade);
        }
        sql = sql.concat(SQL_ORDENACAO_POR_RAZAO_SOCIAL);
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        Long numeroTotal = (Long)this.namedParameterJdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)params, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)sql, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List cadastrosDTO = this.namedParameterJdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(CadastroMobiliarioMobileDTO.class));
        return new PageImpl(cadastrosDTO, pageable, numeroTotal.longValue());
    }
}

