/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.jpa.support.EloSequenceCache;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.dto.BoletoDTO;
import br.com.elotech.tributos.dto.FiltroBoletoDTO;
import br.com.elotech.tributos.repository.BoletoRepositoryCustom;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

@Repository
public class BoletoRepositoryImpl
implements BoletoRepositoryCustom {
    private final EntityManager entityManager;
    private final EntityManagerFactory em;
    private final EloSequenceCache eloSequenceCache;

    public BoletoRepositoryImpl(EntityManager entityManager, EntityManagerFactory em, EloSequenceCache eloSequenceCache) {
        this.entityManager = entityManager;
        this.em = em;
        this.eloSequenceCache = eloSequenceCache;
    }

    public void geraCodigoBoleto(Bloqueto boleto) {
        EloSequenceGenerator.attrNextValues((Object)boleto, (SessionFactory)((SessionFactory)this.em.unwrap(SessionFactoryImplementor.class)), (EloSequenceCache)this.eloSequenceCache);
    }

    public Page<BoletoDTO> findBoleto(Long entidade, FiltroBoletoDTO filtroBoletoDTO, Pageable pageable) {
        String sqlFrom = String.format(" from Bloqueto boleto  join boleto.debitos boletoDebito  join boletoDebito.id.debitoParcelaTributo tributo  join tributo.debitoParcela debitoParcela  join boleto.pessoa pessoa  where boleto.entidade = :entidade  %s", filtroBoletoDTO.buildFiltro());
        StringBuilder sqlOrderBy = new StringBuilder("order by ").append(SqlUtils.convertSortToString((Sort)pageable.getSort()));
        String sqlBoletos = String.format(" select distinct boleto.id as id,  boleto.entidade as entidade,  boleto.bloqueto as boleto,  boleto.exercicioBloqueto as exercicioBoleto,  boleto.tipoBloqueto as tipoBoleto,  boleto.dataEmissao as dataEmissao,  boleto.dataVencimento as dataVencimento,  boleto.dataLimitePagamento as dataLimitePagamento,  boleto.pago as pago,  boleto.pessoa.id as idPessoa,  boleto.pessoa.nome as nome,  boleto.codigoBarras as codigoBarras,  boleto.valorPrincipal as valorPrincipal,  boleto.valorJuros as valorJuros,  boleto.valorMulta as valorMulta,  boleto.valorCorrecao as valorCorrecao,  boleto.valorDesconto as valorDesconto  %s %s", sqlFrom, sqlOrderBy);
        String sqlCount = String.format(" select count(distinct boleto.id) %s", sqlFrom);
        Long quantidadeTotal = (Long)this.entityManager.createQuery(sqlCount, Long.class).setParameter("entidade", (Object)entidade).getSingleResult();
        List result = ((Query)this.entityManager.createQuery(sqlBoletos).setParameter("entidade", (Object)entidade).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).unwrap(Query.class)).setResultTransformer(Transformers.aliasToBean(BoletoDTO.class)).getResultList();
        return new PageImpl(result, pageable, quantidadeTotal.longValue());
    }
}

