/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.sql.SqlWhere;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.LoteBatchInstanceDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.ResultSet;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class JobLoteProtestoRepository {
    private static final String SQL_JOB_CRIACAO_PROTESTO_BY_FILTRES = "br/com/elotech/tributos/repository/find-job-protesto-by-filter.sql";
    private NamedParameterJdbcTemplate namedJdbcTemplate;

    public JobLoteProtestoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<LoteBatchInstanceDTO> getLoteProtestosByIdJob(Long idJob) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/find-job-protesto-by-filter.sql");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("idLote", (Object)idJob);
        String finalSql = sql.replace("$[FILTROS]", " and bje.job_execution_id = :idLote ");
        return this.namedJdbcTemplate.query(finalSql, (SqlParameterSource)parameters, (rs, rowNum) -> LoteBatchInstanceDTO.from((ResultSet)rs));
    }

    public Page<LoteBatchInstanceDTO> getLoteProtestos(Optional<String> search, Pageable pageable) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/find-job-protesto-by-filter.sql");
        String finalSql = sql.replace("$[FILTROS]", this.addFilterTela(search));
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        Optional sqlWhere = JobLoteProtestoRepository.createNewConditions((String)search.get());
        if (sqlWhere.isPresent()) {
            parameters = new MapSqlParameterSource(((SqlWhere)sqlWhere.get()).getParams());
        }
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", finalSql);
        Long numeroTotal = (Long)this.namedJdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)finalSql, (Pageable)pageable, (DataSource)this.namedJdbcTemplate.getJdbcTemplate().getDataSource());
        List lista = this.namedJdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (rs, rowNum) -> LoteBatchInstanceDTO.from((ResultSet)rs));
        return new PageImpl(lista, pageable, numeroTotal.longValue());
    }

    private StringBuilder addFilterTela(Optional<String> search) {
        StringBuilder stringBuilder = new StringBuilder();
        if (search.isPresent()) {
            String filtro = search.get();
            Optional filtros = JobLoteProtestoRepository.createNewConditions((String)filtro);
            filtros.ifPresent(sqlWhere -> stringBuilder.append(String.format(" and %s ", sqlWhere.getWhere()).replace("instanceId ", "bji.job_instance_id ").replace("dataInicio ", "trunc(bje.start_time) ")));
        }
        return stringBuilder;
    }

    private static Optional<SqlWhere> createNewConditions(String filtro) {
        return StringUtils.isNotBlank((CharSequence)filtro) ? Optional.of(RsqlUtils.transformToSql((String)filtro, LoteBatchInstanceDTO.class)) : Optional.empty();
    }
}

