/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.cadastroimobiliario;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.SituacaoImobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoEnderecoCorrespondencia;
import br.com.elotech.tributos.domain.TipoImovel;
import br.com.elotech.tributos.domain.TipoLote;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAreaVerde;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioProfundidade;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CondominioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.LoteamentoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ObservacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ProprietarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.SegmentoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.TestadaDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.TestadaGenericaDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import br.com.elotech.tributos.dto.sanepar.SaneparMatriculaDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CadastroImobiliarioDTO {
    private Long id;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private Long cadastroGeralAnterior;
    private TipoImovel tipoImovel = TipoImovel.TERRITORIAL;
    @NotNull
    private TipoLote tipoLote;
    @JsonIgnoreProperties(value={"tipoSituacaoImobiliario"})
    private SituacaoImobiliario situacaoImobiliario;
    private Quadricula quadriculaLocalizacao;
    private Distrito distritoLocalizacao;
    @JsonIgnoreProperties(value={"quadras"})
    private Setor setorLocalizacao;
    private SetorQuadra quadraLocalizacao;
    private String loteLocalizacao;
    private String unidadeLocalizacao;
    private String inscricaoCadastral;
    private String inscricaoCadastralAnterior;
    private LoteamentoDTO loteamento;
    private BairroDTO bairro;
    @NotNull
    private String cep;
    private String complemento;
    private String faceQuadra;
    private CondominioDTO condominio;
    private LogradouroDTO logradouro;
    private Cidade cidade;
    private String matricula;
    private String usuario;
    private LocalDate dataAlteracao;
    private LocalDate dataInclusao;
    private Boolean englobado;
    private Boolean exclusaoLogica;
    private LocalDate dataMatricula;
    private String cartorio;
    private String livro;
    private String folha;
    private String quadraFiscalizacao;
    private String loteFiscalizacao;
    private String complementoLote;
    private String numero;
    private List<ProprietarioDTO> proprietarios = new ArrayList();
    private BigDecimal areaLote = BigDecimal.ZERO;
    private BigDecimal areaUtilLote = BigDecimal.ZERO;
    private BigDecimal areaPrivativa = BigDecimal.ZERO;
    private BigDecimal areaComum = BigDecimal.ZERO;
    private List<CadastroImobiliarioProfundidade> profundidades = new ArrayList();
    private List<TestadaDTO> testadas = new ArrayList();
    private List<TestadaGenericaDTO> testadasGenericas = new ArrayList();
    private List<CadastroImobiliarioAreaVerde> areasVerde = new ArrayList();
    private List<SaneparMatriculaDTO> convenioSaneparMatriculas = new ArrayList();
    private List<GrupoRespostasDTO> respostasTerreno = new ArrayList();
    private List<SegmentoDTO> segmentos = new ArrayList();
    private BigDecimal areaTotalConstruida = BigDecimal.ZERO;
    private BigDecimal areaTotalNaoLancada = BigDecimal.ZERO;
    private BigDecimal areaTotalInscricao = BigDecimal.ZERO;
    private BigDecimal areaUnidadeConstruida = BigDecimal.ZERO;
    private List<ObservacaoDTO> observacoes = new ArrayList();
    private String cepCorrespondencia;
    private String enderecoCorrespondencia;
    private String numeroCorrespondencia;
    private String complementoCorrespondencia;
    private String bairroCorrespondencia;
    private String cidadeUfCorrespondencia;
    private String ufCorrespondencia;
    private TipoEnderecoCorrespondencia tipoEnderecoCorrespondencia;

    public static CadastroImobiliarioDTO from(CadastroImobiliario entity) {
        CadastroImobiliarioDTO dto = new CadastroImobiliarioDTO();
        dto.setId(entity.getId());
        dto.setTipoCadastro(entity.getTipoCadastro());
        dto.setCadastroGeral(entity.getCadastroGeral());
        dto.setCadastroGeralAnterior(entity.getCadastroGeralAnterior());
        dto.setTipoImovel(entity.getTipoImovel());
        dto.setTipoLote(entity.getTipoLote());
        dto.setSituacaoImobiliario(entity.getSituacaoImobiliario());
        dto.setQuadriculaLocalizacao(entity.getQuadriculaLocalizacao());
        dto.setDistritoLocalizacao(entity.getDistritoLocalizacao());
        dto.setSetorLocalizacao(entity.getSetorLocalizacao());
        dto.setQuadraLocalizacao(entity.getQuadraLocalizacao());
        dto.setLoteLocalizacao(entity.getLoteLocalizacao());
        dto.setUnidadeLocalizacao(entity.getUnidadeLocalizacao());
        dto.setInscricaoCadastral(entity.getInscricaoCadastral());
        dto.setInscricaoCadastralAnterior(entity.getInscricaoCadastralAnterior());
        dto.setCidade(entity.getCidade());
        dto.setMatricula(entity.getMatricula());
        Optional.ofNullable(entity.getLogradouro()).ifPresent(logradouro -> dto.setLogradouro(LogradouroDTO.from((Logradouro)logradouro)));
        Optional.ofNullable(entity.getLoteamento()).map(LoteamentoDTO::from).ifPresent(arg_0 -> dto.setLoteamento(arg_0));
        Optional.ofNullable(entity.getBairro()).map(BairroDTO::from).ifPresent(arg_0 -> dto.setBairro(arg_0));
        Optional.ofNullable(entity.getCep()).ifPresent(cep -> dto.setCep(StringUtils.leftPad((String)cep.toString(), (int)8, (String)"0")));
        dto.setComplemento(entity.getComplemento());
        Optional.ofNullable(entity.getCondominio()).map(CondominioDTO::from).ifPresent(arg_0 -> dto.setCondominio(arg_0));
        dto.setUsuario(entity.getUsuario());
        dto.setDataAlteracao(entity.getDataAlteracao());
        dto.setDataInclusao(entity.getDataInclusao());
        dto.setEnglobado(entity.getEnglobado());
        dto.setExclusaoLogica(entity.getExclusaoLogica());
        dto.setFaceQuadra(entity.getFaceQuadra());
        dto.setDataMatricula(entity.getDataMatricula());
        dto.setCartorio(entity.getCartorio());
        dto.setLivro(entity.getLivro());
        dto.setFolha(entity.getFolha());
        dto.setQuadraFiscalizacao(entity.getQuadraFiscalizacao());
        dto.setLoteFiscalizacao(entity.getLoteFiscalizacao());
        dto.setComplementoLote(entity.getComplementoLote());
        dto.setNumero(entity.getNumero());
        dto.setProprietarios(entity.getProprietarios().stream().map(ProprietarioDTO::from).collect(Collectors.toList()));
        dto.setAreaLote(entity.getAreaLote());
        dto.setAreaUtilLote(entity.getAreaUtilLote());
        dto.setAreaPrivativa(entity.getAreaPrivativa());
        dto.setAreaComum(entity.getAreaComum());
        dto.setProfundidades(entity.getProfundidades());
        dto.setTestadas(entity.getTestadas().stream().map(TestadaDTO::from).collect(Collectors.toList()));
        dto.setTestadasGenericas(entity.getTestadasGenericas().stream().map(TestadaGenericaDTO::from).collect(Collectors.toList()));
        dto.setAreasVerde(entity.getAreasVerde());
        dto.setConvenioSaneparMatriculas(entity.getSaneparMatriculas().stream().map(SaneparMatriculaDTO::from).collect(Collectors.toList()));
        dto.setSegmentos(entity.getSegmentos().stream().map(SegmentoDTO::from).collect(Collectors.toList()));
        dto.setAreaTotalConstruida(entity.getAreaTotalConstruida());
        dto.setAreaTotalInscricao(entity.getAreaTotalInscricao());
        dto.setAreaUnidadeConstruida(entity.getAreaUnidadeConstruida());
        BigDecimal areaCadastroLancada = entity.getAreaTotalSegmentos(Boolean.FALSE);
        dto.setAreaTotalNaoLancada(areaCadastroLancada.subtract(entity.getAreaTotalConstruida()));
        dto.getObservacoes().addAll(entity.getObservacoes().stream().map(ObservacaoDTO::from).collect(Collectors.toList()));
        dto.setCepCorrespondencia(entity.getCepCorrespondencia());
        dto.setEnderecoCorrespondencia(entity.getEnderecoCorrespondencia());
        dto.setNumeroCorrespondencia(entity.getNumeroCorrespondencia());
        dto.setComplementoCorrespondencia(entity.getComplementoCorrespondencia());
        dto.setBairroCorrespondencia(entity.getBairroCorrespondencia());
        dto.setCidadeUfCorrespondencia(entity.getCidadeUfCorrespondencia());
        dto.setUfCorrespondencia(entity.getUfCorrespondencia());
        dto.setTipoEnderecoCorrespondencia(entity.getTipoEnderecoCorrespondencia());
        return dto;
    }

    public CadastroImobiliario toEntity() {
        CadastroImobiliario cadastroImobiliario = new CadastroImobiliario();
        cadastroImobiliario.setId(this.getId());
        cadastroImobiliario.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        cadastroImobiliario.setCadastroGeral(this.getCadastroGeral());
        cadastroImobiliario.setCadastroGeralAnterior(this.getCadastroGeralAnterior());
        cadastroImobiliario.setTipoImovel(this.getTipoImovel());
        cadastroImobiliario.setTipoLote(this.getTipoLote());
        cadastroImobiliario.setSituacaoImobiliario(this.getSituacaoImobiliario());
        cadastroImobiliario.setQuadriculaLocalizacao(this.getQuadriculaLocalizacao());
        cadastroImobiliario.setDistritoLocalizacao(this.getDistritoLocalizacao());
        cadastroImobiliario.setSetorLocalizacao(this.getSetorLocalizacao());
        cadastroImobiliario.setQuadraLocalizacao(this.getQuadraLocalizacao());
        cadastroImobiliario.setLoteLocalizacao(this.getLoteLocalizacao());
        cadastroImobiliario.setUnidadeLocalizacao(this.getUnidadeLocalizacao());
        cadastroImobiliario.setInscricaoCadastral(this.getInscricaoCadastral());
        cadastroImobiliario.setInscricaoCadastralAnterior(this.getInscricaoCadastralAnterior());
        cadastroImobiliario.setMatricula(this.getMatricula());
        cadastroImobiliario.setLogradouro(this.getLogradouro().toEntity());
        cadastroImobiliario.setFaceQuadra(this.getFaceQuadra());
        cadastroImobiliario.setDataMatricula(this.getDataMatricula());
        cadastroImobiliario.setCartorio(this.getCartorio());
        cadastroImobiliario.setLivro(this.getLivro());
        cadastroImobiliario.setFolha(this.getFolha());
        cadastroImobiliario.setQuadraFiscalizacao(this.getQuadraFiscalizacao());
        cadastroImobiliario.setLoteFiscalizacao(this.getLoteFiscalizacao());
        cadastroImobiliario.setComplementoLote(this.getComplementoLote());
        cadastroImobiliario.setNumero(this.getNumero());
        Optional.ofNullable(this.getLoteamento()).map(LoteamentoDTO::toEntity).ifPresent(arg_0 -> ((CadastroImobiliario)cadastroImobiliario).setLoteamento(arg_0));
        Optional.ofNullable(this.getBairro()).map(BairroDTO::toEntity).ifPresent(arg_0 -> ((CadastroImobiliario)cadastroImobiliario).setBairro(arg_0));
        cadastroImobiliario.setCep(Long.valueOf(this.getCep()));
        cadastroImobiliario.setComplemento(this.getComplemento());
        Optional.ofNullable(this.getCondominio()).map(CondominioDTO::toEntity).ifPresent(arg_0 -> ((CadastroImobiliario)cadastroImobiliario).setCondominio(arg_0));
        cadastroImobiliario.getProprietarios().addAll(this.proprietarios.stream().map(ProprietarioDTO::toEntity).collect(Collectors.toList()));
        cadastroImobiliario.setAreaLote(this.getAreaLote());
        cadastroImobiliario.setAreaUtilLote(this.getAreaUtilLote());
        cadastroImobiliario.setAreaComum(this.getAreaComum());
        cadastroImobiliario.setAreaPrivativa(this.getAreaPrivativa());
        cadastroImobiliario.getProfundidades().addAll(this.profundidades);
        cadastroImobiliario.getTestadas().addAll(this.testadas.stream().map(TestadaDTO::toEntity).collect(Collectors.toList()));
        cadastroImobiliario.getTestadasGenericas().addAll(this.testadasGenericas.stream().map(TestadaGenericaDTO::toEntity).collect(Collectors.toList()));
        cadastroImobiliario.getAreasVerde().addAll(this.areasVerde);
        cadastroImobiliario.getSaneparMatriculas().addAll(this.convenioSaneparMatriculas.stream().map(saneparMatricula -> saneparMatricula.toEntity((CadastroGeral)cadastroImobiliario)).collect(Collectors.toList()));
        cadastroImobiliario.getSegmentos().addAll(this.segmentos.stream().map(segmento -> segmento.toEntity(cadastroImobiliario.getTipoCadastro(), this.getCadastroGeral())).collect(Collectors.toList()));
        cadastroImobiliario.setAreaTotalConstruida(this.getAreaTotalConstruida());
        cadastroImobiliario.setAreaTotalInscricao(this.getAreaTotalInscricao());
        cadastroImobiliario.setAreaUnidadeConstruida(this.getAreaUnidadeConstruida());
        cadastroImobiliario.getObservacoes().addAll(this.observacoes.stream().map(observacao -> observacao.toEntity((CadastroGeral)cadastroImobiliario)).collect(Collectors.toList()));
        this.getRespostasTerreno().forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> cadastroImobiliario.getRespostaTerrenos().add((RespostaTerreno)resposta.copyTo((Resposta)new RespostaTerreno()))));
        cadastroImobiliario.setTipoEnderecoCorrespondencia(this.getTipoEnderecoCorrespondencia());
        if (TipoEnderecoCorrespondencia.OUTROS.equals((Object)this.getTipoEnderecoCorrespondencia())) {
            cadastroImobiliario.setCepCorrespondencia(this.getCepCorrespondencia());
            cadastroImobiliario.setEnderecoCorrespondencia(this.getEnderecoCorrespondencia());
            cadastroImobiliario.setNumeroCorrespondencia(this.getNumeroCorrespondencia());
            cadastroImobiliario.setComplementoCorrespondencia(this.getComplementoCorrespondencia());
            cadastroImobiliario.setBairroCorrespondencia(this.getBairroCorrespondencia());
            cadastroImobiliario.setCidadeUfCorrespondencia(this.getCidadeUfCorrespondencia());
            cadastroImobiliario.setUfCorrespondencia(this.getUfCorrespondencia());
        }
        return cadastroImobiliario;
    }

    public static CadastroImobiliarioDTO fromComRespostaAgrupada(CadastroImobiliario entity) {
        CadastroImobiliarioDTO dto = CadastroImobiliarioDTO.from((CadastroImobiliario)entity);
        List respostasTerrenoAgrupadas = GrupoRespostasDTO.agruparRespostasPorGrupoCampo((List)entity.getRespostaTerrenos());
        dto.setRespostasTerreno(respostasTerrenoAgrupadas);
        entity.getSegmentos().forEach(segmento -> {
            SegmentoDTO segmentoDTO = dto.getSegmentoById(segmento.getId());
            List respostasSegmentoAgrupadas = GrupoRespostasDTO.agruparRespostasPorGrupoCampo((List)segmento.getRespostasSegmento());
            segmentoDTO.setRespostasSegmento(respostasSegmentoAgrupadas);
        });
        return dto;
    }

    @JsonIgnore
    public SegmentoDTO getSegmentoById(Long idSegmento) {
        return this.segmentos.stream().filter(segmento -> idSegmento.equals(segmento.getId())).findFirst().orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar segmento com id %d no cadastro %d", idSegmento, this.cadastroGeral)));
    }

    @Generated
    public CadastroImobiliarioDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getCadastroGeralAnterior() {
        return this.cadastroGeralAnterior;
    }

    @Generated
    public TipoImovel getTipoImovel() {
        return this.tipoImovel;
    }

    @Generated
    public TipoLote getTipoLote() {
        return this.tipoLote;
    }

    @Generated
    public SituacaoImobiliario getSituacaoImobiliario() {
        return this.situacaoImobiliario;
    }

    @Generated
    public Quadricula getQuadriculaLocalizacao() {
        return this.quadriculaLocalizacao;
    }

    @Generated
    public Distrito getDistritoLocalizacao() {
        return this.distritoLocalizacao;
    }

    @Generated
    public Setor getSetorLocalizacao() {
        return this.setorLocalizacao;
    }

    @Generated
    public SetorQuadra getQuadraLocalizacao() {
        return this.quadraLocalizacao;
    }

    @Generated
    public String getLoteLocalizacao() {
        return this.loteLocalizacao;
    }

    @Generated
    public String getUnidadeLocalizacao() {
        return this.unidadeLocalizacao;
    }

    @Generated
    public String getInscricaoCadastral() {
        return this.inscricaoCadastral;
    }

    @Generated
    public String getInscricaoCadastralAnterior() {
        return this.inscricaoCadastralAnterior;
    }

    @Generated
    public LoteamentoDTO getLoteamento() {
        return this.loteamento;
    }

    @Generated
    public BairroDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public String getCep() {
        return this.cep;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getFaceQuadra() {
        return this.faceQuadra;
    }

    @Generated
    public CondominioDTO getCondominio() {
        return this.condominio;
    }

    @Generated
    public LogradouroDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public Cidade getCidade() {
        return this.cidade;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public Boolean getEnglobado() {
        return this.englobado;
    }

    @Generated
    public Boolean getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public LocalDate getDataMatricula() {
        return this.dataMatricula;
    }

    @Generated
    public String getCartorio() {
        return this.cartorio;
    }

    @Generated
    public String getLivro() {
        return this.livro;
    }

    @Generated
    public String getFolha() {
        return this.folha;
    }

    @Generated
    public String getQuadraFiscalizacao() {
        return this.quadraFiscalizacao;
    }

    @Generated
    public String getLoteFiscalizacao() {
        return this.loteFiscalizacao;
    }

    @Generated
    public String getComplementoLote() {
        return this.complementoLote;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public List<ProprietarioDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public BigDecimal getAreaLote() {
        return this.areaLote;
    }

    @Generated
    public BigDecimal getAreaUtilLote() {
        return this.areaUtilLote;
    }

    @Generated
    public BigDecimal getAreaPrivativa() {
        return this.areaPrivativa;
    }

    @Generated
    public BigDecimal getAreaComum() {
        return this.areaComum;
    }

    @Generated
    public List<CadastroImobiliarioProfundidade> getProfundidades() {
        return this.profundidades;
    }

    @Generated
    public List<TestadaDTO> getTestadas() {
        return this.testadas;
    }

    @Generated
    public List<TestadaGenericaDTO> getTestadasGenericas() {
        return this.testadasGenericas;
    }

    @Generated
    public List<CadastroImobiliarioAreaVerde> getAreasVerde() {
        return this.areasVerde;
    }

    @Generated
    public List<SaneparMatriculaDTO> getConvenioSaneparMatriculas() {
        return this.convenioSaneparMatriculas;
    }

    @Generated
    public List<GrupoRespostasDTO> getRespostasTerreno() {
        return this.respostasTerreno;
    }

    @Generated
    public List<SegmentoDTO> getSegmentos() {
        return this.segmentos;
    }

    @Generated
    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    @Generated
    public BigDecimal getAreaTotalNaoLancada() {
        return this.areaTotalNaoLancada;
    }

    @Generated
    public BigDecimal getAreaTotalInscricao() {
        return this.areaTotalInscricao;
    }

    @Generated
    public BigDecimal getAreaUnidadeConstruida() {
        return this.areaUnidadeConstruida;
    }

    @Generated
    public List<ObservacaoDTO> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public String getCepCorrespondencia() {
        return this.cepCorrespondencia;
    }

    @Generated
    public String getEnderecoCorrespondencia() {
        return this.enderecoCorrespondencia;
    }

    @Generated
    public String getNumeroCorrespondencia() {
        return this.numeroCorrespondencia;
    }

    @Generated
    public String getComplementoCorrespondencia() {
        return this.complementoCorrespondencia;
    }

    @Generated
    public String getBairroCorrespondencia() {
        return this.bairroCorrespondencia;
    }

    @Generated
    public String getCidadeUfCorrespondencia() {
        return this.cidadeUfCorrespondencia;
    }

    @Generated
    public String getUfCorrespondencia() {
        return this.ufCorrespondencia;
    }

    @Generated
    public TipoEnderecoCorrespondencia getTipoEnderecoCorrespondencia() {
        return this.tipoEnderecoCorrespondencia;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCadastroGeralAnterior(Long cadastroGeralAnterior) {
        this.cadastroGeralAnterior = cadastroGeralAnterior;
    }

    @Generated
    public void setTipoImovel(TipoImovel tipoImovel) {
        this.tipoImovel = tipoImovel;
    }

    @Generated
    public void setTipoLote(TipoLote tipoLote) {
        this.tipoLote = tipoLote;
    }

    @JsonIgnoreProperties(value={"tipoSituacaoImobiliario"})
    @Generated
    public void setSituacaoImobiliario(SituacaoImobiliario situacaoImobiliario) {
        this.situacaoImobiliario = situacaoImobiliario;
    }

    @Generated
    public void setQuadriculaLocalizacao(Quadricula quadriculaLocalizacao) {
        this.quadriculaLocalizacao = quadriculaLocalizacao;
    }

    @Generated
    public void setDistritoLocalizacao(Distrito distritoLocalizacao) {
        this.distritoLocalizacao = distritoLocalizacao;
    }

    @JsonIgnoreProperties(value={"quadras"})
    @Generated
    public void setSetorLocalizacao(Setor setorLocalizacao) {
        this.setorLocalizacao = setorLocalizacao;
    }

    @Generated
    public void setQuadraLocalizacao(SetorQuadra quadraLocalizacao) {
        this.quadraLocalizacao = quadraLocalizacao;
    }

    @Generated
    public void setLoteLocalizacao(String loteLocalizacao) {
        this.loteLocalizacao = loteLocalizacao;
    }

    @Generated
    public void setUnidadeLocalizacao(String unidadeLocalizacao) {
        this.unidadeLocalizacao = unidadeLocalizacao;
    }

    @Generated
    public void setInscricaoCadastral(String inscricaoCadastral) {
        this.inscricaoCadastral = inscricaoCadastral;
    }

    @Generated
    public void setInscricaoCadastralAnterior(String inscricaoCadastralAnterior) {
        this.inscricaoCadastralAnterior = inscricaoCadastralAnterior;
    }

    @Generated
    public void setLoteamento(LoteamentoDTO loteamento) {
        this.loteamento = loteamento;
    }

    @Generated
    public void setBairro(BairroDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCep(String cep) {
        this.cep = cep;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setFaceQuadra(String faceQuadra) {
        this.faceQuadra = faceQuadra;
    }

    @Generated
    public void setCondominio(CondominioDTO condominio) {
        this.condominio = condominio;
    }

    @Generated
    public void setLogradouro(LogradouroDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setCidade(Cidade cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setEnglobado(Boolean englobado) {
        this.englobado = englobado;
    }

    @Generated
    public void setExclusaoLogica(Boolean exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setDataMatricula(LocalDate dataMatricula) {
        this.dataMatricula = dataMatricula;
    }

    @Generated
    public void setCartorio(String cartorio) {
        this.cartorio = cartorio;
    }

    @Generated
    public void setLivro(String livro) {
        this.livro = livro;
    }

    @Generated
    public void setFolha(String folha) {
        this.folha = folha;
    }

    @Generated
    public void setQuadraFiscalizacao(String quadraFiscalizacao) {
        this.quadraFiscalizacao = quadraFiscalizacao;
    }

    @Generated
    public void setLoteFiscalizacao(String loteFiscalizacao) {
        this.loteFiscalizacao = loteFiscalizacao;
    }

    @Generated
    public void setComplementoLote(String complementoLote) {
        this.complementoLote = complementoLote;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setProprietarios(List<ProprietarioDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public void setAreaLote(BigDecimal areaLote) {
        this.areaLote = areaLote;
    }

    @Generated
    public void setAreaUtilLote(BigDecimal areaUtilLote) {
        this.areaUtilLote = areaUtilLote;
    }

    @Generated
    public void setAreaPrivativa(BigDecimal areaPrivativa) {
        this.areaPrivativa = areaPrivativa;
    }

    @Generated
    public void setAreaComum(BigDecimal areaComum) {
        this.areaComum = areaComum;
    }

    @Generated
    public void setProfundidades(List<CadastroImobiliarioProfundidade> profundidades) {
        this.profundidades = profundidades;
    }

    @Generated
    public void setTestadas(List<TestadaDTO> testadas) {
        this.testadas = testadas;
    }

    @Generated
    public void setTestadasGenericas(List<TestadaGenericaDTO> testadasGenericas) {
        this.testadasGenericas = testadasGenericas;
    }

    @Generated
    public void setAreasVerde(List<CadastroImobiliarioAreaVerde> areasVerde) {
        this.areasVerde = areasVerde;
    }

    @Generated
    public void setConvenioSaneparMatriculas(List<SaneparMatriculaDTO> convenioSaneparMatriculas) {
        this.convenioSaneparMatriculas = convenioSaneparMatriculas;
    }

    @Generated
    public void setRespostasTerreno(List<GrupoRespostasDTO> respostasTerreno) {
        this.respostasTerreno = respostasTerreno;
    }

    @Generated
    public void setSegmentos(List<SegmentoDTO> segmentos) {
        this.segmentos = segmentos;
    }

    @Generated
    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    @Generated
    public void setAreaTotalNaoLancada(BigDecimal areaTotalNaoLancada) {
        this.areaTotalNaoLancada = areaTotalNaoLancada;
    }

    @Generated
    public void setAreaTotalInscricao(BigDecimal areaTotalInscricao) {
        this.areaTotalInscricao = areaTotalInscricao;
    }

    @Generated
    public void setAreaUnidadeConstruida(BigDecimal areaUnidadeConstruida) {
        this.areaUnidadeConstruida = areaUnidadeConstruida;
    }

    @Generated
    public void setObservacoes(List<ObservacaoDTO> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setCepCorrespondencia(String cepCorrespondencia) {
        this.cepCorrespondencia = cepCorrespondencia;
    }

    @Generated
    public void setEnderecoCorrespondencia(String enderecoCorrespondencia) {
        this.enderecoCorrespondencia = enderecoCorrespondencia;
    }

    @Generated
    public void setNumeroCorrespondencia(String numeroCorrespondencia) {
        this.numeroCorrespondencia = numeroCorrespondencia;
    }

    @Generated
    public void setComplementoCorrespondencia(String complementoCorrespondencia) {
        this.complementoCorrespondencia = complementoCorrespondencia;
    }

    @Generated
    public void setBairroCorrespondencia(String bairroCorrespondencia) {
        this.bairroCorrespondencia = bairroCorrespondencia;
    }

    @Generated
    public void setCidadeUfCorrespondencia(String cidadeUfCorrespondencia) {
        this.cidadeUfCorrespondencia = cidadeUfCorrespondencia;
    }

    @Generated
    public void setUfCorrespondencia(String ufCorrespondencia) {
        this.ufCorrespondencia = ufCorrespondencia;
    }

    @Generated
    public void setTipoEnderecoCorrespondencia(TipoEnderecoCorrespondencia tipoEnderecoCorrespondencia) {
        this.tipoEnderecoCorrespondencia = tipoEnderecoCorrespondencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroImobiliarioDTO)) {
            return false;
        }
        CadastroImobiliarioDTO other = (CadastroImobiliarioDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$cadastroGeralAnterior = this.getCadastroGeralAnterior();
        Long other$cadastroGeralAnterior = other.getCadastroGeralAnterior();
        if (this$cadastroGeralAnterior == null ? other$cadastroGeralAnterior != null : !((Object)this$cadastroGeralAnterior).equals(other$cadastroGeralAnterior)) {
            return false;
        }
        Boolean this$englobado = this.getEnglobado();
        Boolean other$englobado = other.getEnglobado();
        if (this$englobado == null ? other$englobado != null : !((Object)this$englobado).equals(other$englobado)) {
            return false;
        }
        Boolean this$exclusaoLogica = this.getExclusaoLogica();
        Boolean other$exclusaoLogica = other.getExclusaoLogica();
        if (this$exclusaoLogica == null ? other$exclusaoLogica != null : !((Object)this$exclusaoLogica).equals(other$exclusaoLogica)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        TipoImovel this$tipoImovel = this.getTipoImovel();
        TipoImovel other$tipoImovel = other.getTipoImovel();
        if (this$tipoImovel == null ? other$tipoImovel != null : !this$tipoImovel.equals(other$tipoImovel)) {
            return false;
        }
        TipoLote this$tipoLote = this.getTipoLote();
        TipoLote other$tipoLote = other.getTipoLote();
        if (this$tipoLote == null ? other$tipoLote != null : !this$tipoLote.equals(other$tipoLote)) {
            return false;
        }
        SituacaoImobiliario this$situacaoImobiliario = this.getSituacaoImobiliario();
        SituacaoImobiliario other$situacaoImobiliario = other.getSituacaoImobiliario();
        if (this$situacaoImobiliario == null ? other$situacaoImobiliario != null : !this$situacaoImobiliario.equals(other$situacaoImobiliario)) {
            return false;
        }
        Quadricula this$quadriculaLocalizacao = this.getQuadriculaLocalizacao();
        Quadricula other$quadriculaLocalizacao = other.getQuadriculaLocalizacao();
        if (this$quadriculaLocalizacao == null ? other$quadriculaLocalizacao != null : !this$quadriculaLocalizacao.equals(other$quadriculaLocalizacao)) {
            return false;
        }
        Distrito this$distritoLocalizacao = this.getDistritoLocalizacao();
        Distrito other$distritoLocalizacao = other.getDistritoLocalizacao();
        if (this$distritoLocalizacao == null ? other$distritoLocalizacao != null : !this$distritoLocalizacao.equals(other$distritoLocalizacao)) {
            return false;
        }
        Setor this$setorLocalizacao = this.getSetorLocalizacao();
        Setor other$setorLocalizacao = other.getSetorLocalizacao();
        if (this$setorLocalizacao == null ? other$setorLocalizacao != null : !this$setorLocalizacao.equals(other$setorLocalizacao)) {
            return false;
        }
        SetorQuadra this$quadraLocalizacao = this.getQuadraLocalizacao();
        SetorQuadra other$quadraLocalizacao = other.getQuadraLocalizacao();
        if (this$quadraLocalizacao == null ? other$quadraLocalizacao != null : !this$quadraLocalizacao.equals(other$quadraLocalizacao)) {
            return false;
        }
        String this$loteLocalizacao = this.getLoteLocalizacao();
        String other$loteLocalizacao = other.getLoteLocalizacao();
        if (this$loteLocalizacao == null ? other$loteLocalizacao != null : !this$loteLocalizacao.equals(other$loteLocalizacao)) {
            return false;
        }
        String this$unidadeLocalizacao = this.getUnidadeLocalizacao();
        String other$unidadeLocalizacao = other.getUnidadeLocalizacao();
        if (this$unidadeLocalizacao == null ? other$unidadeLocalizacao != null : !this$unidadeLocalizacao.equals(other$unidadeLocalizacao)) {
            return false;
        }
        String this$inscricaoCadastral = this.getInscricaoCadastral();
        String other$inscricaoCadastral = other.getInscricaoCadastral();
        if (this$inscricaoCadastral == null ? other$inscricaoCadastral != null : !this$inscricaoCadastral.equals(other$inscricaoCadastral)) {
            return false;
        }
        String this$inscricaoCadastralAnterior = this.getInscricaoCadastralAnterior();
        String other$inscricaoCadastralAnterior = other.getInscricaoCadastralAnterior();
        if (this$inscricaoCadastralAnterior == null ? other$inscricaoCadastralAnterior != null : !this$inscricaoCadastralAnterior.equals(other$inscricaoCadastralAnterior)) {
            return false;
        }
        LoteamentoDTO this$loteamento = this.getLoteamento();
        LoteamentoDTO other$loteamento = other.getLoteamento();
        if (this$loteamento == null ? other$loteamento != null : !this$loteamento.equals(other$loteamento)) {
            return false;
        }
        BairroDTO this$bairro = this.getBairro();
        BairroDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$cep = this.getCep();
        String other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !this$cep.equals(other$cep)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$faceQuadra = this.getFaceQuadra();
        String other$faceQuadra = other.getFaceQuadra();
        if (this$faceQuadra == null ? other$faceQuadra != null : !this$faceQuadra.equals(other$faceQuadra)) {
            return false;
        }
        CondominioDTO this$condominio = this.getCondominio();
        CondominioDTO other$condominio = other.getCondominio();
        if (this$condominio == null ? other$condominio != null : !this$condominio.equals(other$condominio)) {
            return false;
        }
        LogradouroDTO this$logradouro = this.getLogradouro();
        LogradouroDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        Cidade this$cidade = this.getCidade();
        Cidade other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataMatricula = this.getDataMatricula();
        LocalDate other$dataMatricula = other.getDataMatricula();
        if (this$dataMatricula == null ? other$dataMatricula != null : !((Object)this$dataMatricula).equals(other$dataMatricula)) {
            return false;
        }
        String this$cartorio = this.getCartorio();
        String other$cartorio = other.getCartorio();
        if (this$cartorio == null ? other$cartorio != null : !this$cartorio.equals(other$cartorio)) {
            return false;
        }
        String this$livro = this.getLivro();
        String other$livro = other.getLivro();
        if (this$livro == null ? other$livro != null : !this$livro.equals(other$livro)) {
            return false;
        }
        String this$folha = this.getFolha();
        String other$folha = other.getFolha();
        if (this$folha == null ? other$folha != null : !this$folha.equals(other$folha)) {
            return false;
        }
        String this$quadraFiscalizacao = this.getQuadraFiscalizacao();
        String other$quadraFiscalizacao = other.getQuadraFiscalizacao();
        if (this$quadraFiscalizacao == null ? other$quadraFiscalizacao != null : !this$quadraFiscalizacao.equals(other$quadraFiscalizacao)) {
            return false;
        }
        String this$loteFiscalizacao = this.getLoteFiscalizacao();
        String other$loteFiscalizacao = other.getLoteFiscalizacao();
        if (this$loteFiscalizacao == null ? other$loteFiscalizacao != null : !this$loteFiscalizacao.equals(other$loteFiscalizacao)) {
            return false;
        }
        String this$complementoLote = this.getComplementoLote();
        String other$complementoLote = other.getComplementoLote();
        if (this$complementoLote == null ? other$complementoLote != null : !this$complementoLote.equals(other$complementoLote)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        if (this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios)) {
            return false;
        }
        BigDecimal this$areaLote = this.getAreaLote();
        BigDecimal other$areaLote = other.getAreaLote();
        if (this$areaLote == null ? other$areaLote != null : !((Object)this$areaLote).equals(other$areaLote)) {
            return false;
        }
        BigDecimal this$areaUtilLote = this.getAreaUtilLote();
        BigDecimal other$areaUtilLote = other.getAreaUtilLote();
        if (this$areaUtilLote == null ? other$areaUtilLote != null : !((Object)this$areaUtilLote).equals(other$areaUtilLote)) {
            return false;
        }
        BigDecimal this$areaPrivativa = this.getAreaPrivativa();
        BigDecimal other$areaPrivativa = other.getAreaPrivativa();
        if (this$areaPrivativa == null ? other$areaPrivativa != null : !((Object)this$areaPrivativa).equals(other$areaPrivativa)) {
            return false;
        }
        BigDecimal this$areaComum = this.getAreaComum();
        BigDecimal other$areaComum = other.getAreaComum();
        if (this$areaComum == null ? other$areaComum != null : !((Object)this$areaComum).equals(other$areaComum)) {
            return false;
        }
        List this$profundidades = this.getProfundidades();
        List other$profundidades = other.getProfundidades();
        if (this$profundidades == null ? other$profundidades != null : !((Object)this$profundidades).equals(other$profundidades)) {
            return false;
        }
        List this$testadas = this.getTestadas();
        List other$testadas = other.getTestadas();
        if (this$testadas == null ? other$testadas != null : !((Object)this$testadas).equals(other$testadas)) {
            return false;
        }
        List this$testadasGenericas = this.getTestadasGenericas();
        List other$testadasGenericas = other.getTestadasGenericas();
        if (this$testadasGenericas == null ? other$testadasGenericas != null : !((Object)this$testadasGenericas).equals(other$testadasGenericas)) {
            return false;
        }
        List this$areasVerde = this.getAreasVerde();
        List other$areasVerde = other.getAreasVerde();
        if (this$areasVerde == null ? other$areasVerde != null : !((Object)this$areasVerde).equals(other$areasVerde)) {
            return false;
        }
        List this$convenioSaneparMatriculas = this.getConvenioSaneparMatriculas();
        List other$convenioSaneparMatriculas = other.getConvenioSaneparMatriculas();
        if (this$convenioSaneparMatriculas == null ? other$convenioSaneparMatriculas != null : !((Object)this$convenioSaneparMatriculas).equals(other$convenioSaneparMatriculas)) {
            return false;
        }
        List this$respostasTerreno = this.getRespostasTerreno();
        List other$respostasTerreno = other.getRespostasTerreno();
        if (this$respostasTerreno == null ? other$respostasTerreno != null : !((Object)this$respostasTerreno).equals(other$respostasTerreno)) {
            return false;
        }
        List this$segmentos = this.getSegmentos();
        List other$segmentos = other.getSegmentos();
        if (this$segmentos == null ? other$segmentos != null : !((Object)this$segmentos).equals(other$segmentos)) {
            return false;
        }
        BigDecimal this$areaTotalConstruida = this.getAreaTotalConstruida();
        BigDecimal other$areaTotalConstruida = other.getAreaTotalConstruida();
        if (this$areaTotalConstruida == null ? other$areaTotalConstruida != null : !((Object)this$areaTotalConstruida).equals(other$areaTotalConstruida)) {
            return false;
        }
        BigDecimal this$areaTotalNaoLancada = this.getAreaTotalNaoLancada();
        BigDecimal other$areaTotalNaoLancada = other.getAreaTotalNaoLancada();
        if (this$areaTotalNaoLancada == null ? other$areaTotalNaoLancada != null : !((Object)this$areaTotalNaoLancada).equals(other$areaTotalNaoLancada)) {
            return false;
        }
        BigDecimal this$areaTotalInscricao = this.getAreaTotalInscricao();
        BigDecimal other$areaTotalInscricao = other.getAreaTotalInscricao();
        if (this$areaTotalInscricao == null ? other$areaTotalInscricao != null : !((Object)this$areaTotalInscricao).equals(other$areaTotalInscricao)) {
            return false;
        }
        BigDecimal this$areaUnidadeConstruida = this.getAreaUnidadeConstruida();
        BigDecimal other$areaUnidadeConstruida = other.getAreaUnidadeConstruida();
        if (this$areaUnidadeConstruida == null ? other$areaUnidadeConstruida != null : !((Object)this$areaUnidadeConstruida).equals(other$areaUnidadeConstruida)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        if (this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes)) {
            return false;
        }
        String this$cepCorrespondencia = this.getCepCorrespondencia();
        String other$cepCorrespondencia = other.getCepCorrespondencia();
        if (this$cepCorrespondencia == null ? other$cepCorrespondencia != null : !this$cepCorrespondencia.equals(other$cepCorrespondencia)) {
            return false;
        }
        String this$enderecoCorrespondencia = this.getEnderecoCorrespondencia();
        String other$enderecoCorrespondencia = other.getEnderecoCorrespondencia();
        if (this$enderecoCorrespondencia == null ? other$enderecoCorrespondencia != null : !this$enderecoCorrespondencia.equals(other$enderecoCorrespondencia)) {
            return false;
        }
        String this$numeroCorrespondencia = this.getNumeroCorrespondencia();
        String other$numeroCorrespondencia = other.getNumeroCorrespondencia();
        if (this$numeroCorrespondencia == null ? other$numeroCorrespondencia != null : !this$numeroCorrespondencia.equals(other$numeroCorrespondencia)) {
            return false;
        }
        String this$complementoCorrespondencia = this.getComplementoCorrespondencia();
        String other$complementoCorrespondencia = other.getComplementoCorrespondencia();
        if (this$complementoCorrespondencia == null ? other$complementoCorrespondencia != null : !this$complementoCorrespondencia.equals(other$complementoCorrespondencia)) {
            return false;
        }
        String this$bairroCorrespondencia = this.getBairroCorrespondencia();
        String other$bairroCorrespondencia = other.getBairroCorrespondencia();
        if (this$bairroCorrespondencia == null ? other$bairroCorrespondencia != null : !this$bairroCorrespondencia.equals(other$bairroCorrespondencia)) {
            return false;
        }
        String this$cidadeUfCorrespondencia = this.getCidadeUfCorrespondencia();
        String other$cidadeUfCorrespondencia = other.getCidadeUfCorrespondencia();
        if (this$cidadeUfCorrespondencia == null ? other$cidadeUfCorrespondencia != null : !this$cidadeUfCorrespondencia.equals(other$cidadeUfCorrespondencia)) {
            return false;
        }
        String this$ufCorrespondencia = this.getUfCorrespondencia();
        String other$ufCorrespondencia = other.getUfCorrespondencia();
        if (this$ufCorrespondencia == null ? other$ufCorrespondencia != null : !this$ufCorrespondencia.equals(other$ufCorrespondencia)) {
            return false;
        }
        TipoEnderecoCorrespondencia this$tipoEnderecoCorrespondencia = this.getTipoEnderecoCorrespondencia();
        TipoEnderecoCorrespondencia other$tipoEnderecoCorrespondencia = other.getTipoEnderecoCorrespondencia();
        return !(this$tipoEnderecoCorrespondencia == null ? other$tipoEnderecoCorrespondencia != null : !this$tipoEnderecoCorrespondencia.equals(other$tipoEnderecoCorrespondencia));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroImobiliarioDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $cadastroGeralAnterior = this.getCadastroGeralAnterior();
        result = result * 59 + ($cadastroGeralAnterior == null ? 43 : ((Object)$cadastroGeralAnterior).hashCode());
        Boolean $englobado = this.getEnglobado();
        result = result * 59 + ($englobado == null ? 43 : ((Object)$englobado).hashCode());
        Boolean $exclusaoLogica = this.getExclusaoLogica();
        result = result * 59 + ($exclusaoLogica == null ? 43 : ((Object)$exclusaoLogica).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        TipoImovel $tipoImovel = this.getTipoImovel();
        result = result * 59 + ($tipoImovel == null ? 43 : $tipoImovel.hashCode());
        TipoLote $tipoLote = this.getTipoLote();
        result = result * 59 + ($tipoLote == null ? 43 : $tipoLote.hashCode());
        SituacaoImobiliario $situacaoImobiliario = this.getSituacaoImobiliario();
        result = result * 59 + ($situacaoImobiliario == null ? 43 : $situacaoImobiliario.hashCode());
        Quadricula $quadriculaLocalizacao = this.getQuadriculaLocalizacao();
        result = result * 59 + ($quadriculaLocalizacao == null ? 43 : $quadriculaLocalizacao.hashCode());
        Distrito $distritoLocalizacao = this.getDistritoLocalizacao();
        result = result * 59 + ($distritoLocalizacao == null ? 43 : $distritoLocalizacao.hashCode());
        Setor $setorLocalizacao = this.getSetorLocalizacao();
        result = result * 59 + ($setorLocalizacao == null ? 43 : $setorLocalizacao.hashCode());
        SetorQuadra $quadraLocalizacao = this.getQuadraLocalizacao();
        result = result * 59 + ($quadraLocalizacao == null ? 43 : $quadraLocalizacao.hashCode());
        String $loteLocalizacao = this.getLoteLocalizacao();
        result = result * 59 + ($loteLocalizacao == null ? 43 : $loteLocalizacao.hashCode());
        String $unidadeLocalizacao = this.getUnidadeLocalizacao();
        result = result * 59 + ($unidadeLocalizacao == null ? 43 : $unidadeLocalizacao.hashCode());
        String $inscricaoCadastral = this.getInscricaoCadastral();
        result = result * 59 + ($inscricaoCadastral == null ? 43 : $inscricaoCadastral.hashCode());
        String $inscricaoCadastralAnterior = this.getInscricaoCadastralAnterior();
        result = result * 59 + ($inscricaoCadastralAnterior == null ? 43 : $inscricaoCadastralAnterior.hashCode());
        LoteamentoDTO $loteamento = this.getLoteamento();
        result = result * 59 + ($loteamento == null ? 43 : $loteamento.hashCode());
        BairroDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : $cep.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $faceQuadra = this.getFaceQuadra();
        result = result * 59 + ($faceQuadra == null ? 43 : $faceQuadra.hashCode());
        CondominioDTO $condominio = this.getCondominio();
        result = result * 59 + ($condominio == null ? 43 : $condominio.hashCode());
        LogradouroDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        Cidade $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataMatricula = this.getDataMatricula();
        result = result * 59 + ($dataMatricula == null ? 43 : ((Object)$dataMatricula).hashCode());
        String $cartorio = this.getCartorio();
        result = result * 59 + ($cartorio == null ? 43 : $cartorio.hashCode());
        String $livro = this.getLivro();
        result = result * 59 + ($livro == null ? 43 : $livro.hashCode());
        String $folha = this.getFolha();
        result = result * 59 + ($folha == null ? 43 : $folha.hashCode());
        String $quadraFiscalizacao = this.getQuadraFiscalizacao();
        result = result * 59 + ($quadraFiscalizacao == null ? 43 : $quadraFiscalizacao.hashCode());
        String $loteFiscalizacao = this.getLoteFiscalizacao();
        result = result * 59 + ($loteFiscalizacao == null ? 43 : $loteFiscalizacao.hashCode());
        String $complementoLote = this.getComplementoLote();
        result = result * 59 + ($complementoLote == null ? 43 : $complementoLote.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        BigDecimal $areaLote = this.getAreaLote();
        result = result * 59 + ($areaLote == null ? 43 : ((Object)$areaLote).hashCode());
        BigDecimal $areaUtilLote = this.getAreaUtilLote();
        result = result * 59 + ($areaUtilLote == null ? 43 : ((Object)$areaUtilLote).hashCode());
        BigDecimal $areaPrivativa = this.getAreaPrivativa();
        result = result * 59 + ($areaPrivativa == null ? 43 : ((Object)$areaPrivativa).hashCode());
        BigDecimal $areaComum = this.getAreaComum();
        result = result * 59 + ($areaComum == null ? 43 : ((Object)$areaComum).hashCode());
        List $profundidades = this.getProfundidades();
        result = result * 59 + ($profundidades == null ? 43 : ((Object)$profundidades).hashCode());
        List $testadas = this.getTestadas();
        result = result * 59 + ($testadas == null ? 43 : ((Object)$testadas).hashCode());
        List $testadasGenericas = this.getTestadasGenericas();
        result = result * 59 + ($testadasGenericas == null ? 43 : ((Object)$testadasGenericas).hashCode());
        List $areasVerde = this.getAreasVerde();
        result = result * 59 + ($areasVerde == null ? 43 : ((Object)$areasVerde).hashCode());
        List $convenioSaneparMatriculas = this.getConvenioSaneparMatriculas();
        result = result * 59 + ($convenioSaneparMatriculas == null ? 43 : ((Object)$convenioSaneparMatriculas).hashCode());
        List $respostasTerreno = this.getRespostasTerreno();
        result = result * 59 + ($respostasTerreno == null ? 43 : ((Object)$respostasTerreno).hashCode());
        List $segmentos = this.getSegmentos();
        result = result * 59 + ($segmentos == null ? 43 : ((Object)$segmentos).hashCode());
        BigDecimal $areaTotalConstruida = this.getAreaTotalConstruida();
        result = result * 59 + ($areaTotalConstruida == null ? 43 : ((Object)$areaTotalConstruida).hashCode());
        BigDecimal $areaTotalNaoLancada = this.getAreaTotalNaoLancada();
        result = result * 59 + ($areaTotalNaoLancada == null ? 43 : ((Object)$areaTotalNaoLancada).hashCode());
        BigDecimal $areaTotalInscricao = this.getAreaTotalInscricao();
        result = result * 59 + ($areaTotalInscricao == null ? 43 : ((Object)$areaTotalInscricao).hashCode());
        BigDecimal $areaUnidadeConstruida = this.getAreaUnidadeConstruida();
        result = result * 59 + ($areaUnidadeConstruida == null ? 43 : ((Object)$areaUnidadeConstruida).hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        String $cepCorrespondencia = this.getCepCorrespondencia();
        result = result * 59 + ($cepCorrespondencia == null ? 43 : $cepCorrespondencia.hashCode());
        String $enderecoCorrespondencia = this.getEnderecoCorrespondencia();
        result = result * 59 + ($enderecoCorrespondencia == null ? 43 : $enderecoCorrespondencia.hashCode());
        String $numeroCorrespondencia = this.getNumeroCorrespondencia();
        result = result * 59 + ($numeroCorrespondencia == null ? 43 : $numeroCorrespondencia.hashCode());
        String $complementoCorrespondencia = this.getComplementoCorrespondencia();
        result = result * 59 + ($complementoCorrespondencia == null ? 43 : $complementoCorrespondencia.hashCode());
        String $bairroCorrespondencia = this.getBairroCorrespondencia();
        result = result * 59 + ($bairroCorrespondencia == null ? 43 : $bairroCorrespondencia.hashCode());
        String $cidadeUfCorrespondencia = this.getCidadeUfCorrespondencia();
        result = result * 59 + ($cidadeUfCorrespondencia == null ? 43 : $cidadeUfCorrespondencia.hashCode());
        String $ufCorrespondencia = this.getUfCorrespondencia();
        result = result * 59 + ($ufCorrespondencia == null ? 43 : $ufCorrespondencia.hashCode());
        TipoEnderecoCorrespondencia $tipoEnderecoCorrespondencia = this.getTipoEnderecoCorrespondencia();
        result = result * 59 + ($tipoEnderecoCorrespondencia == null ? 43 : $tipoEnderecoCorrespondencia.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroImobiliarioDTO(id=" + this.getId() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", cadastroGeralAnterior=" + this.getCadastroGeralAnterior() + ", tipoImovel=" + this.getTipoImovel() + ", tipoLote=" + this.getTipoLote() + ", situacaoImobiliario=" + this.getSituacaoImobiliario() + ", quadriculaLocalizacao=" + this.getQuadriculaLocalizacao() + ", distritoLocalizacao=" + this.getDistritoLocalizacao() + ", setorLocalizacao=" + this.getSetorLocalizacao() + ", quadraLocalizacao=" + this.getQuadraLocalizacao() + ", loteLocalizacao=" + this.getLoteLocalizacao() + ", unidadeLocalizacao=" + this.getUnidadeLocalizacao() + ", inscricaoCadastral=" + this.getInscricaoCadastral() + ", inscricaoCadastralAnterior=" + this.getInscricaoCadastralAnterior() + ", loteamento=" + this.getLoteamento() + ", bairro=" + this.getBairro() + ", cep=" + this.getCep() + ", complemento=" + this.getComplemento() + ", faceQuadra=" + this.getFaceQuadra() + ", condominio=" + this.getCondominio() + ", logradouro=" + this.getLogradouro() + ", cidade=" + this.getCidade() + ", matricula=" + this.getMatricula() + ", usuario=" + this.getUsuario() + ", dataAlteracao=" + this.getDataAlteracao() + ", dataInclusao=" + this.getDataInclusao() + ", englobado=" + this.getEnglobado() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", dataMatricula=" + this.getDataMatricula() + ", cartorio=" + this.getCartorio() + ", livro=" + this.getLivro() + ", folha=" + this.getFolha() + ", quadraFiscalizacao=" + this.getQuadraFiscalizacao() + ", loteFiscalizacao=" + this.getLoteFiscalizacao() + ", complementoLote=" + this.getComplementoLote() + ", numero=" + this.getNumero() + ", proprietarios=" + this.getProprietarios() + ", areaLote=" + this.getAreaLote() + ", areaUtilLote=" + this.getAreaUtilLote() + ", areaPrivativa=" + this.getAreaPrivativa() + ", areaComum=" + this.getAreaComum() + ", profundidades=" + this.getProfundidades() + ", testadas=" + this.getTestadas() + ", testadasGenericas=" + this.getTestadasGenericas() + ", areasVerde=" + this.getAreasVerde() + ", convenioSaneparMatriculas=" + this.getConvenioSaneparMatriculas() + ", respostasTerreno=" + this.getRespostasTerreno() + ", segmentos=" + this.getSegmentos() + ", areaTotalConstruida=" + this.getAreaTotalConstruida() + ", areaTotalNaoLancada=" + this.getAreaTotalNaoLancada() + ", areaTotalInscricao=" + this.getAreaTotalInscricao() + ", areaUnidadeConstruida=" + this.getAreaUnidadeConstruida() + ", observacoes=" + this.getObservacoes() + ", cepCorrespondencia=" + this.getCepCorrespondencia() + ", enderecoCorrespondencia=" + this.getEnderecoCorrespondencia() + ", numeroCorrespondencia=" + this.getNumeroCorrespondencia() + ", complementoCorrespondencia=" + this.getComplementoCorrespondencia() + ", bairroCorrespondencia=" + this.getBairroCorrespondencia() + ", cidadeUfCorrespondencia=" + this.getCidadeUfCorrespondencia() + ", ufCorrespondencia=" + this.getUfCorrespondencia() + ", tipoEnderecoCorrespondencia=" + this.getTipoEnderecoCorrespondencia() + ")";
    }
}

