/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.sanepar;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBCADASTROVINCULOSANEPAR")
@Audited
@AuditTable(value="TRIBCADASTROVINCULOSANEPAR_AUD")
public class SaneparMatricula
implements EloEntity<Long> {
    @Id
    @EloSequence(applyOnMerge=true, sequenceName="s05CadastroVinculoSanepar")
    private Long id;
    @NotNull
    @Caption(value="Matr\u00edcula")
    private String matricula;
    @ManyToOne(fetch=FetchType.LAZY)
    @Caption(value="Cadastro geral")
    @JsonIgnore
    @MetaModelIgnore
    @JoinColumns(value={@JoinColumn(name="tipoCadastro", referencedColumnName="tipoCadastro"), @JoinColumn(name="cadastroGeral", referencedColumnName="cadastroGeral")})
    private CadastroGeral cadastroGeral;
    @Convert(converter=BooleanToStringConverter.class)
    @Caption(value="Principal")
    private Boolean principal = Boolean.FALSE;

    public void merge(SaneparMatricula novaSaneparMatricula) {
        this.matricula = novaSaneparMatricula.getMatricula();
        this.cadastroGeral = novaSaneparMatricula.getCadastroGeral();
        this.principal = novaSaneparMatricula.getPrincipal();
    }

    public SaneparMatricula copy() {
        SaneparMatricula saneparMatricula = new SaneparMatricula();
        BeanUtils.copyProperties((Object)this, (Object)saneparMatricula, (String[])new String[]{"id"});
        return saneparMatricula;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @JsonIgnore
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public String toString() {
        return "SaneparMatricula(id=" + this.getId() + ", matricula=" + this.getMatricula() + ", cadastroGeral=" + this.getCadastroGeral() + ", principal=" + this.getPrincipal() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaneparMatricula)) {
            return false;
        }
        SaneparMatricula other = (SaneparMatricula)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SaneparMatricula;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public SaneparMatricula() {
    }
}

