/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.calculo;

import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.InconsistenciaCalculoDTO;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoScriptBase;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface CalculoConfigBase {
    public Long getId();

    public Long getEntidade();

    public Long getExercicio();

    public TipoCalculoConfig getTipo();

    public String getIdentificadorResultado();

    public String getIdentificadorBaseCalculo();

    public String getIdentificadorCondicao();

    public String getIdentificadorAliquota();

    public TipoDivida getTipoDivida();

    public TipoCadastro getTipoCadastro();

    public String getIdentificadorLog();

    public List<? extends CalculoScriptBase> getScript();

    public CalculoBuildDTO getCalculoBuildDTO();

    public void setCalculoBuildDTO(CalculoBuildDTO var1);

    public void setIdentificadorResultado(String var1);

    public void setIdentificadorBaseCalculo(String var1);

    default public Optional<String> getIdentificadorDuplicado() {
        List identificadores = this.getScript().stream().map(CalculoScriptBase::getIdentificador).collect(Collectors.toList());
        return identificadores.stream().filter(identificador -> Collections.frequency(identificadores, identificador) > 1).findFirst();
    }

    public InconsistenciaCalculoDTO buildInconsistencia(String var1);

    public void setIdentificadoresResultado(CalculoResultadoDTO var1);
}

