/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.calculo;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.domain.calculo.CalculoScriptBase;
import br.com.elotech.tributos.domain.calculo.TipoCalculoScript;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table
public class CalculoAvaliacaoScript
implements EloEntity<Long>,
Serializable,
CalculoScriptBase {
    @Id
    @EloSequence(sequenceName="SEQ_CALCULOAVALIACAOSCRIPT", applyOnMerge=true)
    private Long id;
    @ManyToOne
    @JoinColumn(name="IDCALCULOAVALIACAO")
    @JsonIgnore
    @MetaModelIgnore
    private CalculoAvaliacao calculoAvaliacao;
    private Long ordem;
    private String identificador;
    private Boolean obrigatorio = Boolean.FALSE;
    @Enumerated(value=EnumType.STRING)
    private TipoCalculoScript tipo;
    private String expressao;
    private String expressaoVerdadeira;
    private String expressaoFalsa;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idcampodinamico", referencedColumnName="id")
    @JsonIgnoreProperties(value={"validacoes", "alternativas"})
    private Campo campoDinamico;

    public static CalculoAvaliacaoScript expressaoCondicional(String identificador, String condicao, String expressaoVerdadeira, String expressaoFalsa, Boolean obrigatoria) {
        CalculoAvaliacaoScript linha = new CalculoAvaliacaoScript();
        linha.tipo = TipoCalculoScript.CONDICIONAL;
        linha.identificador = identificador;
        linha.expressao = condicao;
        linha.expressaoVerdadeira = expressaoVerdadeira;
        linha.expressaoFalsa = expressaoFalsa;
        linha.obrigatorio = obrigatoria;
        return linha;
    }

    public static CalculoAvaliacaoScript expressaoCondicional(String identificador, String condicao, String expressaoVerdadeira, String expressaoFalsa) {
        return CalculoAvaliacaoScript.expressaoCondicional((String)identificador, (String)condicao, (String)expressaoVerdadeira, (String)expressaoFalsa, (Boolean)Boolean.FALSE);
    }

    public static CalculoAvaliacaoScript expressao(String identificador, String expressao, Boolean obrigatoria) {
        CalculoAvaliacaoScript linha = new CalculoAvaliacaoScript();
        linha.tipo = TipoCalculoScript.NORMAL;
        linha.identificador = identificador;
        linha.expressao = expressao;
        linha.obrigatorio = obrigatoria;
        return linha;
    }

    public static CalculoAvaliacaoScript expressao(String identificador, String expressao) {
        return CalculoAvaliacaoScript.expressao((String)identificador, (String)expressao, (Boolean)Boolean.FALSE);
    }

    @Generated
    public CalculoAvaliacaoScript() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CalculoAvaliacao getCalculoAvaliacao() {
        return this.calculoAvaliacao;
    }

    @Generated
    public Long getOrdem() {
        return this.ordem;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Boolean getObrigatorio() {
        return this.obrigatorio;
    }

    @Generated
    public TipoCalculoScript getTipo() {
        return this.tipo;
    }

    @Generated
    public String getExpressao() {
        return this.expressao;
    }

    @Generated
    public String getExpressaoVerdadeira() {
        return this.expressaoVerdadeira;
    }

    @Generated
    public String getExpressaoFalsa() {
        return this.expressaoFalsa;
    }

    @Generated
    public Campo getCampoDinamico() {
        return this.campoDinamico;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setCalculoAvaliacao(CalculoAvaliacao calculoAvaliacao) {
        this.calculoAvaliacao = calculoAvaliacao;
    }

    @Generated
    public void setOrdem(Long ordem) {
        this.ordem = ordem;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setObrigatorio(Boolean obrigatorio) {
        this.obrigatorio = obrigatorio;
    }

    @Generated
    public void setTipo(TipoCalculoScript tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    @Generated
    public void setExpressaoVerdadeira(String expressaoVerdadeira) {
        this.expressaoVerdadeira = expressaoVerdadeira;
    }

    @Generated
    public void setExpressaoFalsa(String expressaoFalsa) {
        this.expressaoFalsa = expressaoFalsa;
    }

    @JsonIgnoreProperties(value={"validacoes", "alternativas"})
    @Generated
    public void setCampoDinamico(Campo campoDinamico) {
        this.campoDinamico = campoDinamico;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoAvaliacaoScript)) {
            return false;
        }
        CalculoAvaliacaoScript other = (CalculoAvaliacaoScript)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoAvaliacaoScript;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoAvaliacaoScript(id=" + this.getId() + ", ordem=" + this.getOrdem() + ", identificador=" + this.getIdentificador() + ", expressao=" + this.getExpressao() + ", expressaoVerdadeira=" + this.getExpressaoVerdadeira() + ", expressaoFalsa=" + this.getExpressaoFalsa() + ")";
    }
}

