/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.config.swagger;

import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.adapters.KeycloakDeployment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Profiles;
import springfox.documentation.service.ClientCredentialsGrant;
import springfox.documentation.service.GrantType;
import springfox.documentation.service.OAuth;
import springfox.documentation.service.ResourceOwnerPasswordCredentialsGrant;

public class OAuthScheme
extends OAuth {
    private final KeycloakResolver keycloakResolver;
    private final ConfigurableEnvironment environment;

    public OAuthScheme(String name, KeycloakResolver resolver, ConfigurableEnvironment environment) {
        super(name, new ArrayList(), new ArrayList());
        this.keycloakResolver = resolver;
        this.environment = environment;
    }

    public List<GrantType> getGrantTypes() {
        ResourceOwnerPasswordCredentialsGrant grantType;
        if (this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"onpremise"}))) {
            KeycloakDeployment keycloakDeployment = this.keycloakResolver.getKeycloakDeploymentById("OxyElotech");
            String tokenUrl = String.format("%s/realms/%s/protocol/openid-connect/token", "", keycloakDeployment.getRealm());
            grantType = new ResourceOwnerPasswordCredentialsGrant(tokenUrl);
        } else {
            KeycloakDeployment keycloakDeployment = this.keycloakResolver.getKeycloakDeployment();
            String tokenUrl = String.format("%s/realms/%s/protocol/openid-connect/token", keycloakDeployment.getAuthServerBaseUrl(), keycloakDeployment.getRealm());
            grantType = new ClientCredentialsGrant(tokenUrl);
        }
        return List.of(grantType);
    }
}

