/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.sanepar.processamento;

import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ProcessamentoSaneparReader
extends JpaPagingItemReader<BaixaSaneparItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoSaneparReader.class);

    public ProcessamentoSaneparReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory) {
        Long idBaixa = (Long)jobParameters.get("idBaixa");
        this.setPageSize(500);
        this.setName("verificacaoSaneparId");
        this.setEntityManagerFactory(entityManagerFactory);
        this.setQueryString(this.getItensSql());
        this.setParameterValues(Collections.singletonMap("idBaixa", idBaixa));
    }

    private String getItensSql() {
        return " SELECT i  FROM BaixaSaneparItem i  WHERE i.baixa.id = :idBaixa   AND i.situacao IN ( br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar.VALIDADO,                      br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar.DEBITO_GERADO,                      br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar.ERRO_GERACAO_DEBITO,                      br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar.BOLETO_GERADO,                      br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar.ERRO_GERACAO_BOLETO,                      br.com.elotech.tributos.enums.sanepar.SituacaoItemSanepar.ERRO_GERACAO_PAGAMENTO ) ORDER BY i.linha ";
    }
}

