/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.simulacaocalculo;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ComunicadoCadastroId;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.ComunicadoSimulacaoCalculoDTO;
import br.com.elotech.tributos.dto.SituacaoComunicadoCadastro;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoSimulacaoCalculoBatchProcessor
implements ItemProcessor<ComunicadoSimulacaoCalculoDTO, ComunicadoCadastro> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComunicadoSimulacaoCalculoBatchProcessor.class);
    private static final String LOG_PARAM = "COMUNICADO - A partir da Simula\u00e7\u00e3o de C\u00e1lculo  - ";
    protected StepExecution stepExecution;
    private AtomicLong sequencia;
    private final ComunicadoCadastroService comunicadoCadastroService;
    private final EntityManager em;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        this.sequencia = this.comunicadoCadastroService.findNextSequencia(entidade, exercicioComunicado, idComunicadoParam);
        log.info("COMUNICADO - A partir da Simula\u00e7\u00e3o de C\u00e1lculo  - Iniciando gera\u00e7\u00e3o de dados");
    }

    public ComunicadoCadastro process(ComunicadoSimulacaoCalculoDTO item) throws Exception {
        Long entidade = this.stepExecution.getJobExecution().getJobParameters().getLong("entidade");
        Long exercicioComunicado = this.stepExecution.getJobExecution().getJobParameters().getLong("exercicioComunicado");
        Long idComunicadoParam = this.stepExecution.getJobExecution().getJobParameters().getLong("idComunicado");
        ComunicadoId idComunicado = new ComunicadoId();
        idComunicado.setIdComunicado(idComunicadoParam);
        idComunicado.setEntidade(entidade);
        idComunicado.setExercicio(exercicioComunicado);
        Comunicado comunicado = new Comunicado();
        comunicado.setId(idComunicado);
        ComunicadoCadastroId idComunicadoCadastro = new ComunicadoCadastroId();
        idComunicadoCadastro.setComunicado(comunicado);
        idComunicadoCadastro.setSequencia(Long.valueOf(this.sequencia.getAndIncrement()));
        ComunicadoCadastro comunicadoCadastro = new ComunicadoCadastro();
        comunicadoCadastro.setId(idComunicadoCadastro);
        comunicadoCadastro.setSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO);
        comunicadoCadastro.setDescricaoSituacao(SituacaoComunicadoCadastro.SITUACAO_DEBITO.getDescricao());
        Pessoa pessoa = new Pessoa();
        pessoa.setId(item.getPessoa().getId());
        comunicadoCadastro.setPessoa(pessoa);
        CadastroGeral cadastroGeral = new CadastroGeral();
        cadastroGeral.setId(item.getIdCadastroGeral());
        cadastroGeral.setTipoCadastro(item.getTipoCadastro());
        cadastroGeral.setCadastroGeral(item.getCadastroGeral());
        comunicadoCadastro.setCadastroGeral(cadastroGeral);
        this.em.flush();
        return comunicadoCadastro;
    }

    @Generated
    public ComunicadoSimulacaoCalculoBatchProcessor(ComunicadoCadastroService comunicadoCadastroService, EntityManager em) {
        this.comunicadoCadastroService = comunicadoCadastroService;
        this.em = em;
    }
}

