/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.protesto;

import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.repository.ProtestoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.GeracaoProtestoErroService;
import br.com.elotech.tributos.service.ProtestoItemService;
import br.com.elotech.tributos.service.ProtestoService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class GeracaoProtestoLoteCdaBatchWriter
implements ItemWriter<Protesto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeracaoProtestoLoteCdaBatchWriter.class);
    private final ProtestoRepository protestoRepository;
    private StepExecution stepExecution;
    private final ProtestoService protestoService;
    private final ContextService contextService;
    private final DebitoParcelaService debitoParcelaService;
    private final GeracaoProtestoErroService geracaoProtestoErroService;
    private final ProtestoItemService protestoItemService;
    private JobExecution jobExecution;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.jobExecution = this.stepExecution.getJobExecution();
    }

    @AfterWrite
    public void afterWrite(List<? extends Protesto> protestos) {
        LOGGER.info("Protestos - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + protestos.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends Protesto> items) {
        if (CollectionUtils.isNotEmpty(items)) {
            Long exercicio = Optional.ofNullable(((Protesto)items.stream().findFirst().get()).getExercicio()).orElse(this.contextService.getExercicioAtual());
            JobParameters jobParameters = Objects.requireNonNull(this.jobExecution.getJobParameters());
            Long idLote = jobParameters.getLong("idLote");
            AtomicLong numeroProtesto = new AtomicLong(this.protestoService.findNextProtesto(exercicio));
            AtomicLong sequenciaItem = new AtomicLong(this.protestoItemService.findNextSequencia(Long.valueOf(numeroProtesto.get()), exercicio));
            items.forEach(item -> {
                item.setProtesto(Long.valueOf(numeroProtesto.getAndIncrement()));
                item.getProtestoItems().forEach(protestoItem -> protestoItem.getId().setSequencia(Long.valueOf(sequenciaItem.getAndIncrement())));
            });
            List protestosSalvos = this.protestoRepository.saveAll(items);
            protestosSalvos.forEach(protesto -> {
                this.debitoParcelaService.updateParcelaProtesto(protesto.getDocumento(), protesto.getId(), this.jobExecution);
                this.geracaoProtestoErroService.updateSituacaoErro(idLote, protesto);
            });
        }
    }

    @Generated
    public GeracaoProtestoLoteCdaBatchWriter(ProtestoRepository protestoRepository, ProtestoService protestoService, ContextService contextService, DebitoParcelaService debitoParcelaService, GeracaoProtestoErroService geracaoProtestoErroService, ProtestoItemService protestoItemService) {
        this.protestoRepository = protestoRepository;
        this.protestoService = protestoService;
        this.contextService = contextService;
        this.debitoParcelaService = debitoParcelaService;
        this.geracaoProtestoErroService = geracaoProtestoErroService;
        this.protestoItemService = protestoItemService;
    }
}

