with contagemdeducaocredito as (select nrdeducao, nranodeducao, count(1) as nrRegistroDeducao from tcededucaocredito group by nrdeducao, nranodeducao),
    contagemnrcredito as (select nranodeducao, nrcredito, nranocredito, idtipodeducaocredito, cdcontroleleiato, dtdeducao, count(1) as nrRegistroCredito from tcededucaocredito group by nranodeducao, nrcredito, nranocredito, idtipodeducaocredito, cdcontroleleiato, dtdeducao)
select tdc.idtcededucaocredito as id,
    tdc.nrdeducao,
    tdc.nranodeducao,
    tdc.nrcredito,
    tdc.nranocredito,
	tdc.vldeducao,
    tdc.dtdeducao,
    tdc.dsmotivo,
    coalesce(lag(tdc.nrdeducao, 1) over (order by tdc.idtcededucaocredito), 0) as nrDeducaoAnterior,
    tlc.nrcredito as nrCreditoLancCredito,
    tlc.nranocredito as nrAnoCreditoLancCredito,
    tlc.dtlancamento as dtLancamentoCredito,
    ttd.tipodeducao as tipoDeducaoTribTipoDeducao,
    cg.idato as cdControleLeiAtoCgAto,
	t.codigo as escopolei,
    cdc.nrRegistroDeducao,
    cnrc.nrRegistroCredito
from tcededucaocredito tdc
    join contagemdeducaocredito cdc on tdc.nrdeducao = cdc.nrdeducao and tdc.nranodeducao = cdc.nranodeducao
    join contagemnrcredito cnrc on tdc.nranodeducao = cnrc.nranodeducao and tdc.nrcredito = cnrc.nrcredito and tdc.nranocredito = cnrc.nranocredito and tdc.idtipodeducaocredito = cnrc.idtipodeducaocredito and tdc.cdcontroleleiato = cnrc.cdcontroleleiato and tdc.dtdeducao = cnrc.dtdeducao
    left join tcelanccredito tlc on tdc.nrcredito = tlc.nrcredito and tdc.nranocredito = tlc.nranocredito
    left join tribtipodeducao ttd on tdc.idtipodeducaocredito = ttd.tipodeducao
    left join cgato cg on cg.entidade = :entidade and cg.idato = tdc.cdcontroleleiato
    left join tipoescopolei t on cg.idtipoescopolei = t.id
where tdc.dtdeducao between :dataInicial and :dataFinal