select 12                                                 as codigoArquivo,
       'Estorno de Deduções dos Créditos em Dívida Ativa' as arquivo,
       'CREDITO'                                          as tipoArquivo,
       coalesce(arquivo.valor, 0)                         as valorArquivo,
       coalesce(integracao.valor, 0)                      as valorIntegracao,
       0                                                  as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tcededucaocreditodaest tdcdae
        join triberrosimportacaosimam teis on
        teis.idregistro = tdcdae.idtcededucaocreditodaest
        and teis.identificadorarquivo = 'ESTORNO_DEDUCAO_CREDITO_DIVIDA_ATIVA'
        where tdcdae.dtestorno between :dataInicial and :dataFinal) as temerroimportacao
from (
         select sum(filtro.vlEstorno) as valor
         from (select coalesce(tdcdae.vlestorno, 0) as vlEstorno
                              from tceDeducaoCreditoDAEst tdcdae
                              where tdcdae.dtestorno between :dataInicial and :dataFinal) filtro
     ) as arquivo
cross join (select sum(valor) as valor
            from (
                     select iip.valor as valor
                     from integracaopatrimonial ip
                              left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                              left join tribreceita r
                                        on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                           r.entidade = ip.entidade
                              JOIN tribreceitatipo trt
                                   ON trt.tiporeceita = r.tiporeceita
                     where ip.entidade = :entidade
                       and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                       and ip.datamovimento between :dataInicial and :dataFinal
                       and iip.tipomovimento in ('ESTORNO_CANCELAMENTO', 'ESTORNO_DACAO_PAGAMENTO', 'ESTORNO_DESCONTO_PARCELAMENTO')
                       and iip.situacaolegal in (1,2)
                       and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
                     union all
                     select liic.valordeducao
                     from loteintegracaocontabil lic
                         left join loteitemintegracaocontabil liic
                     on lic.id = liic.idlote
                         left join tribreceita tr on liic.idtributo = tr.id
                         left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                         left join tribmotivodesconto tmd on liic.idmotivodeducao = tmd.motivodesconto
                     where lic.datalote between :dataInicial and :dataFinal
                       and liic.situacaolegal in (1,2)
                       and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                       and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
                       and lic.tipolote = 'ESTORNO_PAGAMENTO'
                       and liic.valordeducao > 0) as dados
) as integracao