select 13                                             							as codigoArquivo,
       'Arrecadação por Tipo de Crédito' 							            as arquivo,
       'CREDITO'                                      							as tipoArquivo,
       arquivo.valor                         	                                as valorArquivo,
       integracao.valor                               							as valorIntegracao,
       retencao.valor                                                           as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tcearrecadacaotipocredito atc
        join triberrosimportacaosimam teis on
        teis.idregistro = atc.idtcearrtipocredito
        and teis.identificadorarquivo = 'ARRECADACAO_TIPO_CREDITO'
        where atc.nrmes = :mes and atc.nrano = :ano) as temerroimportacao
from (select coalesce(sum(atc.vlarrecadacao),0) as valor
      from tceArrecadacaoTipoCredito atc
      where atc.nrmes = :mes and atc.nrano = :ano) arquivo
         cross join (select sum(liic.valortributo - liic.valordeducao) as valor
                     from loteintegracaocontabil lic
                              left join loteitemintegracaocontabil liic
                                        on lic.id = liic.idlote
                              left join tribreceita tr on liic.idtributo = tr.id
                              left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                     where lic.datalote between :dataInicial and :dataFinal
                       and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                       and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
                       and (lic.tipolote in ('PAGAMENTO', 'REABILITACAO_PAGAMENTO') or (lic.tipolote = 'ESTORNO_PAGAMENTO' and liic.idtipooperacaodeducao = 3))) integracao
         cross join (select coalesce(sum(rc.valor),0) as valor from tceretencaocontabil rc
                     where rc.dtlancamento between :dataInicial and :dataFinal and coalesce(rc.devolucao, 'N') = 'N') retencao