SELECT DISTINCT
       GER.TIPOCADASTRO,
       TIPOCAD.DESCRICAO as DESCRICAOTIPOCADASTRO,
       GER.CADASTROGERAL,
       CASE WHEN VERIFICADEBITO.EXISTEDEBITO IS NOT NULL
       		THEN 'true' ELSE 'false'
       END AS EXISTEDEBITO,
       CASE WHEN VERIFICACARNE.EXISTECARNE IS NOT NULL
            THEN 'true' ELSE 'false'
       END AS EXISTECARNE,
       VERIFICAVENCIDO.DEBITOVENCIDO,
       CASE WHEN VERIFICADEBITO.EXISTEDEBITO = 1
            AND VERIFICAVENCIDO.DEBITOVENCIDO = 'true'
            THEN 'Possui Débitos Vencidos'
            WHEN VERIFICADEBITO.EXISTEDEBITO = 1
            AND VERIFICAVENCIDO.DEBITOVENCIDO = 'false'
            THEN 'Possui Débitos a Vencer'
            WHEN VERIFICADEBITO.EXISTEDEBITO IS NULL
            THEN 'Não Possui Débitos em aberto'
       END AS SITUACAODEBITO,
       PES.NOME,
       PES.CNPJ_CPF AS CPFCNPJ,
       COALESCE(TIPOLOGR.DESCRICAO, '') || ' ' || COALESCE(LOGR.DESCRICAO, '') || ' - ' || COALESCE(GER.NUMERO, '') || ' - ' || COALESCE(GER.COMPLEMENTO, '') || ' - ' || COALESCE(BAR.DESCRICAO, '') || ' - ' || COALESCE(CID.DESCRICAO, '') || ' - ' || COALESCE(CID.UNIDADEFEDERACAO, '') as ENDERECO
FROM PESSOA PES
INNER JOIN (SELECT P.PESSOA,
                   P.CNPJ_CPF,
                   A.TIPOCADASTRO,
                   A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBREPRESENTANTELEGAL A ON P.PESSOA = A.PESSOA
            LEFT JOIN TRIBTIPOREPRESENTANTE B ON A.TIPOREPRESENTANTE = B.TIPOREPRESENTANTE
                                             AND B.ADMINISTRADOR = 'S'
            UNION
            SELECT P.PESSOA,
                   P.CNPJ_CPF,
                   A.TIPOCADASTRO,
                   A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBPROPRIETARIO A ON P.PESSOA = A.PESSOA) CAD ON PES.PESSOA = CAD.PESSOA
                                                                     AND PES.CNPJ_CPF = CAD.CNPJ_CPF
INNER JOIN TRIBCADASTROGERAL GER ON GER.TIPOCADASTRO = CAD.TIPOCADASTRO
                                AND GER.CADASTROGERAL = CAD.CADASTROGERAL
INNER JOIN TRIBTIPOCADASTRO TIPOCAD ON TIPOCAD.TIPOCADASTRO = GER.TIPOCADASTRO
LEFT OUTER JOIN LOGRADOURO LOGR ON LOGR.CIDADE     = GER.CIDADE
                               AND LOGR.LOGRADOURO = GER.LOGRADOURO
LEFT OUTER JOIN TIPOLOGRADOURO TIPOLOGR ON TIPOLOGR.TIPOLOGRADOURO = LOGR.TIPOLOGRADOURO
LEFT OUTER JOIN CIDADE CID ON CID.CIDADE = GER.CIDADE
LEFT OUTER JOIN BAIRRO BAR ON BAR.CIDADE = CID.CIDADE
                                    AND BAR.BAIRRO = GER.BAIRRO
LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO CAD_IMOB ON GER.TIPOCADASTRO = CAD_IMOB.TIPOCADASTRO
                                                AND GER.CADASTROGERAL = CAD_IMOB.CADASTROGERAL
LEFT OUTER JOIN (SELECT A.TIPOCADASTRO,
                        A.CADASTROGERAL,
                        MAX(A.SEQUENCIA) AS SEQUENCIA
                 FROM TRIBIMOBILIARIOSITUACAO A
                 WHERE A.ATUAL = 'S'
                 GROUP BY A.TIPOCADASTRO,
                          A.CADASTROGERAL) S_IMOB ON CAD_IMOB.TIPOCADASTRO = S_IMOB.TIPOCADASTRO
                                                                 AND CAD_IMOB.CADASTROGERAL = S_IMOB.CADASTROGERAL
LEFT OUTER JOIN TRIBIMOBILIARIOSITUACAO SIT_IMOB ON S_IMOB.TIPOCADASTRO = SIT_IMOB.TIPOCADASTRO
                                                AND S_IMOB.CADASTROGERAL = SIT_IMOB.CADASTROGERAL
                                                AND S_IMOB.SEQUENCIA = SIT_IMOB.SEQUENCIA
LEFT OUTER JOIN TRIBSITUACAOIMOBILIARIO TS_IMOB ON SIT_IMOB.SITUACAOIMOBILIARIO = TS_IMOB.SITUACAOIMOBILIARIO
LEFT OUTER JOIN TRIBCADASTROMOBILIARIO CAD_MOB ON GER.TIPOCADASTRO = CAD_MOB.TIPOCADASTRO
                                              AND GER.CADASTROGERAL = CAD_MOB.CADASTROGERAL
LEFT OUTER JOIN (SELECT A.TIPOCADASTRO,
                        A.CADASTROGERAL,
                        MAX(A.SEQUENCIA) AS SEQUENCIA
                 FROM TRIBMOBILIARIOSITUACAO A
                 WHERE A.ATUAL = 'S'
                 GROUP BY A.TIPOCADASTRO,
                          A.CADASTROGERAL) S_MOB ON CAD_MOB.TIPOCADASTRO = S_MOB.TIPOCADASTRO
                                                AND CAD_MOB.CADASTROGERAL = S_MOB.CADASTROGERAL
LEFT OUTER JOIN TRIBMOBILIARIOSITUACAO SIT_MOB ON S_MOB.TIPOCADASTRO = SIT_MOB.TIPOCADASTRO
                                              AND S_MOB.CADASTROGERAL = SIT_MOB.CADASTROGERAL
                                              AND S_MOB.SEQUENCIA = SIT_MOB.SEQUENCIA
LEFT OUTER JOIN TRIBSITUACAOMOBILIARIO TS_MOB ON SIT_MOB.SITUACAOMOBILIARIO = TS_MOB.SITUACAOMOBILIARIO
LEFT OUTER JOIN ( select 1 AS EXISTEDEBITO,
	DEB.TIPOCADASTRO,
	DEB.CADASTROGERAL
FROM
	TRIBDEBITO DEB
INNER JOIN TRIBDEBITOPARCELA PAR ON
	DEB.ENTIDADE = PAR.ENTIDADE
	AND DEB.EXERCICIO = PAR.EXERCICIO
	AND DEB.TIPOCADASTRO = PAR.TIPOCADASTRO
	AND DEB.CADASTROGERAL = PAR.CADASTROGERAL
	AND DEB.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO
	AND DEB.SUBDIVIDA = PAR.SUBDIVIDA
INNER JOIN TRIBSITUACAOPARCELA SIT ON
	PAR.SITUACAODEBITO = SIT.SITUACAOPARCELA
INNER JOIN TRIBTIPOSITUACAOPARCELA TIP ON
	SIT.SITUACAOPARCELA = TIP.TIPOSITUACAOPARCELA
INNER JOIN TRIBCADASTROGERAL CG  ON
	CG.TIPOCADASTRO = DEB.TIPOCADASTRO
	AND CG.CADASTROGERAL = DEB.CADASTROGERAL
WHERE
	DEB.CONSTITUIDO = 'S'
	AND TIP.tipo = 'A') VERIFICADEBITO ON VERIFICADEBITO.TIPOCADASTRO = GER.TIPOCADASTRO
	AND VERIFICADEBITO.CADASTROGERAL = GER.CADASTROGERAL
LEFT OUTER JOIN (
select 1 AS EXISTECARNE,
	DEB.TIPOCADASTRO,
	DEB.CADASTROGERAL
FROM
	TRIBDEBITO DEB
INNER JOIN TRIBDEBITOPARCELA PAR ON
	DEB.ENTIDADE = PAR.ENTIDADE
	AND DEB.EXERCICIO = PAR.EXERCICIO
	AND DEB.TIPOCADASTRO = PAR.TIPOCADASTRO
	AND DEB.CADASTROGERAL = PAR.CADASTROGERAL
	AND DEB.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO
	AND DEB.SUBDIVIDA = PAR.SUBDIVIDA
INNER JOIN TRIBSITUACAOPARCELA SIT ON
	PAR.SITUACAODEBITO = SIT.SITUACAOPARCELA
INNER JOIN TRIBCADASTROGERAL CG  ON
	CG.TIPOCADASTRO = DEB.TIPOCADASTRO
	AND CG.CADASTROGERAL = DEB.CADASTROGERAL
 INNER JOIN TRIBGUIARECOLHIMENTOFORMAPAG FPAG
         ON DEB.ENTIDADE         = FPAG.ENTIDADE
        AND DEB.EXERCICIO        = FPAG.EXERCICIO
        AND DEB.GUIARECOLHIMENTO = FPAG.GUIARECOLHIMENTO
 INNER JOIN TRIBFORMAPAGAMENTO FP
         ON FP.FORMAPAGAMENTO = FPAG.FORMAPAGAMENTO
WHERE
	DEB.CONSTITUIDO = 'S'
	AND SIT.TIPOSITUACAOPARCELA = 1
	AND FPAG.DISPONIVELWEB = 'S'
    AND FPAG.VENCIMENTO >= CURRENT_DATE
    AND
     ( (FP.TIPOFORMAPAGAMENTO <> 'U' AND EXISTS(SELECT 1
                       FROM TRIBDEBITOPARCELA PARSUB
                       INNER JOIN TRIBSITUACAOPARCELA SITSUB
                          ON SITSUB.SITUACAOPARCELA     = PARSUB.SITUACAODEBITO
                       INNER JOIN TRIBTIPOSITUACAOPARCELA TIPSUB ON SITSUB.TIPOSITUACAOPARCELA = TIPSUB.TIPOSITUACAOPARCELA
                       WHERE PARSUB.ENTIDADE            = DEB.ENTIDADE
                       AND   PARSUB.EXERCICIO           = DEB.EXERCICIO
                       AND   PARSUB.TIPOCADASTRO        = DEB.TIPOCADASTRO
                       AND   PARSUB.CADASTROGERAL       = DEB.CADASTROGERAL
                       AND   PARSUB.GUIARECOLHIMENTO    = DEB.GUIARECOLHIMENTO
                       AND   PARSUB.SUBDIVIDA           = DEB.SUBDIVIDA
                       AND   PARSUB.DATAVENCIMENTO     >= CURRENT_DATE
                       AND   TIPSUB.TIPO = 'A'))
     OR
       (FP.TIPOFORMAPAGAMENTO = 'U'
        AND NOT EXISTS (SELECT 1
                       FROM TRIBDEBITOPARCELA PARSUB
                       INNER JOIN TRIBSITUACAOPARCELA SITSUB
                          ON SITSUB.SITUACAOPARCELA     = PARSUB.SITUACAODEBITO
                       INNER JOIN TRIBTIPOSITUACAOPARCELA TIPSUB ON SITSUB.TIPOSITUACAOPARCELA = TIPSUB.TIPOSITUACAOPARCELA
                       WHERE PARSUB.ENTIDADE            = DEB.ENTIDADE
                       AND   PARSUB.EXERCICIO           = DEB.EXERCICIO
                       AND   PARSUB.TIPOCADASTRO        = DEB.TIPOCADASTRO
                       AND   PARSUB.CADASTROGERAL       = DEB.CADASTROGERAL
                       AND   PARSUB.GUIARECOLHIMENTO    = DEB.GUIARECOLHIMENTO
                       AND   PARSUB.SUBDIVIDA           = DEB.SUBDIVIDA
                       AND   TIPSUB.TIPO <> 'A')
     ))
) VERIFICACARNE on VERIFICACARNE.TIPOCADASTRO = GER.TIPOCADASTRO
	and VERIFICACARNE.CADASTROGERAL = GER.CADASTROGERAL
INNER JOIN (SELECT CASE WHEN EXISTS(SELECT 1
                                     FROM TRIBDEBITO DEB
                                     INNER JOIN TRIBDEBITOPARCELA PAR ON DEB.ENTIDADE = PAR.ENTIDADE
                                                                     AND DEB.EXERCICIO = PAR.EXERCICIO
                                                                     AND DEB.TIPOCADASTRO = PAR.TIPOCADASTRO
                                                                     AND DEB.CADASTROGERAL = PAR.CADASTROGERAL
                                                                     AND DEB.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO
                                                                     AND DEB.SUBDIVIDA = PAR.SUBDIVIDA
                                     INNER JOIN TRIBSITUACAOPARCELA SIT ON PAR.SITUACAODEBITO = SIT.SITUACAOPARCELA
                                     INNER JOIN TRIBTIPOSITUACAOPARCELA TIP ON SIT.SITUACAOPARCELA = TIP.TIPOSITUACAOPARCELA
                                     WHERE DEB.TIPOCADASTRO = CG.TIPOCADASTRO
                                       AND DEB.CADASTROGERAL = CG.CADASTROGERAL
                                       AND DEB.CONSTITUIDO = 'S'
                                       AND TIP.tipo = 'A'
                                       AND PAR.DATAVENCIMENTO < CURRENT_DATE
                    ) THEN 'true' ELSE 'false' END AS DEBITOVENCIDO,
                    CG.TIPOCADASTRO,
                    CG.CADASTROGERAL
            FROM TRIBCADASTROGERAL CG) as VERIFICAVENCIDO on VERIFICAVENCIDO.TIPOCADASTRO = GER.TIPOCADASTRO
	and VERIFICAVENCIDO.CADASTROGERAL = GER.CADASTROGERAL
WHERE PES.CNPJ_CPF = :cpfcnpj
AND GER.EXCLUSAOLOGICA = 'N'
%s