/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.AttMonetariaCreditoValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaCreditoValidacaoService {
    private static final Long CODIGO_ESCOPO_LEI = 22L;
    private static final Set<Long> tipoAtualizacaoCredito = Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L));

    public List<ErrosImportacaoSIMAM> validateAttMonetariaCredito(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroDuplicado(attMonetariaCreditoValidacaoDTO));
        erros.add(this.validateSequenciaNrAtualizacao(attMonetariaCreditoValidacaoDTO));
        erros.add(this.validateNrCreditoNrAnoCredito(attMonetariaCreditoValidacaoDTO));
        erros.add(this.validateCdControleLeiAto(attMonetariaCreditoValidacaoDTO));
        erros.add(this.validateTipoAtualizacaoCredito(attMonetariaCreditoValidacaoDTO));
        erros.add(this.validateDtAtualizacao(attMonetariaCreditoValidacaoDTO, stepExecution));
        erros.add(this.validateVlAtualizacao(attMonetariaCreditoValidacaoDTO));
        erros.add(this.validateRegistroCreditoDuplicado(attMonetariaCreditoValidacaoDTO));
        erros.add(this.validateAnoAtualizacao(attMonetariaCreditoValidacaoDTO));
        return erros.stream().flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicado(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (attMonetariaCreditoValidacaoDTO.getQtdRegistrosAttMoneCredito() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"A combina\u00e7\u00e3o (idPessoa, nrAtualizacao e nrAnoAtualizacao) da tabela (AtualizacaoMonetariaCredito) apresenta-se com registro duplicado.", (Long)1325L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequenciaNrAtualizacao(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (attMonetariaCreditoValidacaoDTO.getNrAtualizacao() - attMonetariaCreditoValidacaoDTO.getNrAtualizacaoAnterior() != 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"O N\u00famero e Ano da Atualiza\u00e7\u00e3o Monet\u00e1ria (nrAtualizacao e nrAnoAtualizacao) da tabela (AtualizacaoMonetariaCredito) apresenta-se quebra da ordem sequencial no ano de trabalho.", (Long)1326L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrCreditoNrAnoCredito(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (Objects.isNull(attMonetariaCreditoValidacaoDTO.getNrCredito()) || Objects.isNull(attMonetariaCreditoValidacaoDTO.getNrAnoCredito())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"A combina\u00e7\u00e3o (nrCredito e nrAnoCredito) declarada da tabela (AtualizacaoCredito) n\u00e3o existe na tabela (LancamentoCredito)", (Long)1327L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (Objects.isNull(attMonetariaCreditoValidacaoDTO.getEscopoLei()) || !CODIGO_ESCOPO_LEI.equals(attMonetariaCreditoValidacaoDTO.getEscopoLei())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"O Controle de Lei/Ato (cdControleLeiAto) declarado na tabela (AtualizacaoCredito) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1328L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateTipoAtualizacaoCredito(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (!tipoAtualizacaoCredito.contains(attMonetariaCreditoValidacaoDTO.getIdTipoAtualizacaoCredito())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"O Tipo de Atualiza\u00e7\u00e3o do Cr\u00e9dito (idTipoAtualizaocaCredito) da tabela (AtualizacaoCredito) n\u00e3o existe na tabela (TipoAtualizacaoCredito).", (Long)1329L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDtAtualizacao(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO, StepExecution stepExecution) {
        LocalDate mesValidacao = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        if (attMonetariaCreditoValidacaoDTO.getDtAtualizacao().isAfter(mesValidacao)) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"A Data da Atualiza\u00e7\u00e3o (dtAtualizacao) da tabela (AtualizacaoCredito) n\u00e3o pode ser maior que o m\u00eas/ano de trabalho.", (Long)1330L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlAtualizacao(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (attMonetariaCreditoValidacaoDTO.getVlAtualizacao().compareTo(BigDecimal.ZERO) < 0) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"O Valor da Atualiza\u00e7\u00e3o (vlAtualizacao) da tabela (AtualizacaoCredito) n\u00e3o pode ser negativo.", (Long)1331L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroCreditoDuplicado(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (Objects.isNull(attMonetariaCreditoValidacaoDTO.getNrAtualizacaoCredito()) || attMonetariaCreditoValidacaoDTO.getNrAtualizacaoCredito() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"A combina\u00e7\u00e3o (nrCredito e nrAnoCredito) da tabela (AtualizacaoCredito) apresenta-se com registro duplicado.", (Long)2115L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateAnoAtualizacao(AttMonetariaCreditoValidacaoDTO attMonetariaCreditoValidacaoDTO) {
        if (attMonetariaCreditoValidacaoDTO.getNrAnoAtualizacao() < 2023L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)attMonetariaCreditoValidacaoDTO.getIdTceAtualizaMoneCred(), (String)"O registro declarado na tabela (AtualizacaoCredito) n\u00e3o pode estar vinculado com ano de cr\u00e9dito (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023.", (Long)2243L, (TipoRegistroSimAm)TipoRegistroSimAm.ATUALIZACAO_MONETARIA_CREDITO));
        }
        return Optional.empty();
    }
}

