/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.dto.integracaogeomais.BoletimGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralPostGeomaisDTO;
import br.com.elotech.tributos.repository.SolicitacaoAlvaraRepository;
import br.com.elotech.tributos.repository.solicitacaotestada.SolicitacaoTestadaLogRepository;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.BoletimImobiliarioSegmentoService;
import br.com.elotech.tributos.service.BoletimImobiliarioTerrenoService;
import br.com.elotech.tributos.service.BoletimLogradouroService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.service.integracaogeomais.CadastroImobiliarioElogeoServiceAbstract;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"onpremise"})
public class AiseCadastroImobiliarioElogeoService
extends CadastroImobiliarioElogeoServiceAbstract {
    private final BoletimImobiliarioTerrenoService boletimImobiliarioTerrenoService;
    private final BoletimImobiliarioSegmentoService boletimImobiliarioSegmentoService;
    private final BoletimLogradouroService boletimLogradouroService;

    public AiseCadastroImobiliarioElogeoService(CadastroGeralService cadastroGeralService, CadastroImobiliarioService cadastroImobiliarioService, DistritoService distritoService, SetorService setorService, BairroService bairroService, SetorQuadraService setorQuadraService, SolicitacaoTestadaLogRepository solicitacaoTestadaLogRepository, SolicitacaoAlvaraRepository solicitacaoAlvaraRepository, LogradouroService logradouroService, LoteamentoService loteamentoService, CondominioService condominioService, ParametroGeralService parametroGeralService, BoletimImobiliarioTerrenoService boletimImobiliarioTerrenoService, BoletimImobiliarioSegmentoService boletimImobiliarioSegmentoService, BoletimLogradouroService boletimLogradouroService) {
        super(cadastroGeralService, cadastroImobiliarioService, distritoService, setorService, bairroService, setorQuadraService, solicitacaoTestadaLogRepository, solicitacaoAlvaraRepository, logradouroService, loteamentoService, condominioService, parametroGeralService);
        this.boletimImobiliarioTerrenoService = boletimImobiliarioTerrenoService;
        this.boletimImobiliarioSegmentoService = boletimImobiliarioSegmentoService;
        this.boletimLogradouroService = boletimLogradouroService;
    }

    protected void mergeBoletins(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario saved) {
        this.boletimImobiliarioTerrenoService.merge(cadastroGeralPostGeomaisDTO.getImobiliario().getBoletim(), saved.getId());
        cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos().forEach(segmentoDTO -> {
            try {
                Long idSegmento = saved.getSegmentos().stream().filter(segmento -> segmento.getSequencia().equals(segmentoDTO.getSequencia())).findFirst().map(CadastroImobiliarioSegmento::getId).orElseThrow();
                this.boletimImobiliarioSegmentoService.merge(segmentoDTO.getCaracteristicas(), idSegmento.longValue());
            }
            catch (NoSuchElementException e) {
                throw new EloValidationException(String.format("Segmento n\u00e3o encontrado para o Cadastro Imobili\u00e1rio %d", saved.getCadastroGeral()));
            }
        });
    }

    protected CadastroGeralGeomaisDTO entityToGeomaisDTO(CadastroImobiliario cadastroImobiliario) {
        List boletimImobiliarioTerrenos = this.boletimImobiliarioTerrenoService.findByIdCadastroImobiliario(cadastroImobiliario.getId());
        CadastroGeralGeomaisDTO cadastroGeralGeomaisDTO = CadastroGeralGeomaisDTO.from((CadastroImobiliario)cadastroImobiliario, (List)boletimImobiliarioTerrenos);
        cadastroGeralGeomaisDTO.getImobiliario().getSegmentos().forEach(segmentoDTO -> {
            List boletimSegmento = this.boletimImobiliarioSegmentoService.findByIdImobiliarioSegmento(segmentoDTO.getId()).stream().map(BoletimGeomaisDTO::from).collect(Collectors.toList());
            segmentoDTO.setCaracteristicas(boletimSegmento);
        });
        cadastroGeralGeomaisDTO.getImobiliario().getTestadas().forEach(logradouroTestadaDTO -> {
            List boletimLogradouroTestada = this.boletimLogradouroService.findByIdLogradouroTestada(logradouroTestadaDTO.getSecaoId()).stream().map(BoletimGeomaisDTO::from).collect(Collectors.toList());
            logradouroTestadaDTO.getSecao().setCaracteristicas(boletimLogradouroTestada);
        });
        return cadastroGeralGeomaisDTO;
    }

    protected CadastroImobiliario prepareGeomaisToSave(CadastroImobiliario cadastroImobiliarioToSave, Boolean novoCadastro, CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO) {
        if (!novoCadastro.booleanValue() && cadastroImobiliarioToSave.getCadastroGeral() != null) {
            CadastroImobiliario cadastroImobiliarioFound = Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroImobiliarioToSave.getCadastroGeral())).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", cadastroImobiliarioToSave.getCadastroGeral())));
            cadastroImobiliarioFound.getSegmentos().forEach(segmento -> {
                if (cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos().stream().noneMatch(v -> segmento.getSequencia().equals(v.getSequencia()))) {
                    this.boletimImobiliarioSegmentoService.deleteByIdImobiliarioSegmento(segmento.getId());
                }
            });
            return cadastroImobiliarioFound.mergeGeomais(cadastroImobiliarioToSave);
        }
        return cadastroImobiliarioToSave;
    }
}

