/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicredi;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Agencia;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.ChaveTransacaoSicredi;
import br.com.elotech.tributos.domain.integracaoboleto.EmissaoRespostaSicredi;
import br.com.elotech.tributos.domain.integracaoboleto.ErroRegistroSicredi;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.ResultadoAlteracaoBoletoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.AlteracaoVencimentoBoletoSicrediDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.EmissaoBoletoPixSicrediDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.EmissaoBoletoSicrediDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.QrCodePixSicrediErroDTO;
import br.com.elotech.tributos.dto.integracaoboleto.sicredi.QrCodePixSicrediRequestDTO;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.cnab240.ParametroCNAB240Repository;
import br.com.elotech.tributos.repository.integracaoboleto.ChaveTransacaoSicrediRepository;
import br.com.elotech.tributos.repository.integracaoboleto.EmissaoRespostaSicrediRepository;
import br.com.elotech.tributos.repository.integracaoboleto.ErroRegistroSicrediRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.sicredi.AutenticacaoSicrediService;
import br.com.elotech.tributos.util.GeradorDigitoVerificador;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IntegracaoBoletoSicrediService
implements IntegracaoBoletoRegistrado,
IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoSicrediService.class);
    private static final Integer SEQINICIAL_NOSSONUMERO = 200001;
    private static final Integer SEQFINAL_NOSSONUMERO = 999999;
    private final ParametroGeralService parametroGeralService;
    private final ChaveTransacaoSicrediRepository chaveTransacaoSicrediRepository;
    private final RestTemplate restTemplate;
    private final ObjectMapper mapper;
    private final ParametroCNAB240Repository parametroCNAB240Repository;
    private final ErroRegistroSicrediRepository erroRegistroSicrediRepository;
    private final EmissaoRespostaSicrediRepository emissaoRespostaSicrediRepository;
    private final PlatformTransactionManager transactionManager;
    private final BancoRepository bancoRepository;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private final EntidadeRepository entidadeRepository;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private String request = null;
    private final AutenticacaoSicrediService autenticacaoSicrediService;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final ParametroPixRepository parametroPixRepository;

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return (ParametroCNAB240)this.parametroCNAB240Repository.findFirstByBanco((Banco)this.bancoRepository.findOne((Object)Banco.CODIGO_SICREDI)).orElseThrow(() -> new EloValidationException("Par\u00e2metro CNAB 240 n\u00e3o encontrado para o banco SICREDI!"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        CodigoBarrasDTO codigoBarrasDTO;
        this.request = null;
        if (Boolean.TRUE.equals(boleto.getModeloBloqueto().getConvenio().getUtilizaPix())) {
            return this.generateBoletoHibrido(boleto, parametroCNAB240);
        }
        ChaveTransacaoSicredi chaveTransacao = null;
        ErroRegistroSicredi erroRegistroSicredi = null;
        String stackTraceIntegracao = null;
        try {
            chaveTransacao = this.getChaveTransacao(boleto);
            Entidade entidade = (Entidade)this.entidadeRepository.findById((Object)boleto.getEntidade()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar a entidade com id %d", boleto.getEntidade())));
            EmissaoBoletoSicrediDTO dto = EmissaoBoletoSicrediDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240, (Entidade)entidade);
            HttpHeaders headers = new HttpHeaders();
            headers.set("token", chaveTransacao.getChave());
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity httpEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            String urlEmissao = this.getParametro(ParametroGeralEnum.REMESSA_URL_SICREDI_EMISSAO);
            try {
                this.request = "POST to " + urlEmissao + ": " + this.mapper.writeValueAsString((Object)httpEntity);
            }
            catch (Exception e) {
                log.error("Erro ao converter a requisi\u00e7\u00e3o em string", (Throwable)e);
            }
            JsonNode response = (JsonNode)this.restTemplate.exchange(urlEmissao, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            this.saveEmissaoResposta(response, boleto);
            CodigoBarrasDTO codigoBarrasDTO2 = new CodigoBarrasDTO();
            codigoBarrasDTO2.setCodigoBarras(response.get("codigoBarra").asText());
            codigoBarrasDTO2.setLinhaDigitavel(response.get("linhaDigitavel").asText());
            codigoBarrasDTO2.setCampo1(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)0, (int)10));
            codigoBarrasDTO2.setCampo2(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)10, (int)21));
            codigoBarrasDTO2.setCampo3(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)21, (int)32));
            codigoBarrasDTO2.setCampo4(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)32, (int)33));
            codigoBarrasDTO2.setCampo5(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)33, (int)47));
            codigoBarrasDTO2.setNossoNumero(boleto.getNossoNumero());
            codigoBarrasDTO2.setDvNossoNumero(boleto.getDvNossoNumero());
            codigoBarrasDTO2.generateCodigoBarrasFormatadoIntervalo2Of5();
            codigoBarrasDTO = codigoBarrasDTO2;
        }
        catch (RestException e) {
            try {
                JsonNode responseError = this.converterErroResposta(e.getMessage());
                String mensagem = e.getMessage();
                String codigo = null;
                String parametro = null;
                if (Objects.nonNull(responseError) && responseError.has("mensagem") && StringUtils.isNotEmpty((String)responseError.get("mensagem").asText())) {
                    mensagem = responseError.get("mensagem").asText();
                    parametro = responseError.get("parametro").asText();
                    codigo = responseError.get("codigo").asText();
                }
                erroRegistroSicredi = new ErroRegistroSicredi();
                erroRegistroSicredi.setNossoNumero(boleto.getNossoNumero());
                erroRegistroSicredi.setChaveTransacao((String)Optional.ofNullable(chaveTransacao).map(ChaveTransacaoSicredi::getChave).orElse(null));
                erroRegistroSicredi.setResponseBody(e.getMessage());
                erroRegistroSicredi.setMensagem(mensagem);
                erroRegistroSicredi.setCodigo(codigo);
                erroRegistroSicredi.setParametro(parametro);
                erroRegistroSicredi.setCodigoHttp(Integer.valueOf(e.getStatus().value()));
                stackTraceIntegracao = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                throw new BoletoException("Erro ao enviar o boleto registrado para SICREDI: " + codigo + " - " + mensagem + " - " + parametro);
                catch (Exception e2) {
                    erroRegistroSicredi = new ErroRegistroSicredi();
                    erroRegistroSicredi.setNossoNumero(boleto.getNossoNumero());
                    erroRegistroSicredi.setChaveTransacao((String)Optional.ofNullable(chaveTransacao).map(ChaveTransacaoSicredi::getChave).orElse(null));
                    erroRegistroSicredi.setResponseBody(e2.getMessage());
                    erroRegistroSicredi.setMensagem(e2.getMessage());
                    erroRegistroSicredi.setCodigo(null);
                    erroRegistroSicredi.setParametro(null);
                    stackTraceIntegracao = Arrays.stream(e2.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.saveErroSicredi(erroRegistroSicredi, boleto, stackTraceIntegracao);
                throw throwable;
            }
        }
        this.saveErroSicredi(erroRegistroSicredi, boleto, stackTraceIntegracao);
        return codigoBarrasDTO;
    }

    private String gerarNossoNumero(Bloqueto boleto) {
        String exercicioBloqueto = boleto.getExercicioBloqueto().toString();
        String bloquetoCincoDigitos = this.gerarSequencialNossoNumero(exercicioBloqueto);
        if (StringUtils.length((String)bloquetoCincoDigitos.toString()) > 6) {
            bloquetoCincoDigitos = bloquetoCincoDigitos.substring(0, bloquetoCincoDigitos.length() - 5);
        }
        String nossoNumero = exercicioBloqueto.substring(2, 4).concat(StringUtils.leftPad((String)bloquetoCincoDigitos, (int)6, (char)'0'));
        return nossoNumero;
    }

    private String gerarSequencialNossoNumero(String exercicioBloqueto) {
        boolean isCurrentSequenceValid;
        String nomeSequence = "s05sicrediseq_" + exercicioBloqueto;
        Boolean sequenceExists = this.sequenceGeneratorRepository.sequenceExistsBySequenceName(nomeSequence);
        Long currentSequenceValue = sequenceExists != false ? this.sequenceGeneratorRepository.getNextVal(nomeSequence) : null;
        boolean bl = isCurrentSequenceValid = sequenceExists != false && currentSequenceValue != null && currentSequenceValue >= (long)SEQINICIAL_NOSSONUMERO.intValue() && currentSequenceValue <= (long)SEQFINAL_NOSSONUMERO.intValue();
        if (isCurrentSequenceValid) {
            return currentSequenceValue.toString();
        }
        if (sequenceExists.booleanValue() && !isCurrentSequenceValid) {
            this.sequenceGeneratorRepository.dropSequence(nomeSequence);
        }
        this.sequenceGeneratorRepository.createSequenceWithCycle(nomeSequence, SEQINICIAL_NOSSONUMERO, SEQFINAL_NOSSONUMERO);
        return this.sequenceGeneratorRepository.getNextVal(nomeSequence).toString();
    }

    private String gerarDVNossoNumero(Bloqueto boleto, String nossoNumero) {
        String agencia = Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getContaBancaria).map(ContaBancaria::getAgencia).map(Agencia::getAgencia).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel localizar a agencia"));
        String posto = Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getCodigoPosto).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel localizar o c\u00f3digo posto"));
        String cedente = Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getCodigoCedente).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel localizar o c\u00f3digo de cedente"));
        StringBuilder nossoNumeroDVCheck = new StringBuilder().append(StringUtils.leftPad((String)agencia.substring(0, 4), (int)4, (char)'0')).append(StringUtils.leftPad((String)posto.substring(0, 2), (int)2, (char)'0')).append(StringUtils.leftPad((String)cedente.substring(0, 5), (int)5, (char)'0')).append(nossoNumero);
        Integer nossoNumeroDV = GeradorDigitoVerificador.geradorDigitoVerificadorMod11((String)nossoNumeroDVCheck.toString());
        if (nossoNumeroDV > 9) {
            nossoNumeroDV = 0;
        }
        return String.valueOf(nossoNumeroDV);
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_SICRED_CNAB240_COM_REGISTRO;
    }

    private void saveErroSicredi(ErroRegistroSicredi erroRegistroSicredi, Bloqueto boleto, String observacoes) {
        if (Objects.nonNull(erroRegistroSicredi)) {
            new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> (ErroRegistroSicredi)this.erroRegistroSicrediRepository.save((Object)erroRegistroSicredi));
            new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
                ErroBoletoRegistroOnline erroBoletoRegistroOnline = new ErroBoletoRegistroOnline();
                erroBoletoRegistroOnline.setRequest((byte[])Optional.ofNullable(this.request).map(String::getBytes).orElse(null));
                erroBoletoRegistroOnline.setResponse((byte[])Optional.ofNullable(erroRegistroSicredi.getResponseBody()).map(String::getBytes).orElse(null));
                erroBoletoRegistroOnline.setDataHoraIntegracao(LocalDateTime.now());
                erroBoletoRegistroOnline.setIdBoleto(boleto.getId());
                erroBoletoRegistroOnline.setDetalhes(observacoes);
                return (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroBoletoRegistroOnline);
            });
        }
    }

    private ChaveTransacaoSicredi getChaveTransacao(Bloqueto boleto) {
        ChaveTransacaoSicredi chaveTransacao = this.getChaveTransacaoAtiva(boleto);
        if (Objects.nonNull(chaveTransacao)) {
            return chaveTransacao;
        }
        return this.generateChaveTransacao(boleto);
    }

    private void saveEmissaoResposta(JsonNode response, Bloqueto boleto) {
        String jsonRetorno = null;
        try {
            jsonRetorno = this.mapper.writeValueAsString((Object)response);
        }
        catch (JsonProcessingException e) {
            log.error("Erro ao converter o json em string", (Throwable)e);
        }
        EmissaoRespostaSicredi emissaoRespostaSicredi = new EmissaoRespostaSicredi();
        emissaoRespostaSicredi.setLinhaDigitavel(response.get("linhaDigitavel").asText());
        emissaoRespostaSicredi.setNomeBeneficiario((String)Optional.ofNullable(response.get("nomeBeneficiario")).map(JsonNode::asText).orElse(null));
        emissaoRespostaSicredi.setDataDocumento((String)Optional.ofNullable(response.get("dataDocumento")).map(JsonNode::asText).orElse(null));
        emissaoRespostaSicredi.setSeuNumero((String)Optional.ofNullable(response.get("seuNumero")).map(JsonNode::asText).orElse(null));
        emissaoRespostaSicredi.setNossoNumero(boleto.getNossoNumero());
        emissaoRespostaSicredi.setNossoNumeroRetornado(response.get("nossoNumero").asText());
        emissaoRespostaSicredi.setValorDocumento((String)Optional.ofNullable(response.get("valorDocumento")).map(JsonNode::asText).orElse(null));
        emissaoRespostaSicredi.setCodigoBarra(Optional.ofNullable(response.get("codigoBarra")).map(JsonNode::asText).orElse(Optional.ofNullable(response.get("codigoBarras")).map(JsonNode::asText).orElse(null)));
        emissaoRespostaSicredi.setResponse(jsonRetorno);
        emissaoRespostaSicredi.setBloqueto(boleto.getBloqueto());
        emissaoRespostaSicredi.setExercicioBloqueto(boleto.getExercicioBloqueto());
        emissaoRespostaSicredi.setTxid(boleto.getTxidPix());
        emissaoRespostaSicredi.setQrCode(boleto.getTextoQrCode());
        this.emissaoRespostaSicrediRepository.save((Object)emissaoRespostaSicredi);
    }

    private ChaveTransacaoSicredi generateChaveTransacao(Bloqueto boleto) {
        String urlLogin = this.getParametro(ParametroGeralEnum.REMESSA_URL_SICREDI_LOGIN);
        String chaveMaster = this.getParametro(ParametroGeralEnum.CHAVE_MASTER_SICREDI);
        HttpHeaders headers = new HttpHeaders();
        headers.set("token", chaveMaster);
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity objectHttpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            this.request = "POST to " + urlLogin + ": headers: " + this.mapper.writeValueAsString((Object)objectHttpEntity);
        }
        catch (Exception e) {
            log.error("Erro ao converter a requisi\u00e7\u00e3o em string", (Throwable)e);
        }
        JsonNode response = (JsonNode)this.restTemplate.exchange(urlLogin, HttpMethod.POST, objectHttpEntity, JsonNode.class, new Object[0]).getBody();
        String chaveTransacao = response.get("chaveTransacao").asText();
        String dataExpiracao = response.get("dataExpiracao").asText();
        return (ChaveTransacaoSicredi)new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            ChaveTransacaoSicredi chaveTransacaoSicredi = new ChaveTransacaoSicredi();
            chaveTransacaoSicredi.setChave(chaveTransacao);
            chaveTransacaoSicredi.setExpiracaoStr(dataExpiracao);
            chaveTransacaoSicredi.setExpiracao(LocalDateTime.parse(dataExpiracao, DateTimeFormatter.ISO_DATE_TIME));
            chaveTransacaoSicredi.setConvenio((Convenio)Optional.ofNullable(boleto.getModeloBloqueto().getConvenio()).orElse(null));
            return (ChaveTransacaoSicredi)this.chaveTransacaoSicrediRepository.save((Object)chaveTransacaoSicredi);
        });
    }

    private String getParametro(ParametroGeralEnum parametro) {
        String paramValueAsString = this.parametroGeralService.getParamValueAsString(parametro, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (StringUtils.isEmpty((String)paramValueAsString)) {
            throw new ParametroNaoEncontradoException(parametro.getDescricao());
        }
        return paramValueAsString;
    }

    private ChaveTransacaoSicredi getChaveTransacaoAtiva(Bloqueto boleto) {
        return this.chaveTransacaoSicrediRepository.findChaveTransacaoAtiva(LocalDateTime.now(), boleto.getModeloBloqueto().getConvenio());
    }

    private JsonNode converterErroResposta(String json) {
        try {
            return (JsonNode)this.mapper.readValue(json, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            ObjectNode jsonNodes = JsonNodeFactory.instance.objectNode();
            jsonNodes.put("mensagem", "Erro ao converter o erro em objeto na integra\u00e7\u00e3o do boleto sicredi.");
            jsonNodes.put("parametro", "");
            jsonNodes.put("codigo", "");
            return jsonNodes;
        }
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (Objects.isNull(boleto.getExercicioBloqueto())) {
            throw new EloValidationException("\u00c9 necess\u00e1rio o exerc\u00edcio do bloqueto para gerar o nosso n\u00famero.");
        }
        if (StringUtils.isBlank((String)boleto.getNossoNumero())) {
            String nossoNumero = this.gerarNossoNumero(boleto);
            String dv = this.gerarDVNossoNumero(boleto, nossoNumero);
            boleto.setNossoNumero(nossoNumero + dv);
            boleto.setDvNossoNumero(dv);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultadoAlteracaoBoletoDTO updateVencimentoBoleto(Bloqueto boleto, LocalDate vencimento) {
        ResultadoAlteracaoBoletoDTO resultadoAlteracaoBoletoDTO;
        ChaveTransacaoSicredi chaveTransacao = null;
        ErroRegistroSicredi erroRegistroSicredi = null;
        String stackTraceIntegracao = null;
        this.request = null;
        try {
            chaveTransacao = this.getChaveTransacao(boleto);
            AlteracaoVencimentoBoletoSicrediDTO dto = AlteracaoVencimentoBoletoSicrediDTO.from((Bloqueto)boleto, (LocalDate)vencimento);
            HttpHeaders headers = new HttpHeaders();
            headers.set("token", chaveTransacao.getChave());
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity httpEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            String urlComandoInstrucao = this.getParametro(ParametroGeralEnum.REMESSA_URL_SICREDI_COMANDO_INSTRUCAO);
            try {
                this.request = "POST to " + urlComandoInstrucao + ": " + this.mapper.writeValueAsString((Object)httpEntity);
            }
            catch (Exception e) {
                log.error("Erro ao converter a requisi\u00e7\u00e3o em string", (Throwable)e);
            }
            JsonNode response = (JsonNode)this.restTemplate.exchange(urlComandoInstrucao, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            ResultadoAlteracaoBoletoDTO resultadoDto = new ResultadoAlteracaoBoletoDTO();
            resultadoDto.setCodigo(response.get("codigo").asText());
            resultadoDto.setParametro(response.get("parametro").asText());
            resultadoDto.setMensagem(response.get("mensagem").asText());
            resultadoAlteracaoBoletoDTO = resultadoDto;
        }
        catch (RestException e) {
            try {
                JsonNode responseError = this.converterErroResposta(e.getMessage());
                String mensagem = e.getMessage();
                String codigo = null;
                String parametro = null;
                if (Objects.nonNull(responseError) && responseError.has("mensagem") && StringUtils.isNotEmpty((String)responseError.get("mensagem").asText())) {
                    mensagem = responseError.get("mensagem").asText();
                    parametro = responseError.get("parametro").asText();
                    codigo = StringUtils.substring((String)responseError.get("codigo").asText(), (int)0, (int)20);
                }
                erroRegistroSicredi = new ErroRegistroSicredi();
                erroRegistroSicredi.setNossoNumero(boleto.getNossoNumero());
                erroRegistroSicredi.setChaveTransacao((String)Optional.ofNullable(chaveTransacao).map(ChaveTransacaoSicredi::getChave).orElse(null));
                erroRegistroSicredi.setResponseBody(e.getMessage());
                erroRegistroSicredi.setMensagem(mensagem);
                erroRegistroSicredi.setCodigo(codigo);
                erroRegistroSicredi.setParametro(parametro);
                erroRegistroSicredi.setCodigoHttp(Integer.valueOf(e.getStatus().value()));
                stackTraceIntegracao = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                throw new BoletoException("Erro ao alterar o vencimento do boleto registrado SICREDI: " + codigo + " - " + mensagem + " - " + parametro);
                catch (Exception e2) {
                    erroRegistroSicredi = new ErroRegistroSicredi();
                    erroRegistroSicredi.setNossoNumero(boleto.getNossoNumero());
                    erroRegistroSicredi.setChaveTransacao((String)Optional.ofNullable(chaveTransacao).map(ChaveTransacaoSicredi::getChave).orElse(null));
                    erroRegistroSicredi.setResponseBody(e2.getMessage());
                    erroRegistroSicredi.setMensagem(e2.getMessage());
                    erroRegistroSicredi.setCodigo(null);
                    erroRegistroSicredi.setParametro(null);
                    stackTraceIntegracao = Arrays.stream(e2.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.saveErroSicredi(erroRegistroSicredi, boleto, stackTraceIntegracao);
                throw throwable;
            }
        }
        this.saveErroSicredi(erroRegistroSicredi, boleto, stackTraceIntegracao);
        return resultadoAlteracaoBoletoDTO;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CodigoBarrasDTO generateBoletoHibrido(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        CodigoBarrasDTO codigoBarrasDTO;
        ErroRegistroSicredi erroRegistroSicredi = null;
        String stackTraceIntegracao = null;
        try {
            Convenio convenio = boleto.getModeloBloqueto().getConvenio();
            String cooperativa = Optional.ofNullable(boleto.getModeloBloqueto()).map(ModeloBoleto::getConvenio).map(Convenio::getContaBancaria).map(ContaBancaria::getAgencia).map(Agencia::getAgencia).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel localizar a agencia"));
            String urlApi = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.BOLETO_SICREDI_API_PIX_URL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            String tokenApiKey = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.BOLETO_SICREDI_TOKEN, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            String acessToken = this.autenticacaoSicrediService.getAccessToken(urlApi, convenio.getNumeroConvenio(), cooperativa);
            String urlEmissao = urlApi.concat("/cobranca/boleto/v1/boletos");
            HttpHeaders headers = new HttpHeaders();
            headers.set("cooperativa", cooperativa);
            headers.set("posto", convenio.getCodigoPosto());
            headers.set("codigoBeneficiario", convenio.getNumeroConvenio());
            headers.set("Authorization", "Bearer ".concat(acessToken));
            headers.set("x-api-key", tokenApiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
            EmissaoBoletoPixSicrediDTO dto = EmissaoBoletoPixSicrediDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240);
            HttpEntity httpEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            try {
                this.request = "POST to " + urlEmissao + ": " + this.mapper.writeValueAsString((Object)httpEntity);
            }
            catch (Exception e) {
                log.error("Erro ao converter a requisi\u00e7\u00e3o em string", (Throwable)e);
            }
            JsonNode response = (JsonNode)this.restTemplate.exchange(urlEmissao, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            String nossoNumeroResponse = response.get("nossoNumero").asText();
            boleto.setNossoNumero(nossoNumeroResponse);
            boleto.setDvNossoNumero(nossoNumeroResponse.substring(nossoNumeroResponse.length() - 1));
            boleto.setTxidPix(response.get("txid").asText());
            boleto.setTextoQrCode(response.get("qrCode").asText());
            this.saveEmissaoResposta(response, boleto);
            CodigoBarrasDTO codigoBarrasDTO2 = new CodigoBarrasDTO();
            codigoBarrasDTO2.setCodigoBarras(response.get("codigoBarras").asText());
            codigoBarrasDTO2.setLinhaDigitavel(response.get("linhaDigitavel").asText());
            codigoBarrasDTO2.setCampo1(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)0, (int)10));
            codigoBarrasDTO2.setCampo2(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)10, (int)21));
            codigoBarrasDTO2.setCampo3(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)21, (int)32));
            codigoBarrasDTO2.setCampo4(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)32, (int)33));
            codigoBarrasDTO2.setCampo5(StringUtils.substring((String)codigoBarrasDTO2.getLinhaDigitavel(), (int)33, (int)47));
            codigoBarrasDTO2.setNossoNumero(boleto.getNossoNumero());
            codigoBarrasDTO2.setDvNossoNumero(boleto.getDvNossoNumero());
            codigoBarrasDTO2.generateCodigoBarrasFormatadoIntervalo2Of5();
            codigoBarrasDTO = codigoBarrasDTO2;
        }
        catch (RestException e) {
            try {
                JsonNode responseError = this.converterErroResposta(e.getMessage());
                String mensagem = e.getMessage();
                String requestId = null;
                if (Objects.nonNull(responseError) && responseError.has("mensagem") && StringUtils.isNotEmpty((String)responseError.get("mensagem").asText())) {
                    mensagem = responseError.get("mensagem").asText();
                }
                erroRegistroSicredi = new ErroRegistroSicredi();
                erroRegistroSicredi.setNossoNumero(boleto.getNossoNumero());
                erroRegistroSicredi.setResponseBody(e.getMessage());
                erroRegistroSicredi.setMensagem(mensagem);
                erroRegistroSicredi.setCodigo(requestId);
                erroRegistroSicredi.setCodigoHttp(Integer.valueOf(e.getStatus().value()));
                stackTraceIntegracao = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                throw new BoletoException("Erro ao enviar o boleto registrado para SICREDI: " + mensagem);
                catch (Exception e2) {
                    erroRegistroSicredi = new ErroRegistroSicredi();
                    erroRegistroSicredi.setNossoNumero(boleto.getNossoNumero());
                    erroRegistroSicredi.setResponseBody(e2.getMessage());
                    erroRegistroSicredi.setMensagem(e2.getMessage());
                    erroRegistroSicredi.setCodigo(null);
                    erroRegistroSicredi.setParametro(null);
                    stackTraceIntegracao = Arrays.stream(e2.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.saveErroSicredi(erroRegistroSicredi, boleto, stackTraceIntegracao);
                throw throwable;
            }
        }
        this.saveErroSicredi(erroRegistroSicredi, boleto, stackTraceIntegracao);
        return codigoBarrasDTO;
    }

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto boleto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            String urlRequest = String.format("%s/api/v2/cobv/%s", this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.PIX_SICREDI_URL, ModuloEnum.MODULO_TRIBUTARIO.getValue()), boleto.generateTxIdPix());
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoSicredi).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoSicredi).orElse(null);
            String accessToken = this.autenticacaoSicrediService.getAccessTokenWithCertificate(certificado, senhaCertificado);
            HttpHeaders headersRequest = new HttpHeaders();
            headersRequest.setContentType(MediaType.APPLICATION_JSON);
            headersRequest.set("Authorization", String.format("Bearer %s", accessToken));
            QrCodePixSicrediRequestDTO bodyRequest = QrCodePixSicrediRequestDTO.from((Bloqueto)boleto);
            HttpEntity request = new HttpEntity((Object)bodyRequest, (MultiValueMap)headersRequest);
            HttpMethod httpMethod = HttpMethod.PUT;
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            integracaoBoletoPixLog.setUrlRequest(urlRequest);
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(urlRequest, httpMethod, request, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
            resultDto.setTextoQrCode(response.get("pixCopiaECola").asText());
            resultDto.setTxid(response.get("txid").asText());
            IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
            return integracaoPixResponseDTO;
        }
        catch (RestException e) {
            QrCodePixSicrediErroDTO responseErrosDTO = this.getErroQrCodePixResposta(e.getMessage());
            integracaoBoletoPixLog.setDescricaoErro(responseErrosDTO.getErrosConcatenado());
            integracaoBoletoPixLog.setJsonResponse(e.getMessage());
            throw new RestException(e.getStatus(), responseErrosDTO.getErrosConcatenado(), (Throwable)e);
        }
        catch (Exception ex) {
            integracaoBoletoPixLog.setDescricaoErro(ex.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), (Throwable)ex);
        }
        finally {
            new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
                try {
                    return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            });
        }
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_SICREDI;
    }

    private QrCodePixSicrediErroDTO getErroQrCodePixResposta(String json) {
        try {
            return (QrCodePixSicrediErroDTO)this.mapper.readValue(json, QrCodePixSicrediErroDTO.class);
        }
        catch (JsonProcessingException e) {
            QrCodePixSicrediErroDTO erroDTO = new QrCodePixSicrediErroDTO();
            erroDTO.setTitle("Erro ao ler o json do retorno com erro. " + e.getMessage());
            return erroDTO;
        }
    }

    @Generated
    public IntegracaoBoletoSicrediService(ParametroGeralService parametroGeralService, ChaveTransacaoSicrediRepository chaveTransacaoSicrediRepository, RestTemplate restTemplate, ObjectMapper mapper, ParametroCNAB240Repository parametroCNAB240Repository, ErroRegistroSicrediRepository erroRegistroSicrediRepository, EmissaoRespostaSicrediRepository emissaoRespostaSicrediRepository, PlatformTransactionManager transactionManager, BancoRepository bancoRepository, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, EntidadeRepository entidadeRepository, SequenceGeneratorRepository sequenceGeneratorRepository, AutenticacaoSicrediService autenticacaoSicrediService, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, ParametroPixRepository parametroPixRepository) {
        this.parametroGeralService = parametroGeralService;
        this.chaveTransacaoSicrediRepository = chaveTransacaoSicrediRepository;
        this.restTemplate = restTemplate;
        this.mapper = mapper;
        this.parametroCNAB240Repository = parametroCNAB240Repository;
        this.erroRegistroSicrediRepository = erroRegistroSicrediRepository;
        this.emissaoRespostaSicrediRepository = emissaoRespostaSicrediRepository;
        this.transactionManager = transactionManager;
        this.bancoRepository = bancoRepository;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.entidadeRepository = entidadeRepository;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.autenticacaoSicrediService = autenticacaoSicrediService;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.parametroPixRepository = parametroPixRepository;
    }
}

