/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.itau;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoDetalhe;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoPixPagoLog;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.itau.ItauPixPago;
import br.com.elotech.tributos.dto.pagamento.ImportacaoPixPagoResultadoDTO;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoPixPagoLogRepository;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.BloquetoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.TipoMensagemService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.integracaoboleto.itau.ItauUtilsService;
import br.com.elotech.tributos.service.integracaoboleto.sicoob.PixPagoService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ItauPixPagoService
implements PixPagoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ItauPixPagoService.class);
    private static final DateTimeFormatter FORMATO_NOME_ARQUIVO = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private final ContextService contextService;
    private final ObjectMapper objectMapper;
    private final TipoMensagemService tipoMensagemService;
    private final BloquetoService bloquetoService;
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final PagamentoLoteService pagamentoLoteService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final ParametroPixRepository parametroPixRepository;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository;
    private final DebitoParcelaService debitoParcelaService;
    private final ItauUtilsService itauUtilsService;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ConfigurableEnvironment environment;

    public Boolean accept(Convenio convenio) {
        return Banco.CODIGO_BANCO_ITAU.equals(convenio.getBanco().getId());
    }

    public ImportacaoPixPagoResultadoDTO importarPixPago(Convenio convenio, LocalDate dataReferencia) {
        throw new EloValidationException("Integra\u00e7\u00e3o para receber pix pagos para o banco Itau n\u00e3o implementada.");
    }

    public IntegracaoPixPagoLog processarPixPagosWebHook(JsonNode pixPagos, Convenio convenio, IntegracaoPixPagoLog log) {
        if (!Boolean.TRUE.equals(convenio.getUtilizaPix()) || !Banco.CODIGO_BANCO_ITAU.equals(convenio.getBanco().getId())) {
            throw new EloValidationException(String.format("Banco %s com conv\u00eanio %d n\u00e3o possui PIX", convenio.getBanco().getDescricao(), convenio.getId()));
        }
        Long entidade = this.contextService.getEntidadePrincipal();
        List itauPixPagos = ItauPixPago.from((JsonNode)pixPagos, (ObjectMapper)this.objectMapper);
        LocalDate dataReferencia = this.getDataReferencia(itauPixPagos);
        log.setDataReferencia(dataReferencia);
        log.setQuantidadeRegistros(Integer.valueOf(itauPixPagos.size()));
        if (Boolean.TRUE.equals(convenio.getCriarLotePgtPix())) {
            this.processaLotePagamentoPix(convenio, log, itauPixPagos, dataReferencia, entidade);
            return log;
        }
        this.processarPixPago(itauPixPagos, log);
        return log;
    }

    public void togglePixBoletoPagoWebhook(Convenio convenio) {
        boolean status;
        ParametroPix parametroPix = this.getParametroPixByEntidade(convenio.getEntidade());
        byte[] certificado = this.getCertificadoByParametroPix(parametroPix);
        String senhaCertificado = this.getSenhaCertificadoByParametroPix(parametroPix);
        boolean bl = status = convenio.getWebhookPixAtivo() == false;
        if (status) {
            this.activatePixWebhook(convenio, certificado, senhaCertificado);
        } else {
            this.deactivatePixWebhook(convenio, certificado, senhaCertificado);
        }
    }

    private byte[] getCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
    }

    private String getSenhaCertificadoByParametroPix(ParametroPix parametroPix) {
        return Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
    }

    private ParametroPix getParametroPixByEntidade(Long entidade) {
        return this.parametroPixRepository.getByEntidade(entidade);
    }

    private void activatePixWebhook(Convenio convenio, byte[] certificado, String senhaCertificado) {
        try {
            String accessToken = this.itauUtilsService.getAccessToken(certificado, senhaCertificado, "ActivateWebhook", "activateWebhook");
            String url = String.format("%s/webhook/%s", this.itauUtilsService.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), convenio.getChavePix());
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("webhookUrl", String.format("%s/api/integracao-boleto/%d/webhook", AmbienteUtils.getCurrentURL((ConfigurableEnvironment)this.environment), convenio.getId()));
            HttpEntity headers = this.itauUtilsService.createHeaders(accessToken, body, "ActivateWebHook", "");
            RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(url, HttpMethod.PUT, headers, JsonNode.class, new Object[0]);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao ativar webhook do pix, %s", e.getMessage()));
        }
    }

    private void deactivatePixWebhook(Convenio convenio, byte[] certificado, String senhaCertificado) {
        try {
            String accessToken = this.itauUtilsService.getAccessToken(certificado, senhaCertificado, "ActivateWebhook", "activateWebhook");
            String url = String.format("%s/webhook/%s", this.itauUtilsService.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), convenio.getChavePix());
            HttpEntity headers = this.itauUtilsService.createHeaders(accessToken, null, "ActivateWebHook", "");
            RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(url, HttpMethod.DELETE, headers, JsonNode.class, new Object[0]);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao ativar webhook do pix, %s", e.getMessage()));
        }
    }

    private LocalDate getDataReferencia(List<ItauPixPago> itauPixPagos) {
        return itauPixPagos.stream().map(ItauPixPago::getHorario).filter(Objects::nonNull).map(LocalDateTime::toLocalDate).min(Comparator.naturalOrder()).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel obter a data de refer\u00eancia dos pix pagos."));
    }

    private void processaLotePagamentoPix(Convenio convenio, IntegracaoPixPagoLog log, List<ItauPixPago> itauPixPagos, LocalDate dataReferencia, Long entidade) {
        try {
            List baixaAutomaticaDetalhes = this.processarPixPagoLote(itauPixPagos, log);
            if (!baixaAutomaticaDetalhes.isEmpty()) {
                PagamentoLote lote = this.getPagamentoLote(convenio, dataReferencia, entidade, new ImportacaoPixPagoResultadoDTO());
                AtomicLong sequence = new AtomicLong(this.baixaAutomaticaDetalheService.getUltimaSequenciaLote(lote.getId()));
                this.salvarItensGerados(baixaAutomaticaDetalhes, lote, sequence);
                log.setQuantidadeBaixasGeradas(Integer.valueOf(baixaAutomaticaDetalhes.size()));
            }
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
    }

    private void processarPixPago(List<ItauPixPago> itauPixPago, IntegracaoPixPagoLog log) {
        try {
            itauPixPago.forEach(pix -> {
                IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe);
                if (Objects.isNull(bloqueto)) {
                    return;
                }
                bloqueto.getDebitos().stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).distinct().forEach(arg_0 -> ((DebitoParcelaService)this.debitoParcelaService).pagarParcelaWebHookPix(arg_0));
                log.getDetalhes().add(detalhe);
            });
        }
        catch (Exception e) {
            String mensagemErro = String.format("%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
            log.setErro(mensagemErro);
            throw e;
        }
        finally {
            this.saveLog(log);
        }
    }

    private List<BaixaAutomaticaDetalhe> processarPixPagoLote(List<ItauPixPago> itauPixPago, IntegracaoPixPagoLog log) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.IMPORTADO);
        return itauPixPago.stream().map(pix -> {
            IntegracaoPixPagoDetalhe detalhe = new IntegracaoPixPagoDetalhe();
            log.getDetalhes().add(detalhe);
            try {
                Bloqueto bloqueto = this.getBloqueto(pix, detalhe);
                if (Objects.isNull(bloqueto)) {
                    return null;
                }
                if (this.baixaAutomaticaDetalheService.existsByBoleto(bloqueto)) {
                    detalhe.setObservacao("Boleto j\u00e1 importado");
                    return null;
                }
                detalhe.setObservacao("Boleto importado com sucesso");
                return ItauPixPagoService.getBaixaAutomaticaDetalhe((ItauPixPago)pix, (Bloqueto)bloqueto, (TipoMensagem)tipoMensagem);
            }
            catch (Exception ex) {
                detalhe.setMensagemErro(ex.toString());
                ItauPixPagoService.log.error("Ocorreu um erro ao processar pix pagos ", (Object)ex.getMessage(), (Object)ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Bloqueto getBloqueto(ItauPixPago pix, IntegracaoPixPagoDetalhe detalhe) {
        detalhe.setE2eid(pix.getEndToEndId());
        if (StringUtils.isNotBlank((String)pix.getTxid())) {
            detalhe.setTxid(pix.getTxid());
            detalhe.setBuscaPorE2E(Boolean.FALSE);
        } else {
            ItauPixPago pagamentoByE2E = this.getPagamentoByE2E(pix.getEndToEndId());
            detalhe.setTxid(pagamentoByE2E.getTxid());
            detalhe.setBuscaPorE2E(Boolean.TRUE);
        }
        if (StringUtils.isBlank((String)detalhe.getTxid())) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o Txid do pagamento Pix");
            return null;
        }
        Optional bloqueto = this.bloquetoService.findByTxid(detalhe.getTxid());
        if (bloqueto.isEmpty()) {
            detalhe.setObservacao("N\u00e3o foi possivel encontrar o boleto com o Txid informado");
            return null;
        }
        detalhe.setBoleto(((Bloqueto)bloqueto.get()).getBloqueto());
        detalhe.setExercicioboleto(((Bloqueto)bloqueto.get()).getExercicioBloqueto());
        detalhe.setEntidade(((Bloqueto)bloqueto.get()).getEntidade());
        return (Bloqueto)bloqueto.get();
    }

    private static BaixaAutomaticaDetalhe getBaixaAutomaticaDetalhe(ItauPixPago pix, Bloqueto bloqueto, TipoMensagem tipoMensagem) {
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = new BaixaAutomaticaDetalhe();
        baixaAutomaticaDetalhe.setBoleto(bloqueto);
        baixaAutomaticaDetalhe.setNossoNumero(bloqueto.getNossoNumero());
        baixaAutomaticaDetalhe.setSituacao(ClassificacaoTipoMensagem.IMPORTADO);
        baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.IMPORTADO.getDescricao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setDataVencimento(bloqueto.getDataVencimento());
        baixaAutomaticaDetalhe.setDataCreditoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDataPagamentoArquivo(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaEmValor(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDiferencaMaxima(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setAlterado(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setDescontoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setCreditoConcedido(Boolean.valueOf(false));
        baixaAutomaticaDetalhe.setValor(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPago(pix.getValor());
        baixaAutomaticaDetalhe.setValorPagoPrincipal(pix.getValor());
        baixaAutomaticaDetalhe.setValorPagoJuros(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setValorPagoMulta(BigDecimal.ZERO);
        baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.NENHUMA_OPERACAO);
        return baixaAutomaticaDetalhe;
    }

    private PagamentoLote getPagamentoLote(Convenio convenio, LocalDate dataReferencia, Long entidade, ImportacaoPixPagoResultadoDTO resultado) {
        this.validaMovimentacao(entidade, dataReferencia);
        Optional loteJaExistente = this.pagamentoLoteService.findAbertoByConvenioAndData(convenio, dataReferencia);
        resultado.setLoteNovo(Boolean.valueOf(loteJaExistente.isEmpty()));
        return loteJaExistente.orElseGet(() -> this.createPagamentoLote(convenio, entidade, dataReferencia));
    }

    private void validaMovimentacao(Long entidade, LocalDate dataReferencia) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataReferencia);
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }

    private PagamentoLote createPagamentoLote(Convenio convenio, Long entidade, LocalDate dataReferencia) {
        Long exercicio = this.contextService.getExercicioAtual();
        PagamentoLoteId id = new PagamentoLoteId();
        id.setEntidade(entidade);
        id.setExercicio(exercicio);
        PagamentoLote pagamentoLote = new PagamentoLote();
        pagamentoLote.setId(id);
        pagamentoLote.setDataLote(LocalDate.now());
        pagamentoLote.setDataMovimento(dataReferencia);
        pagamentoLote.setDataCredito(dataReferencia);
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        pagamentoLote.setTipo(TipoPagamentoLote.PIX);
        pagamentoLote.setConvenio(convenio);
        pagamentoLote.setContaBancaria(convenio.getContaBancaria());
        pagamentoLote.setBanco(convenio.getBanco());
        pagamentoLote.setArquivoRetorno(Boolean.FALSE);
        pagamentoLote.setLoteManual(Boolean.FALSE);
        pagamentoLote.setNumeroBaixas(Long.valueOf(0L));
        pagamentoLote.setTipoArquivo(TipoArquivoRetornoPagamento.RETORNO_PIX);
        pagamentoLote.setObservacao("Lote gerado pela importa\u00e7\u00e3o de pix");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime dataReferenciaComHoraAtual = dataReferencia.atTime(now.getHour(), now.getMinute(), now.getSecond());
        pagamentoLote.setNomeArquivo(String.format("importacao_pix_%d_%s", convenio.getConvenio(), FORMATO_NOME_ARQUIVO.format(dataReferenciaComHoraAtual)));
        return (PagamentoLote)this.pagamentoLoteService.save((EloEntity)pagamentoLote, null);
    }

    private void salvarItensGerados(List<BaixaAutomaticaDetalhe> itensGerados, PagamentoLote lote, AtomicLong sequencia) {
        itensGerados.forEach(baixaAutomaticaDetalhe -> {
            BaixaAutomaticaDetalheId id = new BaixaAutomaticaDetalheId();
            id.setSequenciaArquivo(Long.valueOf(sequencia.incrementAndGet()));
            id.setLote(lote.getId().getLote());
            id.setEntidade(lote.getId().getEntidade());
            id.setExercicio(lote.getId().getExercicio());
            baixaAutomaticaDetalhe.setId(id);
            baixaAutomaticaDetalhe.setPagamentoLote(lote);
            baixaAutomaticaDetalhe.setDataCredito(lote.getDataCredito());
            baixaAutomaticaDetalhe.setDataPagamento(lote.getDataMovimento());
            baixaAutomaticaDetalhe.setContaBancaria(lote.getContaBancaria());
            baixaAutomaticaDetalhe.setConvenio(lote.getConvenio());
            baixaAutomaticaDetalhe.setBanco(lote.getBanco());
            this.baixaAutomaticaDetalheService.save((EloEntity)baixaAutomaticaDetalhe, null);
        });
        Long numeroBaixasAtual = Optional.ofNullable(lote.getNumeroBaixas()).orElse(0L);
        lote.setNumeroBaixas(Long.valueOf(numeroBaixasAtual + (long)itensGerados.size()));
    }

    private void saveLog(IntegracaoPixPagoLog integracaoPixPagoLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoPixPagoLog)this.integracaoPixPagoLogRepository.save((Object)integracaoPixPagoLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    private ItauPixPago getPagamentoByE2E(String endToEndId) throws RuntimeException {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.CONSULTA_PIX_E2E);
        try {
            integracaoBoletoPixLog.setCodigoE2E(endToEndId);
            String url = String.format("%s/pix/%s", this.itauUtilsService.getParametro(ParametroGeralEnum.BOLETO_ITAU_API_PIX_URL), endToEndId);
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(this.contextService.getEntidadePrincipal());
            byte[] certificado = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoItau).orElse(null);
            String senhaCertificado = Optional.ofNullable(parametroPix).map(ParametroPix::getSenhaCertificadoItau).orElse(null);
            String accessToken = this.itauUtilsService.getAccessToken(certificado, senhaCertificado, "E2E", endToEndId);
            HttpEntity requestEntity = this.itauUtilsService.createHeaders(accessToken, null, "E2E", endToEndId);
            HttpMethod httpMethod = HttpMethod.GET;
            integracaoBoletoPixLog.setJsonRequest(this.objectMapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(httpMethod);
            ItauPixPago itauPixPago = (ItauPixPago)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(url, httpMethod, requestEntity, ItauPixPago.class, new Object[0]).getBody();
            return itauPixPago;
        }
        catch (RestException e) {
            throw new RestException(e.getStatus(), e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    @Generated
    public ItauPixPagoService(ContextService contextService, ObjectMapper objectMapper, TipoMensagemService tipoMensagemService, BloquetoService bloquetoService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, PagamentoLoteService pagamentoLoteService, ValidaDataMovimentacaoService validaDataMovimentacaoService, ParametroPixRepository parametroPixRepository, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, IntegracaoPixPagoLogRepository integracaoPixPagoLogRepository, DebitoParcelaService debitoParcelaService, ItauUtilsService itauUtilsService, PlatformTransactionManager transactionManager, ConfigurableEnvironment environment) {
        this.contextService = contextService;
        this.objectMapper = objectMapper;
        this.tipoMensagemService = tipoMensagemService;
        this.bloquetoService = bloquetoService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.parametroPixRepository = parametroPixRepository;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.integracaoPixPagoLogRepository = integracaoPixPagoLogRepository;
        this.debitoParcelaService = debitoParcelaService;
        this.itauUtilsService = itauUtilsService;
        this.transactionManager = transactionManager;
        this.environment = environment;
    }
}

