/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cancelamento;

import br.com.elotech.core.common.dto.MailResultInfo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.core.service.support.ReadOnlyService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.LivroParcelaTributo;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDeducao;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoItem;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebitoPk;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoParcelasFormDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.repository.cancelamento.CancelamentoDebitoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DebitoTributoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.ValidaCancelamentoDebitoService;
import br.com.elotech.tributos.util.AmbienteUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CancelamentoDebitoService
extends ReadOnlyService<CancelamentoDebito, CancelamentoDebitoPk> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CancelamentoDebitoService.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelamentoDebitoService.class);
    private final CancelamentoDebitoRepository cancelamentoDebitoRepository;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoParcelaTributoService debitoParcelasTributoService;
    private final DebitoTributoService debitoTributoService;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final ValidaCancelamentoDebitoService validaCancelamentoDebitoService;
    private final CadastroGeralService cadastroGeralService;
    private final MailService mailService;
    private final ConfigurableEnvironment configurableEnvironment;

    @Transactional
    public CancelamentoDebito cancelamentoDebitoPorParcela(CancelamentoParcelasFormDTO form) {
        CancelamentoTributosFormDTO cancelamentoTributosFormDTO = CancelamentoTributosFormDTO.from((CancelamentoParcelasFormDTO)form);
        form.getParcelas().forEach(parcelaForm -> this.debitoParcelaService.findByDebitoParcela(parcelaForm.getEntidade(), parcelaForm.getExercicio(), parcelaForm.getTipoCadastro(), parcelaForm.getCadastroGeral(), parcelaForm.getDivida(), parcelaForm.getSubDivida(), parcelaForm.getParcela()).ifPresent(debitoParcela -> debitoParcela.getTributosValorMaiorQueZero().forEach(tributo -> cancelamentoTributosFormDTO.getParcelas().add(CancelamentoDebitoTributoDTO.from((DebitoParcelaTributo)tributo)))));
        return this.cancelamentoDebitoPorTributo(cancelamentoTributosFormDTO);
    }

    private void updateValoresDebito(CancelamentoDebitoTributoDTO tributo, DebitoParcelaTributo debitoParcelaTributo) {
        this.updateDebitoReceita(tributo);
        this.updateDebitoParcelaTributo(tributo, debitoParcelaTributo);
    }

    private void updateDebitoReceita(CancelamentoDebitoTributoDTO tributo) {
        DebitoTributo debitoTributo = (DebitoTributo)this.debitoTributoService.findOne((Serializable)tributo.toEntityDebitoTributo().getId());
        debitoTributo.setValorRenuncia(debitoTributo.getValorRenuncia().add(tributo.getValorCancelamento()));
        this.debitoTributoService.save((EloEntity)debitoTributo, null);
        LOGGER.info("D\u00e9bito tributo com valor ren\u00fancia, atualizado. {}", (Object)debitoTributo);
    }

    private void updateDebitoParcelaTributo(CancelamentoDebitoTributoDTO tributo, DebitoParcelaTributo debitoParcelaTributo) {
        debitoParcelaTributo.setValor(debitoParcelaTributo.getValor().subtract(tributo.getValorCancelamento()));
        this.debitoParcelasTributoService.save((EloEntity)debitoParcelaTributo, null);
        LOGGER.info("D\u00e9bito parcela com situa\u00e7\u00e3o Cancelado salvo. {}", (Object)debitoParcelaTributo);
    }

    @Transactional
    public CancelamentoDebito cancelamentoDebitoPorTributo(CancelamentoTributosFormDTO form) {
        form.setUsuario(SecurityUtils.getUserAise());
        CancelamentoDebito cancelamentoDebito = form.toEntity();
        this.validaCancelamentoDebitoService.validaCancelamento(form);
        this.validaMotivoDeducao(form);
        form.getParcelas().stream().map(tributo -> {
            DebitoParcelaTributo debitoParcelaTributo = (DebitoParcelaTributo)this.debitoParcelasTributoService.findOne((Serializable)tributo.getId());
            CancelamentoDebitoItem cancelamentoDebitoItem = tributo.toEntity(cancelamentoDebito, debitoParcelaTributo);
            cancelamentoDebitoItem.setValor(tributo.getValorCancelamento());
            if (form.getPorTributo().booleanValue()) {
                this.updateValoresDebito(tributo, debitoParcelaTributo);
            }
            return cancelamentoDebitoItem;
        }).forEach(cancelamentoDebito.getItens()::add);
        Map debitoParcelas = form.getItensCanceladosByParcelas();
        debitoParcelas.forEach((debitoParcelaId, cancelamentosDebitoTributoDTO) -> this.debitoParcelaService.findById(debitoParcelaId).ifPresent(debitoParcela -> {
            if (!form.getPorTributo().booleanValue() || debitoParcela.getValorTotal().compareTo(BigDecimal.ZERO) == 0) {
                this.updateSituacaoDebito(debitoParcela, form.getTipoDeducao());
            }
        }));
        this.cancelamentoDebitoRepository.save((Object)cancelamentoDebito);
        this.addObservacaoCancelamento(cancelamentoDebito, form);
        if (Boolean.TRUE.equals(form.getEnviarEmail())) {
            if (form.getMensagemEmail().isBlank()) {
                log.info("E-mail(s) de cancelamento de d\u00e9bito n\u00e3o foi enviado(s) pois o conte\u00fado est\u00e1 vazio! {} {}", (Object)form.getTipoDeducao(), (Object)form.getDataCancelamento());
                return cancelamentoDebito;
            }
            this.enviarEmailDeCancelamentoDeDebito(form.getParcelas(), form.getMensagemEmail());
        }
        return cancelamentoDebito;
    }

    public void povoarMapComCadastrosUnicos(Map<String, Optional<CadastroGeral>> cadastros, List<CancelamentoDebitoTributoDTO> parcelas) {
        parcelas.forEach(parcela -> {
            if (Objects.isNull(cadastros.get(parcela.getTipoCadastro().toString() + "-" + parcela.getCadastroGeral().toString()))) {
                cadastros.put(parcela.getTipoCadastro().toString() + "-" + parcela.getCadastroGeral().toString(), this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)parcela.getTipoCadastro()), parcela.getCadastroGeral()));
            }
        });
    }

    private String getSubjectMessage() {
        Object subjectMessage = "Aviso de Cancelamento de D\u00e9bito";
        if (!AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("oxy")) {
            subjectMessage = (String)subjectMessage + " - TESTE";
        }
        return subjectMessage;
    }

    @Async
    public void enviarEmailDeCancelamentoDeDebito(List<CancelamentoDebitoTributoDTO> parcelas, String mensagemEmail) {
        HashMap<String, Optional> cadastros = new HashMap<String, Optional>();
        this.povoarMapComCadastrosUnicos(cadastros, parcelas);
        cadastros.forEach((s, optionalCadastroGeral) -> {
            try {
                if (optionalCadastroGeral.isEmpty()) {
                    log.info("Cadastro n\u00e3o encontrado ao tentar realizar envio de email de cancelamento de d\u00e9bito {} ", s);
                    return;
                }
                CadastroGeral cadastroGeral = (CadastroGeral)optionalCadastroGeral.get();
                ContatoPessoa contatoPrincipal = cadastroGeral.getPessoa().getContatoPrincipal();
                if (Objects.isNull(contatoPrincipal)) {
                    log.info("Contato principal n\u00e3o encontrado ao tentar realizar envio de email de cancelamento de d\u00e9bito {} ", s);
                    return;
                }
                if (Objects.isNull(contatoPrincipal.getEmail()) || contatoPrincipal.getEmail().isBlank()) {
                    log.info("E-mail n\u00e3o encontrado ao tentar realizar envio de email de cancelamento de d\u00e9bito {} ", s);
                    return;
                }
                MailParams params = MailParams.builder().to(contatoPrincipal.getEmail()).subject(this.getSubjectMessage()).content(mensagemEmail).multipart(false).html(false).build();
                Future emailResultInfo = this.mailService.sendEmail(params);
                if (((MailResultInfo)emailResultInfo.get()).isSuccess()) {
                    log.info("E-mail enviado com sucesso {} ", s);
                }
            }
            catch (Exception e) {
                log.error("Falha ao enviar e-mail {} {} ", s, (Object)e.getMessage());
            }
        });
    }

    private void updateSituacaoDebito(DebitoParcela debitoParcela, TipoDeducao tipoDeducao) {
        TipoEventoSituacaoParcelaEnum eventoBaixa = TipoDeducaoEnum.fromValue((Long)tipoDeducao.getId()).getEventoBaixa();
        debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(eventoBaixa, debitoParcela.getSituacaoDebito()));
        this.debitoParcelaService.save((EloEntity)debitoParcela, null);
    }

    private void addObservacaoCancelamento(CancelamentoDebito cancelamentoDebito, CancelamentoTributosFormDTO form) {
        Map debitos = CancelamentoDebitoTributoDTO.getItensCanceladosByDebitos((List)form.getParcelas());
        debitos.forEach((debitoIdDTO, listaCancelamentoDebitoTributoDTO) -> {
            String parcelas = listaCancelamentoDebitoTributoDTO.stream().map(CancelamentoDebitoTributoDTO::getParcela).distinct().sorted().map(Object::toString).collect(Collectors.joining(","));
            this.addObservacaoCancelamento(debitoIdDTO, cancelamentoDebito.getId().getId(), cancelamentoDebito.getId().getExercicio(), parcelas);
        });
    }

    private void addObservacaoCancelamento(DebitoIdDTO debitoIdDTO, Long idCancelamento, Long exercicioCancelamento, String parcelas) {
        this.debitoObservacaoService.save(debitoIdDTO, String.format("Cancelamento de d\u00e9bito n\u00famero %d/%d. Parcela(s) %s.", idCancelamento, exercicioCancelamento, parcelas));
    }

    @Transactional
    public CancelamentoDebito cancelamentoDebitoEnglobado(LivroParcelaTributo livroParcelaTributo, DebitoIdDTO idDebito, MotivoDeducao motivoDeducao, LocalDate dataCancelamento) {
        CancelamentoDebitoTributoDTO cancelamentoTributoDTO = new CancelamentoDebitoTributoDTO();
        cancelamentoTributoDTO.setId(livroParcelaTributo.getId().getDebitoParcelaTributo().getId());
        cancelamentoTributoDTO.setIdDebito(idDebito.getIdDebito());
        cancelamentoTributoDTO.setEntidade(idDebito.getEntidade());
        cancelamentoTributoDTO.setExercicio(Long.valueOf(dataCancelamento.getYear()));
        cancelamentoTributoDTO.setTipoCadastro(idDebito.getTipoCadastro());
        cancelamentoTributoDTO.setCadastroGeral(idDebito.getCadastroGeral());
        cancelamentoTributoDTO.setDivida(idDebito.getDivida());
        cancelamentoTributoDTO.setSubDivida(idDebito.getSubDivida());
        cancelamentoTributoDTO.setParcela(Long.valueOf(1L));
        cancelamentoTributoDTO.setTributo(livroParcelaTributo.getId().getDebitoParcelaTributo().getTributo());
        cancelamentoTributoDTO.setValorCancelamento(Optional.ofNullable(livroParcelaTributo.getId().getLivroRegistro()).map(LivroRegistro::getValorOriginal).orElse(livroParcelaTributo.getValor()));
        cancelamentoTributoDTO.setSituacaoLegal(SituacaoLegal.DIVIDA_ATIVA);
        CancelamentoTributosFormDTO form = new CancelamentoTributosFormDTO();
        form.setEntidade(idDebito.getEntidade());
        form.setExercicio(Long.valueOf(dataCancelamento.getYear()));
        form.setUsuario(SecurityUtils.getUserAise());
        form.setDataCancelamento(dataCancelamento);
        form.setMotivoCancelamento(motivoDeducao);
        form.setSituacaoLegal(Long.valueOf(SituacaoLegal.DIVIDA_ATIVA.getValue().longValue()));
        form.setTipoDeducao(motivoDeducao.getTipoDeducao());
        form.getParcelas().add(cancelamentoTributoDTO);
        form.setPorTributo(Boolean.TRUE);
        CancelamentoDebito cancelamentoDebito = form.toEntity();
        this.validaCancelamentoDebitoService.validaCancelamentoSemDividaAtiva(form);
        this.debitoParcelasTributoService.findByDebitoParcelaDebitoIdAndTributo(cancelamentoTributoDTO.getIdDebito(), cancelamentoTributoDTO.getTributo()).stream().map(debitoParcelaTributo -> (DebitoParcelaTributo)this.debitoParcelasTributoService.findOne((Serializable)debitoParcelaTributo.getId())).map(debitoParcelaTributo -> {
            CancelamentoDebitoItem cancelamentoDebitoItem = cancelamentoTributoDTO.toEntity(cancelamentoDebito, debitoParcelaTributo);
            cancelamentoDebitoItem.setValor(cancelamentoTributoDTO.getValorCancelamento());
            cancelamentoDebitoItem.setMotivoDesconto(motivoDeducao);
            return cancelamentoDebitoItem;
        }).forEach(cancelamentoDebito.getItens()::add);
        CancelamentoDebito cancelamentoDebitoSaved = (CancelamentoDebito)this.cancelamentoDebitoRepository.save((Object)cancelamentoDebito);
        this.addObservacaoCancelamento(idDebito, cancelamentoDebito.getId().getId(), cancelamentoDebito.getId().getExercicio(), cancelamentoTributoDTO.getParcela().toString());
        return cancelamentoDebitoSaved;
    }

    private void validaMotivoDeducao(CancelamentoTributosFormDTO dto) {
        if (dto.getExercicio() < (long)LocalDate.now().getYear() && dto.getTipoDeducao().getId().equals(TipoDeducaoEnum.ESTORNO.getValue())) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel estornar d\u00e9bitos de exerc\u00edcios anteriores!");
        }
    }

    @Generated
    public CancelamentoDebitoService(CancelamentoDebitoRepository cancelamentoDebitoRepository, SituacaoParcelaService situacaoParcelaService, DebitoParcelaTributoService debitoParcelasTributoService, DebitoTributoService debitoTributoService, DebitoParcelaService debitoParcelaService, DebitoObservacaoService debitoObservacaoService, ValidaCancelamentoDebitoService validaCancelamentoDebitoService, CadastroGeralService cadastroGeralService, MailService mailService, ConfigurableEnvironment configurableEnvironment) {
        this.cancelamentoDebitoRepository = cancelamentoDebitoRepository;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelasTributoService = debitoParcelasTributoService;
        this.debitoTributoService = debitoTributoService;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.validaCancelamentoDebitoService = validaCancelamentoDebitoService;
        this.cadastroGeralService = cadastroGeralService;
        this.mailService = mailService;
        this.configurableEnvironment = configurableEnvironment;
    }
}

