/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.comunicado;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.TipoNotificacaoComunicado;
import br.com.elotech.tributos.dto.ComunicadoServiceDTO;
import br.com.elotech.tributos.enums.OrigemComunicado;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.TipoNotificacaoComunicadoService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ComunicadoByConsultaDebitoJobStarter {
    private final ObjectMapper objectMapper;
    private final ContextService contextService;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    @Qualifier(value="comunicadoDebitoBatchJob")
    private final Job comunicadoDebitoBatchJob;
    private final ComunicadoRepository comunicadoRepository;
    private final TipoNotificacaoComunicadoService tipoNotificacaoComunicadoService;

    public ComunicadoByConsultaDebitoJobStarter(ObjectMapper objectMapper, ContextService contextService, JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="comunicadoDebitoBatchJob") Job comunicadoDebitoBatchJob, ComunicadoRepository comunicadoRepository, TipoNotificacaoComunicadoService tipoNotificacaoComunicadoService) {
        this.objectMapper = objectMapper;
        this.contextService = contextService;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.comunicadoDebitoBatchJob = comunicadoDebitoBatchJob;
        this.comunicadoRepository = comunicadoRepository;
        this.tipoNotificacaoComunicadoService = tipoNotificacaoComunicadoService;
    }

    public JobExecution startJob(ComunicadoServiceDTO comunicadoServiceDTO) throws Exception {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.COMUNICADO_DEBITO.getTipo()).stream().anyMatch(job -> comunicadoServiceDTO.getIdentificador().get("idConsultaDebito").equals(Objects.requireNonNull(job.getJobParameters().getLong("idConsultaDebito"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe uma job com estes par\u00e2metros.");
        }
        TipoNotificacaoComunicado tipoNotificacao = this.tipoNotificacaoComunicadoService.findById((Serializable)comunicadoServiceDTO.getTipoNotificacao().getId()).orElse(null);
        ComunicadoId id = new ComunicadoId();
        id.setEntidade(this.contextService.getEntidadePrincipal());
        id.setExercicio(this.contextService.getExercicioAtual());
        Comunicado comunicado = new Comunicado();
        comunicado.setId(id);
        if (Objects.nonNull(tipoNotificacao)) {
            comunicado.setTipoNotificacao(tipoNotificacao);
            comunicado.setRelatorio(tipoNotificacao.getRelatorio());
        }
        comunicado.setDescricao(comunicadoServiceDTO.getDescricao());
        comunicado.setDataValidade(comunicadoServiceDTO.getDataValidade());
        comunicado.setDataGeracao(comunicadoServiceDTO.getDataGeracao());
        comunicado.setUsuario(comunicadoServiceDTO.getUsuario());
        comunicado.setOrigem(OrigemComunicado.CONSULTA_DEBITO);
        comunicado = (Comunicado)this.comunicadoRepository.save((Object)comunicado);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idConsultaDebito", Long.valueOf(Long.parseLong((String)comunicadoServiceDTO.getIdentificador().get("id"))));
        jobParametersBuilder.addLong("idComunicado", comunicado.getId().getIdComunicado());
        jobParametersBuilder.addDate("dataReferencia", new Date());
        jobParametersBuilder.addLong("entidade", id.getEntidade());
        jobParametersBuilder.addLong("exercicio", (Long)comunicadoServiceDTO.getIdentificador().get("exercicio"));
        jobParametersBuilder.addLong("exercicioComunicado", id.getExercicio());
        return this.jobLauncher.run(this.comunicadoDebitoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

