/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class UpdateCodigoBarrasQRCodeJobStarter {
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    @Qualifier(value="integracaoboletoPixItauBatchJob")
    private final Job updateCodigoBarraQrCodeBatchJob;

    public UpdateCodigoBarrasQRCodeJobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, @Qualifier(value="integracaoboletoPixItauBatchJob") Job updateCodigoBarraQrCodeBatchJob) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.updateCodigoBarraQrCodeBatchJob = updateCodigoBarraQrCodeBatchJob;
    }

    public JobExecution startJob() throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        if (this.existsJobWithSameType(JobType.ALTERA_CODIGO_BARRAS_QR_CODE).booleanValue()) {
            throw new EloValidationException(String.format("J\u00e1 h\u00e1 um Job em execu\u00e7\u00e3o com o tipo %s", JobType.ALTERA_CODIGO_BARRAS_QR_CODE.getTipo()));
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.updateCodigoBarraQrCodeBatchJob, jobParametersBuilder.toJobParameters());
    }

    private Boolean existsJobWithSameType(JobType jobType) {
        return this.jobExplorer.findRunningJobExecutions(jobType.getTipo()).stream().anyMatch(jobExecution -> jobExecution.getStatus().getBatchStatus().name().equals("STARTING"));
    }
}

