/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.enums.SituacaoProtestoTipoRemessa;
import br.com.elotech.tributos.repository.ProtestoRemessaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ProtestoRemessaService
extends CrudService<ProtestoRemessa, Long> {
    private final ContextService contextService;
    private final ProtestoRemessaRepository protestoRemessaRepository;

    public ProtestoRemessa createAndSave() {
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        ProtestoRemessa protestoRemessa = new ProtestoRemessa();
        protestoRemessa.setEntidade(entidadePrincipal);
        protestoRemessa.setExercicio(exercicioAtual);
        protestoRemessa.setUsuario(SecurityUtils.getUserName());
        protestoRemessa.setTipoRemessa(SituacaoProtestoTipoRemessa.R);
        return (ProtestoRemessa)this.protestoRemessaRepository.save((Object)protestoRemessa);
    }

    public Long getQtdRemessaPorData(LocalDate data, SituacaoProtestoTipoRemessa tipoRemessa) {
        return this.protestoRemessaRepository.getQtdRemessaPorData(data, tipoRemessa);
    }

    @Generated
    public ProtestoRemessaService(ContextService contextService, ProtestoRemessaRepository protestoRemessaRepository) {
        this.contextService = contextService;
        this.protestoRemessaRepository = protestoRemessaRepository;
    }
}

