/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracoes.disponibilizados.requerimento;

import br.com.elotech.tributos.dto.integracoes.disponibilizados.requerimentos.ConsultaStatusRequerimentoResponse;
import br.com.elotech.tributos.dto.integracoes.disponibilizados.requerimentos.IntegracaoNovoRequerimentoRequest;
import br.com.elotech.tributos.dto.integracoes.disponibilizados.requerimentos.IntegracaoNovoRequerimentoResponse;
import br.com.elotech.tributos.service.integracoes.disponibilizados.requerimento.IntegracaoNovoRequerimentoService;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/requerimento-integrado"})
public class IntegracaoNovoRequerimentoResource {
    private final IntegracaoNovoRequerimentoService service;

    @PostMapping
    public ResponseEntity<IntegracaoNovoRequerimentoResponse> novoRequerimento(@RequestBody @Valid IntegracaoNovoRequerimentoRequest request) {
        IntegracaoNovoRequerimentoResponse response = this.service.novoRequerimento(request);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{requerimento}/{anoRequerimento}"})
    public ResponseEntity<ConsultaStatusRequerimentoResponse> consultaSituacao(@PathVariable(value="requerimento") Long requerimento, @PathVariable(value="anoRequerimento") Long anoRequerimento) {
        Optional response = this.service.consultarBoleto(requerimento, anoRequerimento);
        return response.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.noContent().build());
    }

    @Generated
    public IntegracaoNovoRequerimentoResource(IntegracaoNovoRequerimentoService service) {
        this.service = service;
    }
}

