/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.AcertoPagamento;
import br.com.elotech.tributos.dto.pagamento.AcertoPagamentoNovoDTO;
import br.com.elotech.tributos.dto.pagamento.AcertoPagamentoResponseDTO;
import br.com.elotech.tributos.service.AcertoPagamentoService;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/acerto-pagamento"})
public class AcertoPagamentoResource {
    private final AcertoPagamentoService acertoPagamentoService;

    public AcertoPagamentoResource(AcertoPagamentoService acertoPagamentoService) {
        this.acertoPagamentoService = acertoPagamentoService;
    }

    @GetMapping(value={"/findall"})
    public ResponseEntity<Page<AcertoPagamentoResponseDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        Page acertoPagamentos = this.acertoPagamentoService.findByRsql(search, pageable);
        return ResponseEntity.ok((Object)acertoPagamentos.map(AcertoPagamentoResponseDTO::of));
    }

    @GetMapping(value={"{id}/resumo"})
    public ResponseEntity<AcertoPagamentoResponseDTO> getResumo(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.acertoPagamentoService.findById((Serializable)id).map(AcertoPagamentoResponseDTO::of).orElseThrow(() -> RestException.notFound((String)String.format("N\u00e3o encontrado Acerto de Pagamento com %d", id))));
    }

    @PostMapping(value={"{id}/estornar"})
    public ResponseEntity<AcertoPagamento> estornarAcertoPagamento(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.acertoPagamentoService.estornoAcerto(id));
    }

    @PostMapping
    public ResponseEntity<AcertoPagamentoResponseDTO> salvaAcertoPagamento(@RequestBody AcertoPagamentoNovoDTO novoPagamento) {
        return ResponseEntity.ok((Object)this.acertoPagamentoService.salvarAcertoPagamento(novoPagamento));
    }
}

