/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.repository.simam.ErrosImportacaoSIMAMCustomRepository;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.time.LocalDate;
import java.util.Map;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class ErrosImportacaoSIMAMCustomRepositoryImpl
implements ErrosImportacaoSIMAMCustomRepository {
    private static final String SQL_DELETE_ERROS = "sql/simam/errosImportacaoSIMAMBatchClear.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    @Transactional
    public void clearErrosImportacao(LocalDate dataInicial, LocalDate dataFinal) {
        String query = FileUtils.readResourceAsString((String)SQL_DELETE_ERROS);
        MapSqlParameterSource params = this.getSqlParams(dataInicial, dataFinal);
        this.namedParameterJdbcTemplate.getJdbcTemplate();
        this.namedParameterJdbcTemplate.execute(query, (SqlParameterSource)params, PreparedStatement::executeLargeUpdate);
    }

    private MapSqlParameterSource getSqlParams(LocalDate dataInicial, LocalDate dataFinal) {
        Map params = this.createSqlParams(dataInicial, dataFinal);
        return new MapSqlParameterSource().addValues(params);
    }

    private Map<String, ?> createSqlParams(LocalDate dataInicial, LocalDate dataFinal) {
        return Map.of("dataInicial", Date.valueOf(dataInicial), "dataFinal", Date.valueOf(dataFinal), "ano", dataInicial.getYear());
    }

    @Generated
    public ErrosImportacaoSIMAMCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

