/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.FiltroArrecadacaoPorTributoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorTributoValoresDTO;
import java.sql.Date;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoPorTributoRepository {
    private static final String SQL_RESUMO_POR_TRIBUTO = "br/com/elotech/tributos/repository/integracaocontabil/consulta-resumo-arrecadacao-por-tributo.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ArrecadacaoPorTributoRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<ArrecadacaoPorTributoValoresDTO> queryArrecadacaoPorTributo(FiltroArrecadacaoPorTributoDTO filtro) {
        StringBuilder sqlBuilder = new StringBuilder();
        String sql = FileUtils.readResourceAsString((String)SQL_RESUMO_POR_TRIBUTO).replace(":FILTRO", filtro.getWhereClausule());
        sqlBuilder.append(sql);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("dataInicio", (Object)Date.valueOf(filtro.getDataInicio()), 91);
        parameters.addValue("dataFim", (Object)Date.valueOf(filtro.getDataFim()), 91);
        return this.namedParameterJdbcTemplate.query(sqlBuilder.toString(), (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorTributoValoresDTO.class));
    }
}

