/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.notification.impl;

import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.client.painel.feign.NotificationWebSocketFeign;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.enums.NotificationStatus;
import br.com.elotech.tributos.notification.NotificationHandler;
import br.com.elotech.tributos.notification.NotifyStepProgress;
import br.com.elotech.tributos.notification.dto.StepStatusDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ValidacaoImportacaoSimAmNotification
extends NotificationHandler
implements NotifyStepProgress {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidacaoImportacaoSimAmNotification.class);
    private static final int TOTAL_DE_STEPS = 14;

    public ValidacaoImportacaoSimAmNotification(Optional<NotificationWebSocketFeign> notificationWebSocketFeign, ObjectMapper objectMapper) {
        super(notificationWebSocketFeign, objectMapper);
    }

    public void notify(StepExecution stepExecution, int itemInprogress, NotificationStatus status) {
        Date competenciaDate = Objects.requireNonNull(stepExecution.getJobParameters().getDate("dataInicial"));
        LocalDate competenciaLocalDate = competenciaDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        int competencia = competenciaLocalDate.getMonthValue();
        String topic = String.join((CharSequence)"_", Tenant.create((String)TenantContextHolder.getCurrentTenantId()).getId(), JobType.VALIDA_REGRAS_IMPORTACAO_SIMAM.toString(), Objects.requireNonNull(stepExecution.getJobParameters().getLong("entidade")).toString(), String.valueOf(competencia), Objects.requireNonNull(stepExecution.getJobParameters().getLong("exercicio")).toString());
        String mensagem = ValidacaoImportacaoSimAmNotification.generateMessage((StepExecution)stepExecution, (NotificationStatus)status);
        double progresso = (double)itemInprogress / 14.0 * 100.0;
        StepStatusDTO stepStatus = StepStatusDTO.builder().status(status).progresso(Integer.valueOf((int)progresso)).message(mensagem).build();
        log.debug("Notificando progresso {} no topico {}", (Object)status, (Object)topic);
        this.notify(topic, (Object)stepStatus);
    }

    private static String generateMessage(StepExecution stepExecution, NotificationStatus status) {
        String mensagem = String.format("Etapa %s finalizada.", stepExecution.getStepName());
        if (status.equals((Object)NotificationStatus.ERROR)) {
            mensagem = String.format("Etapa %s com erro no processamento.", stepExecution.getStepName());
        }
        return mensagem;
    }
}

