/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.enums.sanepar;

import br.com.elotech.core.enumerable.EnumConverter;
import br.com.elotech.core.enumerable.EnumValues;
import br.com.elotech.core.utils.EnumUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import lombok.Generated;

public enum SituacaoItemSanepar implements EnumConverter<SituacaoItemSanepar, String>
{
    IMPORTADO("I", "Importado"),
    ERRO_IMPORTACAO("E", "Erro importa\u00e7\u00e3o"),
    VALIDADO("V", "Validado"),
    ERRO_VALIDACAO("EV", "Erro valida\u00e7\u00e3o"),
    DEBITO_GERADO("D", "D\u00e9bito Gerado"),
    ERRO_GERACAO_DEBITO("ED", "Erro gera\u00e7\u00e3o de d\u00e9bito"),
    BOLETO_GERADO("B", "Boleto Gerado"),
    ERRO_GERACAO_BOLETO("EB", "Erro gera\u00e7\u00e3o de boleto"),
    PAGO("P", "Pago"),
    ERRO_GERACAO_PAGAMENTO("EP", "Erro gera\u00e7\u00e3o de pagamento");

    private String codigo;
    private String descricao;
    public static final EnumValues<SituacaoItemSanepar, String> ENUM_VALUES;

    @JsonCreator
    public static SituacaoItemSanepar fromValue(String codigo) {
        return (SituacaoItemSanepar)ENUM_VALUES.getEnum((Object)codigo);
    }

    public String getValue() {
        return this.codigo;
    }

    public boolean permiteGerarDebito() {
        return Arrays.asList(VALIDADO, ERRO_GERACAO_DEBITO).contains(this);
    }

    public boolean permiteGerarBoleto() {
        return Arrays.asList(DEBITO_GERADO, ERRO_GERACAO_BOLETO).contains(this);
    }

    public boolean permiteBaixa() {
        return Arrays.asList(BOLETO_GERADO, ERRO_GERACAO_PAGAMENTO).contains(this);
    }

    @Generated
    private SituacaoItemSanepar(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    static {
        ENUM_VALUES = EnumUtils.getEnumValuesMap(SituacaoItemSanepar.class);
    }
}

